/**
 * 文件名： EngineServiceImpl.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月21日 下午4:34:40
 */
package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.bigdata.online.service.api.dto.DeviceFilterDto;
import cn.com.duiba.boot.utils.WarningUtils;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.tuia.cache.*;
import cn.com.duiba.tuia.constants.*;
import cn.com.duiba.tuia.dao.engine.ConsumerRecordDAO;
import cn.com.duiba.tuia.dao.material.AdvertMaterialRealtionService;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.domain.vo.*;
import cn.com.duiba.tuia.enums.*;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.duiba.tuia.enums.PlatformTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.filter.AdvertFilterParamVO;
import cn.com.duiba.tuia.filter.service.AdvertFilterService;
import cn.com.duiba.tuia.filter.service.InterestAdvertTagFilter;
import cn.com.duiba.tuia.filter.service.impl.InterestAdvertTagFilterImpl;
import cn.com.duiba.tuia.log.*;
import cn.com.duiba.tuia.message.rocketmq.listener.RefreshDmpAdvertHandler;
import cn.com.duiba.tuia.domain.model.engine.BuildParametersRtn;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.repository.QueryDeviceIdDmpRepository;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.service.AdvertSystemConfigService.AdvertSystemConfigEnum;
import cn.com.duiba.tuia.service.filter.AutoFlowbackFilter;
import cn.com.duiba.tuia.service.filter.LowNeedsAdFilter;
import cn.com.duiba.tuia.service.router.FlowRouterService;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityAdvertDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertmonitor.ActivityAdvert4MonitorDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertmonitor.ActivityDirectMode4MonitorDto;
import cn.com.duiba.tuia.strategy.StrategyBeans;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.tool.SwitchesUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransaction;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.*;
import cn.com.tuia.advert.model.dsp.AdxAdvertPriceDto;
import cn.com.tuia.advert.service.ISpmService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.hazelcast.util.MD5Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.groupingBy;
import static java.util.stream.Collectors.toList;

/**
 * dubbo服务接口实现类<br/>
 * <功能详细描述>.
 *
 * @author: sunjiangrong.
 * @创建时间: 2016年4月21日 下午4:34:42
 * @version:
 */
@Service
public class EngineServiceImpl extends BaseService {

    private static final Logger logger = LoggerFactory.getLogger(EngineServiceImpl.class);


    /**
     * DMP 字符串 截断长度
     */
    public static final int DMP_CUT_LENGTH = 3000;

    /**
     * 生产目前QPS1000/20=50qps，10个线程池处理可以的，可以支撑20ms的5000qps
     * 【异步任务1，耗时6ms】. 获取【全量时间】内用户的，广告和广告点击次数{advertId:num}
     * 【异步任务2，耗时4ms】，风控异步：风控（耗时4ms）qps为1024，串行下一个任务内存过滤（耗时19ms）qps为997，通过率高可以异步执行
     */
    private final ExecutorService executor1 = Executors.newFixedThreadPool(8);
    private final ExecutorService executor2 = Executors.newFixedThreadPool(8);

    @Autowired
    private AdvertPreFilterService advertPreFilterService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private AdvertExposeService advertExposeService;
    @Autowired
    private ConsumerRecordDAO consumerRecordDAO;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private AdvertRecommendService advertRecommendService;
    @Autowired
    private MediaCacheService mediaCacheService;
    @Autowired
    private AdvertMaterialRealtionService advertMaterialRealtionService;
    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;
    @Autowired
    private ConsumerRecordSerivce consumerRecordSerivce;
    @Autowired
    private AppPrivilegeService appPrivilegeService;
    @Autowired
    private AdvertPrivilegeService advertPrivilegeService;
    @Qualifier("advertPrivilegeFilterService")
    @Autowired
    private AdvertFilterService privilegeFilterService;
    @Resource
    private AdvertMaterialRecommendService advertMaterialRecommendService;
    @Autowired
    private AdvertOrderCacheService advertOrderCacheService;
    @Autowired
    private AdvertWhiteService advertWhiteService;
    @Autowired
    private AdvertRealDataService advertRealDataService;
    @Resource
    protected StringRedisTemplate stringRedisTemplate;
    @Autowired
    private RiskChectServiceImpl riskChectService;
    @Autowired
    private RefreshDmpAdvertHandler refreshDmpAdvertHandler;
    @Autowired
    private NewAppTestCacheService newAppTestCacheService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private ResourcesRepeatLunchService resourcesRepeatLunchService;
    @Autowired
    private TradeAppRepeatLunchService tradeAppRepeatLunchService;
    @Autowired
    private  CatMonitorWarnThreshold catMonitorWarnThreshold;
    @Autowired
    private QueryDeviceIdDmpRepository queryDeviceIdDmpRepository;
    @Autowired
    private AdvertLaunchMonitorService advertLaunchMonitorService;
    @Autowired
    private ImitateAdvertService imitateAdvertService;
    @Autowired
    private InterestAdvertTagFilter interestAdvertTagFilter;
    @Autowired
    private LowNeedsAdFilter lowNeedsAdFilter;
    @Autowired
    private AutoFlowbackFilter autoFlowbackFilter;

    @Resource
    private DspComparePriceService dspComparePriceService;
    @Autowired
    private RepeatAdvertTestService repeatAdvertTestService;
    @Autowired
    private TransferDayuService transferDayuService;
    @Autowired
    private ApolloConfig apolloConfig;

    @Autowired
    private ISpmService iSpmService;

    @Autowired
    private TransferService transferService;

    @Autowired
    private ExpAppLimitReleaseService expAppLimitReleaseService;

    @Autowired
    private ExpNetCarrierService expNetCarrierService;

    @Autowired
    private FlowRouterService flowRouterService;

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    @Autowired
    private WhiteListService whiteListService;

    /**
     * 兑吧请求一个广告.
     * ThreadLocal
     *
     * @param req the req
     * @return the obtain advert rsp
     */
    @SuppressWarnings("squid:S3776")
    @Deprecated
    public ObtainAdvertRsp obtainAdvert(ObtainAdvertReq req) {
        DBTimeProfile.enter("EngineServiceImpl.obtainAdvert");
        ObtainAdvertRsp rsp = new ObtainAdvertRsp();
        rsp.setSlotId(req.getSlotId());
        rsp.setResult(false);
        FilterResult filterResult = new FilterResult();

        // 广告过滤日志
        AdvertFilter advertFilter = new AdvertFilter();
        advertFilter.setAppId(req.getAppId());
        advertFilter.setSlotId(req.getSlotId());
        advertFilter.setOrderId(req.getOrderId());
        advertFilter.setActivityId(req.getActivityId());

        ShieldStrategyVO shieldStrategyVO = null;
        Map<Long, AdvertFilterVO> validAdverts = null;
        try {

            // 1.参数组装
            BuildParametersRtn parametersRtn = CatUtil.executeInCatTransaction(() -> buildParameters(req, rsp), "obtainAdvert", "buildParameters");

            AdvQueryParam advQueryParam = parametersRtn.getAdvQueryParamTmp();
            AppDetail appDetail = parametersRtn.getAppDetail();

            shieldStrategyVO = parametersRtn.getShieldStrategyVO();
            String cityId = parametersRtn.getCity();
            ConsumerDto consumerDto = parametersRtn.getConsumerDto();
            filterResult = parametersRtn.getFilterResult();


            final AdvQueryParam advQueryParamTmp = advQueryParam;

            // 添加 advQueryParam 请求日志
            if (logConfig.getInfoEnable()) {
                logger.info("请求参数日志，orderId ={}，consumerId={}, param={}，appDetail={}", req.getOrderId(), req.getConsumerId(), JSON.toJSONString(advQueryParam), JSON.toJSONString(appDetail));
            }

            // 2.风控反作弊接口，命中则走特权库发券
            FilterResult finalFilterResult = filterResult;
            FutureTask<Map<String, Integer>> doRiskCheckTask = null;
            try {
                ShieldStrategyVO finalShieldStrategyVO = shieldStrategyVO;
                doRiskCheckTask =  new FutureTask<>(() ->
                        doRiskCheck(req, rsp, finalFilterResult, finalShieldStrategyVO, appDetail, advQueryParamTmp, advertFilter));
                executor2.submit(doRiskCheckTask);
            } catch (Exception e) {
                logger.error("EngineServiceImpl.obtainAdvert 风控反作弊接口：",e);
            }

            // 3.过滤合法且有效的广告,得到预过滤的广告id列表。特别注意：查询出来的有效广告列表为无序的，在推荐算法发券不成功,降级处理中实现了排序
            validAdverts = CatUtils.executeInCatTransaction(() -> advertPreFilterService.preFilterAdvertWithEsHystrix(advQueryParamTmp, req, finalFilterResult, advertFilter), "obtainAdvert", "memoryFilter");

            // 2.风控反作弊接口，异步返回结果
            // 【注意】异步两处不会产生冲突，preFilterAdvertWithEsHystrix设置的是advertIds等，而风控设置的是advertId
            // 两者没有冲突，其实理论上而言，内存过滤是独立的匹配逻辑，更适合剥离主线程之外，作为异步，这里只是说明两者异步不冲突
            Map<String, Integer> mapRiskResult = new HashMap<>(2);
            try {
                if (null != doRiskCheckTask) {
                    mapRiskResult = doRiskCheckTask.get();
                }
            } catch (Exception e) {
                logger.error("EngineServiceImpl.obtainAdvert 异步风控出错：",e);
            }
            Integer isRiskTrueOne = mapRiskResult.get("flag");
            // 异步不能反悔 boolean ,这里1代表true被风控了，0代表false
            if (null!=isRiskTrueOne && 1==isRiskTrueOne) {
                return rsp;
            }

            // 过滤后,只有有广告时才需要去做其他逻辑
            if (validAdverts.size() > 0) {

                //特殊白名单过滤
                autoFlowbackFilter.doFilter(validAdverts,req);
                if(MapUtils.isEmpty(validAdverts)){
                    return rsp;
                }

                // 4.8直接返回：直接中广告、商业活动白名单、媒体白名单
//                FilterResult finalFilterResult2 = filterResult;
//                Map<Long, AdvertFilterVO> validAdvertsTmp2 = validAdverts;
//                boolean checkReturnFlag;
//                =  CatUtils.executeInCatTransaction(() -> whiteCheckReturn(req, rsp, finalFilterResult2, validAdvertsTmp2, appDetail, advertFilter) , "obtainAdvert", "recommendAdvertCheck1");

//                filterResult = finalFilterResult2;
//                validAdverts = validAdvertsTmp2;
//                if (checkReturnFlag) {
//                    return rsp;
//                }

                //推啊活动白名单 和 广告位白名单 都在这了
                validAdverts = whiteListService.doWhiteListBusiness(req, rsp, filterResult, validAdverts, appDetail, advertFilter);

                // 重复发券过滤
                validAdverts = repeatLunch(filterResult, validAdverts, advQueryParam, advertFilter);
                // 4.9直接返回：新媒体测试、DMP数据测试
                FilterResult finalFilterResult3 = filterResult;
                Map<Long, AdvertFilterVO> validAdvertsTmp3 = validAdverts;
                boolean checkReturnFlag =  CatUtils.executeInCatTransaction(() -> testCheckReturn(req, rsp, finalFilterResult3, validAdvertsTmp3,advQueryParam, advertFilter) , "obtainAdvert", "recommendAdvertCheck2");
                filterResult = finalFilterResult3;
                validAdverts = validAdvertsTmp3;
                if (checkReturnFlag) {
                    return rsp;
                }

                //用户低意向广告过滤
                lowNeedsAdFilter.doFilter(validAdverts,filterResult,req,advertFilter);

                Map<Long, AdvertFilterVO> validAdvertsTmp = validAdverts;

                // 5.哪吒算法推荐出券
                Map<Long, AdvertFilterVO> newValidAdverts = CatUtils.executeInCatTransaction(() -> recommendAdvert(validAdvertsTmp, advQueryParam, finalFilterResult, req, rsp, consumerDto,appDetail, advertFilter) , "obtainAdvert", "recommendAdvert");

                // 6.如果推荐算法发券不成功，则需要降级处理，走原来的投放逻辑
                if (!rsp.isResult()) {
                    if (FilterResult.RECMD_VAILD_LIST_TYPE != filterResult.getType()) {
                        filterResult.setType(FilterResult.RECMD_DEGRADE_TYPE);
                    }
                    // 6.1降级后的核心逻辑
                    List<AdvertFilterVO> advertFilterVOList = degradeAdverts(req, rsp, filterResult, validAdverts, newValidAdverts, advertFilter);
                    // 6.2付费券没有中之后,降级中免费券
                    if (!rsp.isResult()) {
                        this.doFreeAdverts(req, rsp, advertFilterVOList, filterResult, advertFilter);
                    }
                }
            } else {

                CatUtil.catLog(CatGroupEnum.CAT_102003.getCode());//内存过滤-其他动态过滤后有效配置为空
                WarningUtils.markThresholdWarning("esOrDynaFilterNoData", catMonitorWarnThreshold.getEsFilterNoData());

                // 如果活动不是仅投 并且 福袋开启  走 dsp竞价
                if (!isOnlyPutActivity(req)
                        && isSendLucky(appDetail, StrategyBeans.shieldingStrategyMap.get(rsp.getStrategyType()))
                        && rsp.getDspCompare()==null) {
                    rsp.setDspCompare(true);
                }


            }

            //14.如果没有结果走特权库
            if (!rsp.isResult()) {
                filterResult.setType(FilterResultTypes.NORMAL_PRIVILEGE);
            }
            privilegeFilter(filterResult, req, shieldStrategyVO, cityId, rsp, appDetail, advQueryParam, advertFilter);

            //15.如果最终没有匹配到广告,则记录为遍历
            if (!rsp.isResult()) {
                CatUtil.catLog(CatGroupEnum.CAT_102004.getCode());
                filterResult.setResultCode(ErrorCode.E0500003.getErrorCode());
            }
        } catch (Throwable ex) {
            if (ex instanceof TuiaException) {
                //发券失败监控
                TuiaException
                        e = (TuiaException) ex;
                CatUtil.catLog("obtainAdvertError" + e.getResultCode());
                WarningUtils.markThresholdWarning("obtainAdvertError", catMonitorWarnThreshold.getObtainAdvertError());
                filterResult.setResultCode(e.getResultCode());
            } else {
                //发券异常监控
                CatUtil.catLog(CatGroupEnum.CAT_102009.getCode());
                filterResult.setResultCode(ErrorCode.E9999999.getErrorCode());
                WarningUtils.markThresholdWarning("obtainAdvertException", catMonitorWarnThreshold.getObtainAdvertExc());
                logger.error("obtainAdvert is exception ", ex);
            }
        } finally {
            filterResult.setStrategyType(rsp.getStrategyType());

            // 组装广告过滤日志
            try {
                packAdvertFilterLog(advertFilter, filterResult, validAdverts);

                // 清空重复发券与nezha过滤
                filterResult.setNezhaFilterMap(null);
            }catch (Exception e){
                logger.error("packAdvertFilterLog is exception ", e);
            }

            AdvertFilterLog.log(advertFilter);
            FilterResultLog.innerLog(filterResult);
            DBTimeProfile.release();

            filterResult.setShieldStrategyVO(shieldStrategyVO);

            // 发送监控消息
            advertLaunchMonitorService.monitorHandle(filterResult);
        }
        return rsp;
    }

    /**
     * 判断福袋是否开启
     * @param appDetail
     * @param shieldingStrategy
     * @return
     */
    public boolean isSendLucky(AppDetail appDetail, ShieldingStrategyService shieldingStrategy) {
        //判断福袋是否开启
        return shieldingStrategy.isSendLuckybag(appDetail.getObjParam());
    }

    /**
     * 活动是否是仅投广告类型
     * @param req
     * @return
     */
    public boolean isOnlyPutActivity(ObtainAdvertReq req) {
        if (req.getActivityUseType() == 0){
            return false;
        }
        // 1.传参为null，直接降级。（过度阶段，后期严格校验参数后删除）
        if (req.getDuibaActivityId() == -1L && req.getDuibaActivityType() == 1) {
            return false;
        }
        // 2.查询定制化活动信息，判断是否开启定制化广告
        Optional<ActivityAdvert4MonitorDto> info = serviceManager.getBusinessActivityCache(req.getDuibaActivityId(), req.getActivityUseType());
        //没有活动信息，或者没有开启定制化广告，可回退降级
        if (!info.isPresent()) {
            return false;
        }
        ActivityAdvert4MonitorDto dto = info.get();
        // 区分仅投定制化广告还是优先投放定制化广告
        // 投放模式
        ActivityDirectMode4MonitorDto typeDto = dto.getDirectMode4MonitorDto();
        return typeDto != null && typeDto.getDirectAdvertMode() != null && typeDto.getDirectAdvertMode() == 1;
    }

    /**
     * 虚拟广告模拟请求发券
     *
     * @param req
     * @return
     * @throws cn.com.tuia.advert.exception.ReadableMessageException
     */
    @Deprecated
    public ObtainAdvertRsp imitateObtainAdvert(ObtainAdvertReq req) throws ReadableMessageException {
        return imitateAdvertService.imitateObtainAdvert(req);
    }

    /**
     * 直接返回：新媒体测试、DMP数据测试
     * @param req
     * @param rsp
     * @param filterResult
     * @param validAdverts
     * @return
     * @throws TuiaException
     */
    @CatTransaction(type = "obtainAdvert", name = "recommendAdvertCheck2")
    public boolean testCheckReturn(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts, AdvQueryParam advQueryParam, AdvertFilter advertFilter) throws TuiaException {
        // 13.4新媒体测试
        boolean isTestApp = newAppTestCacheService.doNewAppTestAdvert(req, rsp, filterResult, filterResult.getNewAppTestAdvertBackUpMap(), advertFilter);
        if (isTestApp) {
            return true;
        }

        //DMP数据测试
        boolean isDmp = doDmpDataTest(req, rsp, filterResult, validAdverts,advQueryParam.getUserInterest(), advertFilter);
        if (isDmp) {
            return true;
        }
        return false;
    }

    /**
     * 直接返回：直接中广告、商业活动白名单、媒体白名单
     * @param req
     * @param rsp
     * @param filterResult
     * @param validAdverts
     * @param appDetail
     * @return
     * @throws TuiaException
     */
    @CatTransaction(type = "obtainAdvert", name = "recommendAdvertCheck1")
    public boolean whiteCheckReturn(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts, AppDetail appDetail ,AdvertFilter advertFilter) throws TuiaException {
        //13.1推啊活动配置广告ID，直接中广告
        boolean isAdvert = doTuiaActivityAdvert(req, rsp, filterResult, validAdverts, advertFilter);
        if (isAdvert) {
            return true;
        }

        //13.2商业活动白名单,兑吧活动白名单已去掉
        boolean isWhiteList = doBusinessActivityWhiteList(req, rsp, filterResult, validAdverts, advertFilter);
        if (isWhiteList) {
            return true;
        }

        //13.3媒体白名单策略
        boolean doAppWhiteListRsp = doAppWhiteList(req, rsp, filterResult, appDetail, validAdverts, StrategyBeans.shieldingStrategyMap.get(rsp.getStrategyType()), advertFilter);
        if (doAppWhiteListRsp) {
            return true;
        }









        return false;
    }


    /**
     * nezha 推荐广告
     *
     * @param validAdverts
     * @param advQueryParam
     * @param filterResult
     * @param req
     * @param rsp
     * @param consumerDto
     * @return
     * @throws TuiaException
     */
    @CatTransaction(type = "obtainAdvert", name = "recommendAdvert")
    public Map<Long, AdvertFilterVO> recommendAdvert(Map<Long, AdvertFilterVO> validAdverts, AdvQueryParam advQueryParam, FilterResult filterResult, ObtainAdvertReq req, ObtainAdvertRsp rsp, ConsumerDto consumerDto, AppDetail appDetail, AdvertFilter advertFilter) throws TuiaException {

        //第二次进行参数构建，主要是哪吒推荐的参数
        advertPreFilterService.secondBuildAdvQueryParam(advQueryParam, req, filterResult);

        // 调用推荐层进行投放逻辑
        advertRecommendService.doObtainRecommendAdvert(req, rsp, filterResult, validAdverts, advQueryParam, consumerDto, appDetail, advertFilter);

        return  validAdverts;
    }

    /*class BuildParametersRtn{
        private FilterResult filterResult;

        private AdvQueryParam advQueryParamTmp;

        private AppDetail appDetail;

        private ShieldStrategyVO shieldStrategyVO;
        private String city;

        private ConsumerDto consumerDto;

        public BuildParametersRtn(FilterResult filterResult, AdvQueryParam advQueryParamTmp, AppDetail appDetail, ShieldStrategyVO shieldStrategyVO, String city,ConsumerDto consumerDto) {
            this.filterResult = filterResult;
            this.advQueryParamTmp = advQueryParamTmp;
            this.appDetail = appDetail;
            this.shieldStrategyVO = shieldStrategyVO;
            this.city = city;
            this.consumerDto = consumerDto;
        }

        public FilterResult getFilterResult() {
            return filterResult;
        }

        public void setFilterResult(FilterResult filterResult) {
            this.filterResult = filterResult;
        }

        public AdvQueryParam getAdvQueryParamTmp() {
            return advQueryParamTmp;
        }

        public void setAdvQueryParamTmp(AdvQueryParam advQueryParamTmp) {
            this.advQueryParamTmp = advQueryParamTmp;
        }

        public AppDetail getAppDetail() {
            return appDetail;
        }

        public void setAppDetail(AppDetail appDetail) {
            this.appDetail = appDetail;
        }

        public ShieldStrategyVO getShieldStrategyVO() {
            return shieldStrategyVO;
        }

        public void setShieldStrategyVO(ShieldStrategyVO shieldStrategyVO) {
            this.shieldStrategyVO = shieldStrategyVO;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public ConsumerDto getConsumerDto() {
            return consumerDto;
        }

        public void setConsumerDto(ConsumerDto consumerDto) {
            this.consumerDto = consumerDto;
        }
    }*/


    @SuppressWarnings("squid:S3776")
    public BuildParametersRtn buildParameters(ObtainAdvertReq req, ObtainAdvertRsp rsp) throws Exception {

        try {
            // 用户记录,全量数据
            Map<String, Integer> allUserAdxMap = new HashMap<>();
            FutureTask<Map<Long, Integer>> allUserTimesMapTask = null;
            try {
                // 【异步任务1，耗时6ms】. 获取【全量时间】内用户的，广告和广告点击次数{advertId:num}
                int recordKeepDays = serviceManager.getIntValue(AdvertSystemConfigureConstants.ADVERT_REPEAT_RECORD_KEEP_DAYS);
                allUserTimesMapTask = new FutureTask<>(() ->  consumerRecordSerivce.getHistoryAdvertTimes(req, recordKeepDays, allUserAdxMap));
                executor1.submit(allUserTimesMapTask);
            } catch (Exception e) {
                logger.error("EngineServiceImpl.buildParameters 用户记录异步开启异常：",e);
            }

            // 1.参数校验
            checkObtainAdvertReq(req);

            boolean activityPriorityCondition = commonService.isMeetActivityPriorityCondition(req.getLogExtMap(), req.getIpAreaDto());

            //提前获取dmp信息（这里可能包含了根据deviceId获取到的地理位置信息）
            final DeviceTagDto deviceTagDto = advertPreFilterService.getDmpTagData(req.getDeviceId(), activityPriorityCondition);
            FilterResult filterResult = new FilterResult(req,null);

            // 2.获取ip对应的城市id
            AdvQueryParam advQueryParam = commonService.ipGeoAnalysis(req.getIp(), req.getIpAreaDto(), req.getLogExtMap(), req.getDeviceId(), activityPriorityCondition, deviceTagDto, filterResult);

            // 2.1 【信标库】运营商覆盖 @link NetCarrierEnum： 1"移动"；2"联通"；3"电信"
            if (apolloPanGuService.getIdMapStrIsOne(ApolloPanGuConstant.IP_BEACON_REPLACE_SWITCH)) {
                Integer netCarrier = req.getNetCarrier();
                String netCarrierStr = null == netCarrier ? OperatorsEnum.OTHER.getCode().toString() : netCarrier + "";
                // OperatorsEnum : CMCC(1,"移动","mobile"), WCDMA(2,"联通","unicom"), CDMD(3,"电信","telecom"), OTHER(4,"unknow","unknow");
                advQueryParam.setOperators(netCarrierStr);
            }

            String cityId = advQueryParam.getRegionId();
            filterResult.setCityId(cityId);
            Optional.ofNullable(deviceTagDto.getRegionInfoTags()).ifPresent(temp -> filterResult.setDmpRegion(JSON.toJSONString(temp)));

            //remote 查询 dmp 人群包。
            final Map<String, String> newUserDmpTagsMap = interestAdvertTagFilter.getThirdPartDmpTag(req);

            //查询设备过滤信息
            final DeviceFilterDto deviceData = advertPreFilterService.getDeviceFilterDto(req.getDeviceId());

            // [重复发券测试需求]计算重复发券用户分流
            RepeatTestGroup repeatTestGroup = repeatAdvertTestService.calculateRepeatTestGroup(req.getConsumerId());
            if (null == req.getLogExtExpMap()) {
                req.setLogExtExpMap(new HashMap<>());
            }
            if (null != repeatTestGroup && null != repeatTestGroup.getGroup()) {
                advQueryParam.setRepeatTestGroup(repeatTestGroup);
                filterResult.setRepeatTestGroup(repeatTestGroup.getGroup());
                filterResult.setRepeatTestGroupInterval(repeatTestGroup.getInterval());
                req.getLogExtExpMap().put("repeatTestGroup", repeatTestGroup.getGroup());
            } else {
                filterResult.setRepeatTestGroup(RepeatAdvertTestConstant.DEFAULT_GROUP);
                req.getLogExtExpMap().put("repeatTestGroup", RepeatAdvertTestConstant.DEFAULT_GROUP);
            }

            // 补充 logExtExpMap 参数，用于后续全链路日志打印
            addToLogExtExpMap(req);

            // 根据大禹,入口处做分流切流
            transferDayuService.dayuCutByMajorOcpc(req, advQueryParam);

            String layerCode = buildLayerCode(req);

            //调用实验平台 获取 实验结果
            ABResult abResult = flowRouterService.abtestHandleResult(req, layerCode);

            //根据全链路 传递的 ab测试 实验 转化数据
            transferService.transferAbtestData(req, advQueryParam);

            //限流媒体 释放 实验 参数
            expAppLimitReleaseService.buildExpParam(req, advQueryParam, abResult);

            //4g运营商实验
            expNetCarrierService.buildExpParam(advQueryParam,abResult);

            // 3.打印请求日志
            SpmLog.log(req, SpmType.SPM_LOG_REQUEST);
            bagCityIdInLogMap(req, cityId);
            bagDmpPackageInLogMap(req,deviceTagDto,newUserDmpTagsMap);
            StatRequestJsonLog.log(req);

            // 4.获取用户领取记录，【最大周期内的】
            List<ConsumerInteractiveRecordDO> consumerVOList = new ArrayList<>();
            try {
                consumerVOList = CatUtils.executeInCatTransaction(() -> getConsumerRecord(req.getConsumerId()),
                        "buildParametersWzj","getConsumerRecord");
            }catch (Throwable throwable){
                logger.error("EngineServiceImpl.buildParameters.getConsumerRecord 报错了",throwable);
            }

            // 5.查询该用户在重复领取天数内领取过的广告ID列表 以及dsp adx 广告已发送的广告列表
            List<Long> receiveAdvertIds = advertOrderCacheService.getReceiveAdvertIds(consumerVOList,advQueryParam);

            //获取推啊广告的用户领取记录，排除dsp 广告
            List<ConsumerInteractiveRecordDO> consumerList = consumerVOList.stream().filter(dto -> {
                ConsumerRecordJsonVO vo = JSON.parseObject(dto.getJson(), ConsumerRecordJsonVO.class);
                return vo == null || vo.getDspId() == null;
            }).collect(Collectors.toList());
            //FilterResult的用户领券记录 相关设值
            consumerService.setFilterResultConsumeList(filterResult, consumerList);
            List<ConsumerInteractiveRecordDO> todayConsumeList = filterResult.getTodayConsumeList();

            // 6.相同活动下每天用户领取限制判断
            checkActivityLimit(req.getConsumerId(), req.getActivityId(), todayConsumeList, req.getActReceiveType());

            // 7.获取当前请求的应用信息和屏蔽策略
            AppDetail appDetail = mediaCacheService.getAppDetailCache(req.getAppId(), req.getSlotId(), rsp, req.getProxy(), cityId, req);
            ShieldStrategyVO shieldStrategyVO = appDetail.getShieldStrategyVO();
            filterResult.setShieldMaterialTags(shieldStrategyVO.getShieldMaterialTags());
            filterResult.setAdvBannedTag(shieldStrategyVO.getAdvBannedTag());

            ConsumerDto consumerDto = new ConsumerDto();
            consumerDto.setConsumerId(req.getConsumerId());
            consumerDto.setDeviceId(req.getDeviceId());
            Map<String, String> logExtExpMap = Optional.ofNullable(req.getLogExtExpMap()).orElse(new HashMap<>());
            consumerDto.setOneId(logExtExpMap.get(AdvertReqLogExtKeyConstant.ONE_ID));
            consumerDto.setOneIdType(logExtExpMap.get(AdvertReqLogExtKeyConstant.ONE_ID_TYPE));
            consumerDto.setOpenId(logExtExpMap.get(AdvertReqLogExtKeyConstant.OPEN_ID));
            // 8.封装过滤参数
//            advQueryParam = advertPreFilterService.buildAdvQueryParam(advQueryParam, req, rsp, shieldStrategyVO, consumerVOList, receiveAdvertIds, consumerDto, filterResult);
            final AdvQueryParam advQueryParamTmp = advQueryParam;
            final List<ConsumerInteractiveRecordDO> consumerVOListTmp = consumerList;
            try {
                advQueryParam = CatUtils.executeInCatTransaction(() -> advertPreFilterService.buildAdvQueryParam(advQueryParamTmp, req, rsp, shieldStrategyVO, consumerVOListTmp, receiveAdvertIds, consumerDto, filterResult, deviceTagDto,newUserDmpTagsMap),"buildParametersWzj","buildAdvQueryParam");
            } catch (Throwable throwable) {
                if(throwable instanceof Exception){
                    throw (Exception)throwable;
                }else {
                    // cat监控报错了，一般不会触发的
                    logger.error("EngineServiceImpl.buildParameters error", throwable);
                }
            }

            //设置过滤参数
            advQueryParam.setDeviceFilterDto(deviceData);
            advQueryParam.setActivitySceneType(req.getActivitySceneType());
            advQueryParam.setVideoSpecification(req.getVideoSpecification());

            // 9.打印用户对应相似行业人群接受度
            SimilarAdvertStatLog.log(advQueryParam.getSimilarAdvertLogList());
            buildFilterResult(filterResult, advQueryParam);

            // 设置查询时间
            SlotDO sd = appDetail.getSlotDO();
            if(sd != null){
                filterResult.setSlotTagQueryTime(sd.getSlotTagQueryTime());
            }

            AppDO ad = appDetail.getAppDO();
            if(ad != null){
                filterResult.setAppTagQueryTime(ad.getAppTagQueryTime());
            }

            // 互选媒体时间
            filterResult.setAdvertSelectedDto(advQueryParam.getAdvertSelectedDto());
            filterResult.setAdvertAndMaterial4AdDtoSet(advQueryParam.getAdvertAndMaterial4AdDtoSet());

            // 丰富过滤日志参数，mysqlgroup获取的广告发券次数数据异步处理掉了
            Map<Long, Integer> allUserTimesMap = new HashMap<>();
            try {
                if (null != allUserTimesMapTask) {
                    allUserTimesMap = allUserTimesMapTask.get();
                }
            } catch (Exception e) {
                logger.error("EngineServiceImpl.buildParameters 用户记录异步获取点击数异常：",e);
            }
            filterResult.setAllUserTimesMap(allUserTimesMap);
            filterResult.setAllUserAdxMap(allUserAdxMap);
            return new BuildParametersRtn(filterResult, advQueryParam, appDetail, shieldStrategyVO, cityId, consumerDto);

        }catch (Exception e){
            if(e instanceof TuiaException){
            }else {
                logger.error("buildParameters error", e);
            }
            throw e;
        }
    }

    private String buildLayerCode(ObtainAdvertReq req) {

        StringBuilder layerCodeBuilder = new StringBuilder();

        layerCodeBuilder.append(expAppLimitReleaseService.getLayerCode());

        if (Objects.equals(NetTypeEnum.GSM.getCode(),req.getNetType())) {
            layerCodeBuilder.append(",").append(expNetCarrierService.getLayerCode());
        }

        return layerCodeBuilder.toString();

    }

    private ObtainAdvertReq bagDmpPackageInLogMap(ObtainAdvertReq req, DeviceTagDto deviceTagDto, Map<String, String> newUserDmpTagsMap) {

        List<String> packageList = new LinkedList<>();
        Optional.ofNullable(deviceTagDto.getOfflineTagPackage()).ifPresent(tags->packageList.addAll(tags));
        Optional.ofNullable(deviceTagDto.getBusinessTagPackage()).ifPresent(tags->packageList.addAll(tags));


        newUserDmpTagsMap.forEach((key,value)->{
            if(null != value && InterestAdvertTagFilterImpl.NEW_DMP_HIT_VALUE.equals(value)){
                packageList.add(key);
            }
        });

        String packageStr = StringTool.getStringByList(packageList);
        //超过3k,截断
        if(packageStr.length() > DMP_CUT_LENGTH){
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE , dealStr(packageStr,DMP_CUT_LENGTH));
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE_IS_TOO_LONG , "1");
        }else{
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE , packageStr);
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DMP_PACKAGE_IS_TOO_LONG , "0");
        }

        return req;
    }

    private String dealStr(String packageStr,int length) {
        try{
            String substring = packageStr.substring(0, length);
            int index = substring.lastIndexOf(",");
            return index>0?substring.substring(0,index):"";
        }catch (Exception e){
            logger.error("dmp 日志截断异常",e);
            return "";
        }
    }

    public void packAdvertFilterLog(AdvertFilter advertFilter, FilterResult filterResult, Map<Long, AdvertFilterVO> advertFilterVOMap) {
        if(MapUtils.isEmpty(advertFilterVOMap)){
            return;
        }

        // 出券的计划id
        Long advertId = filterResult.getSuccessId();

        // 出券的配置id
        Long orientationId = filterResult.getPlanId();

        Set<AdvertFilterType> advertFilterList = advertFilter.getReason();

        // 过滤
        advertFilterVOMap.forEach((k, v) ->{
            // 计划配置集
            Set<AdvertPriceVO> orientationSets = v.getAdvertPriceVOSortedSet();

            orientationSets.forEach(vo ->{
                if (k.equals(advertId) && vo.getAdvertOrientationPackageId().equals(orientationId)) {
                }else {
                    advertFilterList.add(new AdvertFilterType(v.getAdvertId(), vo.getAdvertOrientationPackageId(), fetchFilterType(filterResult)));
                }
            });
        });

        // 追加重复发券与nezha过滤
        addOtherFilter(advertFilterList, filterResult);

        advertFilter.setReason(advertFilterList);
    }

    private void addOtherFilter(Set<AdvertFilterType> advertFilterList, FilterResult filterResult) {

        Map<Long, AdvertFilterVO> nezhaFilterMap = filterResult.getNezhaFilterMap();

        List<RecommendOrient> recomAdIds = filterResult.getRecomAdIds();
        List<RecommendOrient> recomFreeAdIds = filterResult.getRecomFreeAdIds();
        Integer nezhaLaunchStatus = filterResult.getNezhaLaunchStatus();
        Long rcmdAdvertId = filterResult.getRcmdAdvertId();
        Long rcmdPackageId = filterResult.getRcmdPackageId();
        boolean isOrderCustom = filterResult.isOrderCustom();
        Map<String, Integer> orderCustomFilter = filterResult.getOrderCustomFilter();


        if(MapUtils.isNotEmpty(nezhaFilterMap)){
            nezhaFilterMap.forEach((k, v) -> {

                v.getAdvertPriceVOSortedSet().forEach(vo ->{
                    AdvertFilterType advertFilterType = new AdvertFilterType(k, vo.getAdvertOrientationPackageId(), AdvertFilterTypeEnum.BEFORE_RECOMMEND.getCode());
                    advertFilterList.remove(advertFilterType);
                    advertFilterList.add(advertFilterType);
                });
            });
        }

        //哪吒推荐中失败的（排名不是第一的）
        if(CollectionUtils.isNotEmpty(recomAdIds)){
            recomAdIds.forEach(vo ->{
                Long ad = vo.getAd();
                Long pk = vo.getPk();
                if (Objects.equals(CommonConstant.YES,nezhaLaunchStatus) && ad.equals(rcmdAdvertId) && pk.equals(rcmdPackageId)) {
                    //跳过
                } else if (isOrderCustom) {
                    Integer order = orderCustomFilter.get(ad + "-" + pk);
                    String filterType;
                    if (Objects.equals(order, 1)) {
                        filterType = AdvertFilterTypeEnum.ORDER_CUSTOM_FIRST.getCode();
                    } else if (null != order){
                        filterType = AdvertFilterTypeEnum.ORDER_CUSTOM_OTHER.getCode();
                    } else {
                        filterType = AdvertFilterTypeEnum.RECOMMEND_FAILED.getCode();
                    }
                    AdvertFilterType advertFilterType = new AdvertFilterType(ad, pk, filterType);
                    advertFilterList.remove(advertFilterType);
                    advertFilterList.add(advertFilterType);
                } else {
                    AdvertFilterType advertFilterType = new AdvertFilterType(ad, pk, AdvertFilterTypeEnum.RECOMMEND_FAILED.getCode());
                    advertFilterList.remove(advertFilterType);
                    advertFilterList.add(advertFilterType);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(recomFreeAdIds)) {
            recomFreeAdIds.forEach(vo ->{
                Long ad = vo.getAd();
                Long pk = vo.getPk();
                if (Objects.equals(CommonConstant.YES,nezhaLaunchStatus) && ad.equals(rcmdAdvertId) && pk.equals(rcmdPackageId)) {
                    //跳过
                }else {
                    AdvertFilterType advertFilterType = new AdvertFilterType(ad, pk, AdvertFilterTypeEnum.RECOMMEND_FAILED.getCode());
                    advertFilterList.remove(advertFilterType);
                    advertFilterList.add(advertFilterType);
                }
            });
        }

    }

    private String fetchFilterType(FilterResult filterResult) {
        String result = "";
        int type = filterResult.getType();

        switch (type){

            // 活动定制广告
            case FilterResult.TUIA_ACTIVITY_CONFIG_ADVERT:
                result = AdvertFilterTypeEnum.ACTIVITY_ADVERT.getCode();
                break;

            // 活动白名单
            case FilterResultTypes.CUSTOMIZED_AD:
                result = AdvertFilterTypeEnum.ACTIVITY_WHITE.getCode();
                break;

            // 广告位白名单与媒体白名单
            case FilterResultTypes.SLOT_WHITE_LIST:
            case FilterResultTypes.APP_WHITE_LIST:
                result = AdvertFilterTypeEnum.APP_WHITE.getCode();
                break;

            // 新媒体测试
            case FilterResultTypes.NEW_APP_TEST_ADVERT_TYPE:
                result = AdvertFilterTypeEnum.NEW_APP_TEST.getCode();
                break;

            // DMP测试
            case FilterResultTypes.DMP_TYPE:
                result = AdvertFilterTypeEnum.DMP_TEST.getCode();
                break;
            default:
                result = AdvertFilterTypeEnum.UNKNOW.getCode();
                break;
        }

        return result;
    }

    /**
     *
     * repeatLunch:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author chencheng
     * @param filterResult
     * @param validAdverts
     * @param advQueryParam
     * @return
     * @since JDK 1.8
     */
    public Map<Long, AdvertFilterVO> repeatLunch(FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts,
                                                  AdvQueryParam advQueryParam,AdvertFilter advertFilter) {
//        LogInfoPrintTools.start();
        // 行业标签过滤
        Map<Long, AdvertFilterVO> resultMap = tradeAppRepeatLunchService.tradeAppRepeatLunch(filterResult, validAdverts);
//        LogInfoPrintTools.log("1.行业标签过滤end");
        // 资源标签过滤
        resultMap = resourcesRepeatLunchService.resourcesRepeatLunch(filterResult, resultMap, advQueryParam.getPlatform());
//        LogInfoPrintTools.log("2.资源标签过滤end");
        // 重复发券过滤集记录到filterResult
        recordRepeatLunchDiffInFilterResult(filterResult, validAdverts, resultMap, advertFilter);
//        LogInfoPrintTools.end();
        return resultMap;
    }

    /**
     * 重复发券过滤集记录到filterResult
     *
     * @param filterResult
     * @param validAdverts
     * @param resultMap
     */
    private void recordRepeatLunchDiffInFilterResult(FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts,
                                                     Map<Long, AdvertFilterVO> resultMap,AdvertFilter advertFilter) {

        // 被重复发券过滤掉的配置集
        MapDifference<Long, AdvertFilterVO> diffMap = Maps.difference(validAdverts, resultMap);
        if(!diffMap.areEqual()){

            // validAdverts比resultMap多的数据集，即被重复发券过滤掉的配置集
            Map<Long, AdvertFilterVO> filterMap = diffMap.entriesOnlyOnLeft();
            if(MapUtils.isNotEmpty(filterMap)){

                //添加过滤原因日志
                Set<AdvertFilterType> reason = advertFilter.getReason();
                if(null != reason && MapUtils.isNotEmpty(filterMap)){
                    for (AdvertFilterVO filterAdvert : filterMap.values()) {
                        Set<AdvertPriceVO> orientationSets = filterAdvert.getAdvertPriceVOSortedSet();
                        if(null != orientationSets) {
                            orientationSets.forEach(vo -> {
                                reason.add(new AdvertFilterType(vo.getAdvertId(), vo.getAdvertOrientationPackageId(), AdvertFilterTypeEnum.REPEAT_LUNCH.getCode()));
                            });
                        }
                    }
                }

            }
        }
    }

    /**
     * DMP 数据测试
     * @param req
     * @param rsp
     * @param filterResult
     * @param validAdverts
     * @return
     * @throws TuiaException
     */
    @SuppressWarnings("squid:S3776")
    public Boolean doDmpDataTest(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts, List<String> userInterest, AdvertFilter advertFilter) throws TuiaException{

        //dmp测试开关关闭,不走dmp
        Boolean flag=AdvertSystemConfigureConstants.dmpSwitch;
        if(!flag){
            return flag;
        }
        //hbase获取dmp标签
        List<DmpAdvertDO> dmpAdvertDOS=refreshDmpAdvertHandler.getDmpAdverts();
        Map<Long, List<DmpAdvertDO>> dmpAdvertDOSMap = dmpAdvertDOS.stream().collect(groupingBy(DmpAdvertDO::getAdvertId));


        Map<Long, PartAdvertFilterVO> helpValidAdvertsMap = convertToHelpValidAdvertsMap(validAdverts);

        String deviceKey = getDeviceKey(req);
        //设备如果为空，则不走dmp逻辑
        if(StringUtils.isEmpty(deviceKey)){
            //如果dmp标签为空，则剔除测试广告，走大盘逻辑
            dmpAdvertDOSMap.forEach((key,value)->{
                Optional.ofNullable(helpValidAdvertsMap.get(key)).ifPresent(partAdvertFilterVO -> partAdvertFilterVO.remove(value));
            });

            writeBackToValidAdvertsMap(helpValidAdvertsMap,validAdverts);

            return false;
        }

        Map<String,Object> tagMap = getTagMapByDeviceKey(deviceKey,userInterest);
        if(null == tagMap){

            //如果dmp标签为空，则剔除测试广告，走大盘逻辑
            dmpAdvertDOSMap.forEach((key,value)->{
                Optional.ofNullable(helpValidAdvertsMap.get(key)).ifPresent(partAdvertFilterVO -> partAdvertFilterVO.remove(value));
            });

            writeBackToValidAdvertsMap(helpValidAdvertsMap,validAdverts);

            return false;
        }


        //TODO  此处保险起见可以 做兼容（兼容老的dmp）
        filterResult.setDmpTagMap(tagMap);
        List<String> tagHit = (List<String>) tagMap.get(QueryDeviceIdDmpRepository.DMP_VALUE_HIT_KEY);

        if(CollectionUtils.isEmpty(dmpAdvertDOS)){
            return false;
        }

        // 此处换成配置
        //获取包含在es过滤结果集中的测试广告，进行分组
        Map<Integer,List<DmpAdvertDO>> dmpAdvertMap=dmpAdvertDOS.stream().filter(x-> ifContainsOrient(helpValidAdvertsMap,x))
                .collect(Collectors.groupingBy(DmpAdvertDO::getPutOnType));
        //测试广告和es过滤结果集没有交集
        if(dmpAdvertMap == null || dmpAdvertMap.size()==0){
            return false;
        }
        //获取有效广告排序
        Map<Long, Integer> validAdvertOrderLevelMap = serviceManager.queryValidAdvertOrderLevel();
        //优投逻辑
        List<DmpAdvertDO> hitExcellDmpAdverts=null;
        List<DmpAdvertDO> excellDmpAdverts = dmpAdvertMap.get(CommonConstants.EXCELL_PUT_ON);
        if(CollectionUtils.isNotEmpty(excellDmpAdverts)){
            //命中规则的，测试优投广告
            //标准dmp测试需求修改原有逻辑（开着且命中+关着的）=(关着 或 命中)
            hitExcellDmpAdverts = excellDmpAdverts.stream().filter(x->
                    DmpAdvertDO.MATCH_STATE_CLOSE.equals(x.getMatchState()) || tagHit.contains(x.getTestTag())
            ).collect(Collectors.toList());
        }

        List<AdvertFilterVO> advertFilterVOList=null;
        if(CollectionUtils.isNotEmpty(hitExcellDmpAdverts)){
            advertFilterVOList = priceComplete(helpValidAdvertsMap,validAdverts,validAdvertOrderLevelMap,hitExcellDmpAdverts,CommonConstants.EXCELL_PUT_ON);
        }
        //有优投广告中，则优投广告按照arup去出券
        if(CollectionUtils.isNotEmpty(advertFilterVOList)){
            filterResult.setType(FilterResultTypes.DMP_TYPE);
            filterResult.setDmpAdvertDOS(hitExcellDmpAdverts);
            //DMP需要过滤掉自动托管的配置，isExcludeTrusteeship=true
            doObtainAdvert(req,rsp,advertFilterVOList,filterResult, advertFilter);
            return rsp.isResult();
        }
        //普投逻辑
        List<DmpAdvertDO> hitOridinaryDmpAdverts = Lists.newArrayList();
        List<DmpAdvertDO> oridinaryDmpAdverts = dmpAdvertMap.get(CommonConstants.ORIDINARY_PUT_ON);
        if(CollectionUtils.isNotEmpty(oridinaryDmpAdverts)){
            //命中规则的，普投测试广告
            hitOridinaryDmpAdverts = oridinaryDmpAdverts.stream().filter(x->tagHit.contains(x.getTestTag())||DmpAdvertDO.MATCH_STATE_CLOSE.equals(x.getMatchState())).collect(toList());
        }

        if(CollectionUtils.isNotEmpty(hitOridinaryDmpAdverts)){
            //
            List<String> hitOridinaryDmpAdvertIds = hitOridinaryDmpAdverts.stream().map(dto->dto.getAdvertId()+"#"+dto.getOrientId()).collect(toList());
            //剔除命中普投外所有測試廣告,走大盘逻辑
            dmpAdvertDOS.forEach(dto->{
                Long advertId = dto.getAdvertId();
                Long orientId = dto.getOrientId();

                // 标准dmp测试需求 修改原有逻辑为：（移除开着 且 不命中的）
                if(DmpAdvertDO.MATCH_STATE_OPEN.equals(dto.getMatchState()) && (!hitOridinaryDmpAdvertIds.contains(dto.getAdvertId()+"#"+dto.getOrientId()))){
                    Optional.ofNullable(helpValidAdvertsMap.get(advertId)).ifPresent(partAdvertFilterVO -> partAdvertFilterVO.remove(orientId));
                }
            });
            filterResult.setDmpAdvertDOS(hitOridinaryDmpAdverts);
            //将结果写回 传入的map
            writeBackToValidAdvertsMap(helpValidAdvertsMap,validAdverts);
            return false;
        }

        //沒有測試廣告命中，則剔除測試廣告走單盤邏輯
//        dmpAdvertDOS.stream().forEach(dto->{
//            validAdverts.remove(dto.getAdvertId());
//        });

        dmpAdvertDOSMap.forEach((key,value)->{
            Optional.ofNullable(helpValidAdvertsMap.get(key)).ifPresent(partAdvertFilterVO -> partAdvertFilterVO.remove(value));
        });

        writeBackToValidAdvertsMap(helpValidAdvertsMap,validAdverts);
        return false;
    }

    //判断传入的对象中是否包含指定配置
    private Boolean ifContainsOrient(Map<Long, PartAdvertFilterVO> helpValidAdvertsMap, DmpAdvertDO x) {
        PartAdvertFilterVO partAdvertFilterVO;
        if(null == helpValidAdvertsMap || null == x || null == x.getAdvertId() || null == (partAdvertFilterVO = helpValidAdvertsMap.get(x.getAdvertId()))){
            return false;
        }

        return partAdvertFilterVO.containsOrient(x);
    }

    //将传入的对象放入新的数据结构中
    private Map<Long, PartAdvertFilterVO> convertToHelpValidAdvertsMap(Map<Long, AdvertFilterVO> validAdvertsMap) {
        Map<Long, PartAdvertFilterVO> helpMap = new HashMap<>();
        validAdvertsMap.forEach((key,value)->{
            //value 为广告下所有的配置
            helpMap.put(key,new PartAdvertFilterVO(value));
        });

        return helpMap;
    }

    //将结果写回传入的数据结构中
    private void writeBackToValidAdvertsMap(Map<Long, PartAdvertFilterVO> helpMap,Map<Long, AdvertFilterVO> validAdvertsMap){
        Set<Long> advertIds = new HashSet<>(validAdvertsMap.keySet());
        for (Long advertId : advertIds) {
            PartAdvertFilterVO partAdvertFilterVO = helpMap.get(advertId);
            if(null == partAdvertFilterVO || null == partAdvertFilterVO.getAdvertPriceVOMap() || partAdvertFilterVO.getAdvertPriceVOMap().isEmpty()){
                validAdvertsMap.remove(advertId);
                continue;
            }

            //
            AdvertFilterVO advertFilterVO = validAdvertsMap.get(advertId);
//            partAdvertFilterVO.getAdvertPriceVOMap() 转成 treeSet
            partAdvertFilterVO.writeBackToAdvertFilterVO(advertFilterVO);
        }
    }


    /**
     * 根据设备id获取标签
     */
    private Map<String, Object> getTagMapByDeviceKey(String deviceKey,List<String> userInterest) {
        Map<String, String> deviceIdDmpData = queryDeviceIdDmpRepository.getDeviceIdDmpData(deviceKey, new StringBuilder(), new ArrayList<>());

        if(null == deviceIdDmpData || deviceIdDmpData.isEmpty()){
            return null;
        }

        LinkedList<String> hitList = new LinkedList();
        LinkedList<String> notHitList = new LinkedList<>();
        deviceIdDmpData.forEach((key,value)->{
//            if (QueryDeviceIdDmpRepository.HIT.equals(value)) {
//                hitList.add(key);
//            }else
            if(QueryDeviceIdDmpRepository.NOT_HIT.equals(value)){
                notHitList.add(key);
            }
        });

        if(CollectionUtils.isNotEmpty(userInterest)){
            hitList.addAll(userInterest);
        }

        Map<String,Object> tagMap = new HashMap<>();
        tagMap.put(QueryDeviceIdDmpRepository.DMP_VALUE_HIT_KEY,hitList);
        tagMap.put(QueryDeviceIdDmpRepository.DMP_VALUE_NOT_HIT_KEY,notHitList);

        logger.info("标准dmp测试 查询设备："+deviceKey+"得到的人群包为："+JSON.toJSONString(tagMap));
        return tagMap;
    }

    /**
     * 根据设备id
     */
    private String getDeviceKey(ObtainAdvertReq req) {
        Map<String, String> logExtMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());
        String deviceId;
//        if((deviceId = logExtMap.get(IMEI_MD5))!=null){
//            return deviceId;
//        }
//        if((deviceId = logExtMap.get(IDFA_MD5))!=null){
//            return deviceId;
//        }

        //用于校验logExtMap 中的 IMEI 是否有有效值，
        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IMEI);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,false);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IDFA);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,false);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.OAID);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,false);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IMEI_MD5);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,true);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.IDFA_MD5);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,true);
        }

        deviceId = logExtMap.get(AdvertReqLogExtKeyConstant.OAID_MD5);
        if(StringUtils.isNotBlank(deviceId)){
            return getRowKey(deviceId,true);
        }
        return null;
    }

    private String getRowKey(String key,Boolean isMd5) {
        String md5DeviceId = isMd5 ? key : MD5Util.toMD5String(key);
        if(md5DeviceId.length() < 5){
            return null;
        }
        return md5DeviceId.substring(0, 4) + "-" + md5DeviceId;
    }


    /**
     * 根据设备id 获取 所有 人群包
     */
    private List<String> getTagByDeviceId(String deviceId) {
        if(null == deviceId || deviceId.length()<4){
            return Collections.emptyList();
        }
        String rowKey = deviceId.substring(0, 4) + "-" + deviceId;

        Set<String> strings = queryDeviceIdDmpRepository.getDeviceIdDmpData(rowKey, new StringBuilder(), new ArrayList<>()).entrySet().
                stream().filter(entry->QueryDeviceIdDmpRepository.HIT.equals(entry.getValue())).map(entry->entry.getKey()).collect(Collectors.toSet());
        logger.info("标准dmp测试 查询设备："+deviceId+"得到的人群包为："+Arrays.toString(strings.toArray()));
        return new LinkedList<>(strings);
    }

    private List<AdvertFilterVO> priceComplete(Map<Long, PartAdvertFilterVO> helpValidAdvertsMap,Map<Long, AdvertFilterVO> validAdverts, Map<Long, Integer> validAdvertOrderLevelMap,List<DmpAdvertDO> hitDmpAdverts,Integer type){
        if(CollectionUtils.isEmpty(hitDmpAdverts)){
            return validAdverts.values().stream().collect(toList());
        }

        int validAdvertIdsSize = validAdvertOrderLevelMap.size();
        List<AdvertFilterVO> advertFilterVOList = validAdverts.values().stream().
                map(dto->{
                    Integer order = Optional.ofNullable(validAdvertOrderLevelMap.get(dto.getAdvertId())).orElse(validAdvertIdsSize);
                    dto.setOrder(order);
                    return dto;
                }).sorted(Comparator.comparing(AdvertFilterVO::getOrder)).collect(toList());

        if(CommonConstants.EXCELL_PUT_ON.equals(type)){
            List<AdvertFilterVO> rtnList = new LinkedList<>();

            Map<Long,List<DmpAdvertDO>> hitDmpAdvertsMap = hitDmpAdverts.stream().collect(groupingBy(DmpAdvertDO::getAdvertId));

            advertFilterVOList.forEach(advertFilterVO -> {
                Long advertId = advertFilterVO.getAdvertId();
                List<DmpAdvertDO> dmpAdvertDOS = hitDmpAdvertsMap.get(advertId);
                PartAdvertFilterVO partAdvertFilterVO = helpValidAdvertsMap.get(advertId);
                if(null == dmpAdvertDOS || dmpAdvertDOS.isEmpty()){
                    return;
                }

                if(null == partAdvertFilterVO){
                    logger.warn("dmptest 优投 存在不匹配");
                    return;
                }

                //TODO 校验
                partAdvertFilterVO.removeOthers(dmpAdvertDOS);

                if(!partAdvertFilterVO.getAdvertPriceVOMap().isEmpty()) {
                    partAdvertFilterVO.writeBackToAdvertFilterVO(advertFilterVO);
                    rtnList.add(advertFilterVO);
                }

            });
            advertFilterVOList = rtnList.stream().sorted(Comparator.comparing(AdvertFilterVO::getOrder)).collect(toList());

            //TODO 此处需要大改，只保留需要的配置。
//            List<Long> hitDmpAdvertIds = hitDmpAdverts.stream().map(DmpAdvertDO::getAdvertId).collect(toList());
//            advertFilterVOList = advertFilterVOList.stream().filter(dto->hitDmpAdvertIds.contains(dto.getAdvertId()))
//                                  .sorted(Comparator.comparing(AdvertFilterVO::getOrder)).collect(toList());


        }

        return advertFilterVOList;
    }

    /**
     * 风控广告位定向导量测试
     * @param req
     * @param rsp
     * @param filterResult
     * @param shieldStrategyVO
     * @param appDetail
     * @param todayConsumerVOList
     * @return
     * @throws TuiaException
     */
    private boolean doRiskSoltDirection(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, ShieldStrategyVO shieldStrategyVO,AppDetail appDetail, List<ConsumerInteractiveRecordDO> todayConsumerVOList, AdvQueryParam advQueryParam, AdvertFilter advertFilter) throws TuiaException{

        try {
            DBTimeProfile.enter("doRiskSoltDirection");

            // 校验当前流量是否满足风控广告位定向发券的条件
            boolean slotDirectionCheck = riskChectService.validateSoltDirection(req, todayConsumerVOList);
            filterResult.setRiskCheat(slotDirectionCheck ? CommonConstants.IS_RISK_SLOT_DIRECTION : CommonConstants.NOT_RISK_CHEAT);
            if (!slotDirectionCheck) {
                return false;
            }

            // 走特权库取指定的广告发券
            filterResult.setType(FilterResultTypes.RISK_SLOT_DIRCTION_TYPE);
            privilegeFilter(filterResult, req, shieldStrategyVO, filterResult.getCityId(), rsp, appDetail, advQueryParam, advertFilter);

            // 从特权库发券失败的话 再重置风控作弊标识
            if (!rsp.isResult()) {
                filterResult.setRiskCheat(CommonConstants.NOT_RISK_CHEAT);
            }

            return rsp.isResult();

        } catch (Exception e) {
            logger.error("doRiskSoltDirection error! slotId = {}, consumerId = {} ", req.getSlotId(), req.getConsumerId(), e);
            return false;
        } finally {
            DBTimeProfile.release();
        }
    }



    /**
     * 风控反作弊接口
     * @param req
     * @param rsp
     * @param filterResult
     * @param shieldStrategyVO
     * @param appDetail
     * @param advQueryParam
     * @return
     * @throws TuiaException
     */
    public Map<String, Integer> doRiskCheck(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, ShieldStrategyVO shieldStrategyVO,
                                             AppDetail appDetail, AdvQueryParam advQueryParam, AdvertFilter advertFilter) throws TuiaException{
        Map<String, Integer> mapRiskResult = new HashMap<>();
        // 异步不能反悔 boolean ,这里1代表true，0代表false
        mapRiskResult.put("flag", 1);
        try{

            //按照遍历取请求风控接口
            DBTimeProfile.enter("doRiskCheck");

            // 新增风控广告位定向导量逻辑，命中则出特权库定向广告
            boolean isRiskSlotDirection = doRiskSoltDirection(req, rsp, filterResult, shieldStrategyVO, appDetail, filterResult.getTodayConsumeList(), advQueryParam, advertFilter);
            if (isRiskSlotDirection) {
                // 风控命中！走风控了
                mapRiskResult.put("flag", 1);
                return mapRiskResult;
            }

            // 请求风控用户作弊接口
            int random=new Random().nextInt(100);
            if(random>=Integer.valueOf(AdvertSystemConfigureConstants.riskPercent)){
                mapRiskResult.put("flag", 0);
                return mapRiskResult;
            }
            CatUtil.catLog(CatGroupEnum.CAT_102001.getCode());
            // todo，仅供测试使用，加了【非】
            boolean flag = riskChectService.getRiskCheatStatus(req);
            filterResult.setRiskCheat(flag? CommonConstants.IS_RISK_CHEAT : CommonConstants.NOT_RISK_CHEAT);
            if(!flag){
                // flag只有false才能进来，也就是必然返回0
                mapRiskResult.put("flag", 0);
                return mapRiskResult;
            }
            CatUtil.catLog(CatGroupEnum.CAT_102011.getCode());
            WarningUtils.markThresholdWarning("hitRiskCheat", catMonitorWarnThreshold.getHitRiskCheat());
            filterResult.setType(FilterResultTypes.RISK_PRIVILIGE_TYPE);

            //添加命中风控作弊 切量测试,如果命中风控，并在切量范围 走正常发券流程
            if (random < apolloConfig.getRiskTestPercent()) {
                mapRiskResult.put("flag", 0);
                return mapRiskResult;
            }

            //走特权库取指定的广告发券
            privilegeFilter(filterResult, req, shieldStrategyVO, filterResult.getCityId(), rsp, appDetail, advQueryParam, advertFilter);

            // 从特权库发券失败的话 增加导量失败标记
            if (!rsp.isResult()) {
                filterResult.setRiskCheat(CommonConstants.RISK_CHEAT_FAIL);
            }
            Integer temp = rsp.isResult() ? 1 : 0;
            mapRiskResult.put("flag", temp);
            return mapRiskResult;
        }catch (Exception e){
            logger.error("风控接口异常! Exception:",e);
            throw new TuiaException(ErrorCode.E0500037);
        }finally {
            DBTimeProfile.release();
        }
    }
    /**
     * 降级优先中付费券
     * manualAdvert:(). <br/>
     * @author zp
     * @param req
     * @param rsp
     * @param filterResult
     * @param validAdverts
     * @param validAdvertOrderLevelMap
     * @return
     * @throws TuiaException
     * @since JDK 1.6
     */
    private List<AdvertFilterVO> manualAdvert(ObtainAdvertReq req,ObtainAdvertRsp rsp, FilterResult filterResult,
                                              Map<Long, AdvertFilterVO> validAdverts,Map<Long, Integer> validAdvertOrderLevelMap, AdvertFilter advertFilter)
            throws TuiaException{
        Integer validAdvertIdsSize = validAdvertOrderLevelMap.size();
        List<AdvertFilterVO> advertFilterVOList = validAdverts.values().stream().map(dto -> {
            Integer order = Optional.ofNullable(validAdvertOrderLevelMap.get(dto.getAdvertId())).orElse(validAdvertIdsSize);
            dto.setOrder(order);
            return dto;
        }).sorted(Comparator.comparing(AdvertFilterVO::getOrder)).collect(toList());

        //后面的降级处理都把开启了扶持的广告移除掉
        advertFilterVOList.forEach(item -> item.getManualAdvertSet().removeIf(x -> (Optional.ofNullable(x.getSupportStatus()).orElse(CommonConstant.NO) == CommonConstant.YES)));

        //优先中付费券
        List<AdvertFilterVO> expenseAdverts = advertFilterVOList.stream().filter(item ->
                item.getManualAdvertSet().stream().anyMatch(x -> x.getFee() > 0)).collect(toList());

        filterResult.setType(FilterResultTypes.DEGRADE_PAY_ADVERT_TYPE);
        //人工降级需要过滤掉自动托管的配置，filterSmartShopAdvert()方法中已经移除了自动托管和弱定向的配置，此处传false，不能传true
        //发券
        doObtainAdvert(req, rsp, expenseAdverts, filterResult,  advertFilter);
        return advertFilterVOList;
    }

    /**
     * 广告降级单用户发券受限放开
     */
    public List<AdvertFilterVO> degradeAdverts(ObtainAdvertReq req,ObtainAdvertRsp rsp, FilterResult filterResult,
                                                Map<Long, AdvertFilterVO> validAdverts,Map<Long, AdvertFilterVO> newValidAdverts, AdvertFilter advertFilter)throws TuiaException{
        //获取有效广告排序
        Map<Long, Integer> validAdvertOrderLevelMap = serviceManager.queryValidAdvertOrderLevel();

        return manualAdvert(req,rsp,filterResult,validAdverts,validAdvertOrderLevelMap, advertFilter);
    }

    /**
     * 将当前消费者的广告主发券限制标记，修改为不受限
     * @param req
     */
    private void updateConsumerLimit(ObtainAdvertReq req){
        String limitAccountType=null;
        PlatformTypeEnum ua = PlatformTypeEnum.getByDesc(req.getUa());

        switch (ua.getCode().intValue()){
            case 1:
                limitAccountType=AccountLimitTypeEnum.ANDROID_DEGRADE_NO_LIMIT.getCode();
                break;
            case 2:
                limitAccountType=AccountLimitTypeEnum.IOS_DEGRADE_NO_LIMIT.getCode();
                break;
            default:
                limitAccountType=AccountLimitTypeEnum.UNKNOW.getCode();
                break;
        }
        req.getLogExtMap().put("limitAccountType",limitAccountType);
    }

    /**
     * 中免费券
     * @param req
     * @param rsp
     * @param advertFilterVOList
     * @param filterResult
     * @throws TuiaException
     */
    public void doFreeAdverts(ObtainAdvertReq req,ObtainAdvertRsp rsp,List<AdvertFilterVO> advertFilterVOList,
                               FilterResult filterResult, AdvertFilter advertFilter) throws TuiaException {


        //免费券，前面已经排除掉了自动托管的配置了
        //获取免费券
        List<AdvertFilterVO> freeAdverts = advertFilterVOList.stream().filter(item ->
                item.getManualAdvertSet().stream().anyMatch(x -> x.getFee().equals(0L))).collect(toList());

        //优先中白名单的广告
        List<AdvertFilterVO> whiteAdverts = this.getWhiteAdverts(freeAdverts);
        filterResult.setType(FilterResultTypes.DEGRADE_FREE_ADVERT_TYPE);
        if(!whiteAdverts.isEmpty()){
            doObtainAdvert(req, rsp, whiteAdverts, filterResult,  advertFilter);
        }

        if(!rsp.isResult()){
            //如果今日谢谢参与已达到量则继续中免费券，如果未达到则切部分流量中谢谢参与
            Long todayMissCoupon = serviceManager.getTodayMissedCoupon();
            if(todayMissCoupon >= (AdvertSystemConfigEnum.thksPartakeCount.getLongValue() * 10000)){
                doObtainAdvert(req, rsp, freeAdverts, filterResult, advertFilter);
                return;
            }

            //分别切50%的流量走谢谢参与和中免费券
            int rate = (int) (AdvertSystemConfigEnum.flowDistributionRate.getDoubleValue() * 100);
            int random = new Random().nextInt(100);
            if(random < rate){
                CatUtil.log(CatGroupEnum.CAT_107018.getCode());//降权流量达到中谢谢次数
                serviceManager.incrTodayMissedCoupon();//增加今日谢谢参与的次数
                return;
            }

            doObtainAdvert(req, rsp, freeAdverts, filterResult,  advertFilter);
        }
    }

    /**
     * 获取白名单的广告
     * @param freeAdverts
     * @return
     */
    private List<AdvertFilterVO> getWhiteAdverts(List<AdvertFilterVO> freeAdverts){

        Set<Long> whiteAdvertIds = advertWhiteService.getAllAdvertWhite();
        if(whiteAdvertIds.isEmpty()){
            return Collections.emptyList();
        }

        return freeAdverts.stream().filter(x -> whiteAdvertIds.contains(x.getAdvertId())).collect(toList());
    }

    private void buildFilterResult(FilterResult filterResult, AdvQueryParam advQueryParam) throws TuiaException {
        filterResult.setPutIndex(advQueryParam.getJoinNum());
        filterResult.setModel(advQueryParam.getPhoneModel());
        filterResult.setPriceSection(advQueryParam.getPhoneLevels());
        filterResult.setPhoneBrand(advQueryParam.getPhoneBrand());
        filterResult.setPhoneModelNum(advQueryParam.getPhoneModelNum());
        filterResult.setMultipleExposureIds(advQueryParam.getMultipleExposureIds());
        filterResult.setLimitAdvertTodayMap(advQueryParam.getLimitAdvertTodayMap());
        filterResult.setBrandName(advQueryParam.getBrandName());
        filterResult.setUa(advQueryParam.getPlatform());
        filterResult.setNetworkTypes(advQueryParam.getNetworkTypes());
        filterResult.setOperators(advQueryParam.getOperators());
        filterResult.setProvince(advQueryParam.getProvince());
        filterResult.setNewAppTestType(NewAppAdvertTradeDO.APP_TYPE_OLD.toString());
        filterResult.setCity(advQueryParam.getCity());
    }

    /**
     *
     * privilegeFilter:(特权广告发券). <br/>
     *
     * @author chencheng
     * @param filterResult
     * @param req
     * @param shieldStrategyVO
     * @param cityId
     * @param rsp
     * @param appDetail
     * @param advQueryParam
     * @throws TuiaException
     * @since JDK 1.8
     */
    public void privilegeFilter(FilterResult filterResult, ObtainAdvertReq req, ShieldStrategyVO shieldStrategyVO,String cityId, ObtainAdvertRsp rsp,
                                AppDetail appDetail, AdvQueryParam advQueryParam, AdvertFilter advertFilter) throws TuiaException {
        //1.发券已成功或媒体不是特权库媒体时，则不发券
        if (rsp.isResult() || !appPrivilegeService.isAppPrivilege(req.getAppId())) {
            return;
        }
        //2.特权库广告列表
        Set<Long> validPrivileges = advertPrivilegeService.getValidPrivileges();
        AdvertFilterParamVO advertFilterDo = new AdvertFilterParamVO(filterResult, advertFilter, req, shieldStrategyVO, cityId, appDetail, rsp);
        //3.获取特权库一个广告,命中风控可能获取多个广告
        List<AdvertFilterVO> advertFilterVOList = privilegeFilterService.foreachAdvertCheck(validPrivileges, advertFilterDo, filterResult, advQueryParam);
        //4.广告位导量，命中风控，正常特权库  发券逻辑
        AdvertPriceVO advertPriceVO = sendAdvert(filterResult, advertFilterVOList, req, rsp, advertFilterDo, advertFilter);

        if (rsp.isResult()) {
            //特权库成功发券的次数
            CatUtil.catLog(CatGroupEnum.CAT_102007.getCode());
            WarningUtils.markThresholdWarning("privilegeAdvert", catMonitorWarnThreshold.getPrivilegeAdvert());
            filterResult.setResultCode(ErrorCode.E0000000.getErrorCode());
            filterResult.setSuccessId(rsp.getAdvertId());
            filterResult.setAdvertOrderId(rsp.getAdvertOrderId());
            //出价
            filterResult.setFee(advertPriceVO.getFee());
            //计费方式
            filterResult.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
            //包的类型
            filterResult.setPackageType(advertPriceVO.getPackageType());
            // 中券成功的情况需要记录过滤结果
            filterResult.setPlanId(advertPriceVO.getAdvertOrientationPackageId());
        }

    }

    /**
     *  广告位导量，命中风控，正常特权库  发券逻辑
     */
    private AdvertPriceVO sendAdvert(FilterResult filterResult, List<AdvertFilterVO> advertFilterVOList, ObtainAdvertReq req,
                                     ObtainAdvertRsp rsp, AdvertFilterParamVO advertFilterDo, AdvertFilter advertFilter) throws TuiaException {
        AdvertPriceVO advertPriceVO=new AdvertPriceVO();
        if (CollectionUtils.isEmpty(advertFilterVOList)) {
            return advertPriceVO;
        }
        for (AdvertFilterVO advertFilterVO : advertFilterVOList) {
            try {
                advertPriceVO = advertFilterVO.getManualMaxFeeAdvert();
                Long advertId = advertPriceVO.getAdvertId();
                AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
                if (advertVO == null) {
                    logger.info("privilegeFilter error, advertVO is null the advertId = [{}]", advertId);
                    throw new TuiaException(ErrorCode.E0500003);
                }
                Long aFee = advertPriceVO.getFee();
                rsp.setPrivilege(true);
                //通过特权库发广告
                advertExposeService.finishBiz(req, rsp, advertId, advertVO, filterResult, advertPriceVO, aFee, advertFilter);
            } catch (Exception e) {
                //如果不是命中风控规则发券失败，继续抛出异常
                if (advertFilterDo.getFilterResult().getType() != FilterResultTypes.RISK_PRIVILIGE_TYPE) {
                    throw e;
                }
                logger.info("privilegeFilter risk engine hit error");
            }
            //如果是命中风控规则作弊或者风控导量发券成功，这个结束发券循环
            if (rsp.isResult()) {
                break;
            }
        }
        return advertPriceVO;
    }


    /**
     * 获取广告定向包里最高单价的配置
     */
    private AdvertPriceVO getAdvertMaxFee(AdvertFilterVO advertFilterVO) {
        if (advertFilterVO == null) {
            return null;
        }
        return advertFilterVO.getManualMaxFeeAdvert();
    }

    private ObtainAdvertReq bagCityIdInLogMap(ObtainAdvertReq req, String cityId) {
        if (req.getLogExtMap() != null) {
            req.getLogExtMap().put("cityId", cityId);
            req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));

        } else {
            Map<String, String> logExtMap = Maps.newHashMap();
            logExtMap.put("cityId", cityId);
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), Optional.ofNullable(req.getActivitySceneType()).map(type -> type.toString()).orElse(PackagePlanConstants.INTERACTION_TYPE));
            logExtMap.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
            req.setLogExtMap(logExtMap);
        }
        return req;
    }

    /**
     * 执行应用白名单操作.<br>
     * <ol>
     * <li>如果应用没有白名单， 返回false</li>
     * <li>如果应用有白名单并且中券， 返回true</li>
     * <li>如果应用有白名单但没有中券并且福袋开关为开返回false</li>
     * <li>如果应用有白名单但没有中券并且福袋开关为关返回true</li>
     * <ol>
     *
     * 如果可投广告里包含白名单里的广告，则优先投放此白名单广告，否则就跳过这块逻辑，继续往下走。
     * @param req          the req
     * @param rsp          the rsp
     * @param filterResult the filter result
     * @return true, if do app white list
     * @throws TuiaException the tuia exception
     */
    @SuppressWarnings("squid:S3776")
    public boolean doAppWhiteList(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, AppDetail appDetail,
                                  Map<Long, AdvertFilterVO> hasValidAdverts,ShieldingStrategyService shieldingStrategy, AdvertFilter advertFilter) throws TuiaException {
        try {
            DBTimeProfile.enter("doAppWhiteList");
            if (hasValidAdverts.size() == 0) {
                return false;
            }
            List<Long> whiteList = mediaCacheService.getWhiteList(appDetail, shieldingStrategy);

            if (CollectionUtils.isNotEmpty(whiteList)) {
                //获取竞价排序开关，若 已经转化 且 开关开着，则有效广告与白名单列表取交集
                SlotDO slotDO = appDetail.getSlotDO();
                if(appDetail.isHandledSlot() && slotDO != null && isNzSort(slotDO,shieldingStrategy.getStrategyCode())){

                    //判断白名单是否开启
                    Boolean isSendLuckybag = shieldingStrategy.isSendLuckybag(appDetail.getObjParam());
                    if(!isSendLuckybag) {
                        //流量策略 应用管理  是否有广告白名单  并且排序开启，福袋关闭   不进行dsp 竞价
                        rsp.setDspCompare(false);
                        //过滤日志
                        Set<AdvertFilterType> advertFilterList = new HashSet<>();
                        hasValidAdverts.forEach((k, v) ->{
                            //若白名单包含配置，则不记录过滤日志
                            if(whiteList.contains(k)){
                                return;
                            }
                            Set<AdvertPriceVO> orientationSets = v.getAdvertPriceVOSortedSet();
                            if(null != orientationSets) {
                                orientationSets.forEach(vo -> {
                                    advertFilterList.add(new AdvertFilterType(v.getAdvertId(), vo.getAdvertOrientationPackageId(), AdvertFilterTypeEnum.APP_WHITE.getCode()));
                                });
                            }
                        });
                        advertFilter.getReason().addAll(advertFilterList);

                        //与白名单取交集
                        hasValidAdverts.keySet().retainAll(whiteList);
                        //新媒体试投 集合 过滤
                        Map<Long, AdvertFilterVO> newAppTestAdvertBackUpMap = filterResult.getNewAppTestAdvertBackUpMap();
                        if(newAppTestAdvertBackUpMap != null){
                            newAppTestAdvertBackUpMap.keySet().retainAll(whiteList);
                        }
                    }
                    return false;
                }

                List<AdvertFilterVO> advertWhitelist = new ArrayList<>(whiteList.size());
                //2.遍历白名单，与筛选出的广告取交集，放到投放列表里
                for (Long advertId : whiteList) {
                    if (hasValidAdverts.containsKey(advertId)) {
                        advertWhitelist.add(hasValidAdverts.get(advertId));
                    }
                }

                filterResult.setType(appDetail.isHandledSlot() ? FilterResult.SLOT_WHITE_LIST : FilterResult.APP_WHITE_LIST);
                filterResult.setAfterAppCnt(advertWhitelist.size());
                //媒体白名单需要过滤掉自动托管的配置
                //开始投放
                doObtainAdvert(req, rsp, advertWhitelist, filterResult,  advertFilter);

                return buidDoAppWhiteListRsp(rsp, filterResult, shieldingStrategy.isSendLuckybag(appDetail.getObjParam()));
            } else {
                return false;
            }
        } finally {
            DBTimeProfile.release();
        }

    }

    private boolean isNzSort(SlotDO slotDO,Integer strategyWhiteSortType) {
        int sortTypeBit = Optional.ofNullable(slotDO).map(solt -> Optional.ofNullable(solt.getNzSortType()).orElse(0)).orElse(0);
        // 位运算获取开关值
        int whiteSortType = SwitchesUtil.switchChange(sortTypeBit, strategyWhiteSortType);
        return MediaCacheService.SWITCH_OPEN == whiteSortType;
    }

    /**
     * 构建媒体白名单流程的执行结果.<br>
     * <ol>
     * <li>如果应用没有白名单， 返回false</li>
     * <li>如果应用有白名单并且中券， 返回true</li>
     * <li>如果应用有白名单但没有中券并且福袋开关为开返回false</li>
     * <li>如果应用有白名单但没有中券并且福袋开关为关返回true</li>
     * <ol>
     *
     * @param rsp            the rsp
     * @param filterResult   the filter result
     * @param isSendLuckybag the isSendLuckybag do
     * @return true, if buiddo app white list rsp
     */
    private boolean buidDoAppWhiteListRsp(ObtainAdvertRsp rsp, FilterResult filterResult, boolean isSendLuckybag) {
        // 如果中券或者福袋开关为开的话, 返回中券结果(已中券则结束流程，否则继续中福袋)
        if (rsp.isResult() || isSendLuckybag) {
            return rsp.isResult();
        } else {
            // 没有中券并且福袋开关为关, 则返回错误码并结束流程
            switch (filterResult.getType()) {
                case FilterResult.APP_WHITE_LIST:
                    filterResult.setResultCode(ErrorCode.E0500020.getErrorCode());
                    return true;
                case FilterResult.SLOT_WHITE_LIST:
                    filterResult.setResultCode(ErrorCode.E0500036.getErrorCode());
                    return true;
                default:
                    //默认配备原来的错误码
                    filterResult.setResultCode(ErrorCode.E0500020.getErrorCode());
                    return true;

            }
        }
    }

    /**
     * 判断推啊商业活动白名单，优先投放还是定制投放
     * buidDoAppWhiteListRsp:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param isCustomeAdvert
     * @param filterResult
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private boolean buidDoBussinessAppWhiteListRsp(boolean isCustomeAdvert, FilterResult filterResult) {
        if (isCustomeAdvert) {
            filterResult.setResultCode(ErrorCode.E0500024.getErrorCode());
            return true;
        }
        return false;
    }

    /**
     * 执行推啊活动，中优惠券后直接中优惠券.<br>
     *
     * @param req             the req
     * @param rsp             the rsp
     * @param filterResult    the filter result
     * @param hasValidAdverts the valid advert ids
     * @return true, if do activity white list
     * @throws TuiaException the tuia exception
     */
    public boolean
    doTuiaActivityAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult,
                         Map<Long, AdvertFilterVO> hasValidAdverts, AdvertFilter advertFilter) throws TuiaException {
        // 1.获取优惠券广告ID
        Long activityAdvertId = req.getAdvertId();
        // 2.如果优惠券ID不为空，判断该广告是否有效，有效直接中广告，反之降级
        if (StringUtils.isNotEmpty(String.valueOf(activityAdvertId)) && hasValidAdverts.containsKey(activityAdvertId)) {
            // 3.如果配置优惠券为有效广告，直接中广告
            filterResult.setType(FilterResult.TUIA_ACTIVITY_CONFIG_ADVERT);
            List<AdvertFilterVO> advertList = new ArrayList<AdvertFilterVO>(1);
            advertList.add(hasValidAdverts.get(activityAdvertId));
            //此处也需要过滤掉自动托管的配置，已和产品确认 @小弱
            doObtainAdvert(req, rsp, advertList, filterResult,  advertFilter);
            return rsp.isResult();
        }
        return false;
    }

    /**
     * 执行商业活动定制化广告.<br>
     * <ol>
     * <li>如果活动没有定制化广告，且非仅投定制化广告， 返回false</li>
     * <li>如果活动有定制化广告， 返回true</li>
     * <ol>
     *
     * @param req          the req
     * @param rsp          the rsp
     * @param filterResult the filter result
     * @return true, if do activity white list
     * @throws TuiaException the tuia exception
     */
    public boolean doBusinessActivityWhiteList(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult,
                                               Map<Long, AdvertFilterVO> hasValidAdverts, AdvertFilter advertFilter) throws TuiaException {
        if (req.getActivityUseType() == 0){
            return false;
        }
        // 1.传参为null，直接降级。（过度阶段，后期严格校验参数后删除）
        if (req.getDuibaActivityId() == -1L && req.getDuibaActivityType() == 1) {
            return false;
        }
        // 2.查询定制化活动信息，判断是否开启定制化广告
        Optional<ActivityAdvert4MonitorDto> info = serviceManager.getBusinessActivityCache(req.getDuibaActivityId(), req.getActivityUseType());
        //没有活动信息，或者没有开启定制化广告，可回退降级
        if (!info.isPresent()) {
            return false;
        }
        ActivityAdvert4MonitorDto activityAdvert4MonitorDto = info.get();
        filterResult.setActivityAdvert4MonitorDto(activityAdvert4MonitorDto);
        filterResult.setActivityAdvert4MonitorReq(req.getDuibaActivityId() + "-" + (req.getActivityUseType() - 1));

        // 3.区分仅投定制化广告还是优先投放定制化广告，确定是否降级
        // 投放模式
        ActivityDirectMode4MonitorDto directMode4MonitorDto = activityAdvert4MonitorDto.getDirectMode4MonitorDto();
        // 广告列表
        List<ActivityAdvertDto>  activityAdvertDtoList = activityAdvert4MonitorDto.getActivityAdvertDtoList();

        Boolean isOnlyCustomizedAd = directMode4MonitorDto != null && directMode4MonitorDto.getDirectAdvertMode() == 1;

        // 5.用户领取过的广告集合
        if (CollectionUtils.isNotEmpty(activityAdvertDtoList)) {
            List<AdvertFilterVO> advertCustomizedlist = Lists.newArrayList();
            // 6.循环遍历，过滤定制化广告中的有效广告
            for (ActivityAdvertDto activityAdvertDto : activityAdvertDtoList) {
                Long advertId = activityAdvertDto.getAdvertId();
                // 6.1 定向广告，而且用户未领取过
                if (hasValidAdverts.containsKey(advertId)) {
                    advertCustomizedlist.add(hasValidAdverts.get(advertId));
                }
            }
            filterResult.setType(FilterResult.CUSTOMIZED_AD);
            filterResult.setAfterActCnt(advertCustomizedlist.size());


            // 7.如果没有有效广告,判断定制化投放策略
            if (CollectionUtils.isEmpty(advertCustomizedlist)) {
                // 优先投放定制化广告，可回退降级
                return buidDoBussinessAppWhiteListRsp(isOnlyCustomizedAd, filterResult);
            }
            //活动白名单需要过滤掉自动托管的配置
            // 8.投放广告
            doObtainAdvert(req, rsp, advertCustomizedlist, filterResult,  advertFilter);
            if (!rsp.isResult()) {
                return buidDoBussinessAppWhiteListRsp(isOnlyCustomizedAd, filterResult);
            }
            return rsp.isResult();
        }
        return buidDoBussinessAppWhiteListRsp(isOnlyCustomizedAd, filterResult);
    }

    /**
     * 执行发布广告操作.
     * @param req                请求广告接口的请求参数
     * @param rsp                请求广告接口的返回结果
     * @param advertFilterVOList 广告ID列表
     * @param filterResult       过滤结果对象
     * @throws TuiaException the tuia exception
     */
    @SuppressWarnings("squid:S3776")
    public void doObtainAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, List<AdvertFilterVO> advertFilterVOList,
                               FilterResult filterResult, AdvertFilter advertFilter) throws TuiaException {
        try {
            DBTimeProfile.enter("doObtainAdvert size:" + advertFilterVOList.size());
            // 获取"有效"状态广告id列表 移除被重复曝光过滤掉的广告
            advertFilterVOList = advertFilterVOList.stream().filter(x -> !filterResult.getMultipleExposureIds().contains(x.getAdvertId())).collect(toList());

            for (AdvertFilterVO advertFilterVO : advertFilterVOList) {
                Long advertId = advertFilterVO.getAdvertId();
                AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
                if (advertVO == null) {
                    logger.info("serviceManager.getAdvert error, advertVO is null the advertId = [{}]", advertId);
                    filterResult.addFilterId(ErrorCode.E0500008.getErrorCode(), null, advertId);
                    continue;
                }
                //非算法投放的情况下，取不到CPC最大值，则表示无CPC配置，则该广告不可投放
                AdvertPriceVO advertPriceVO = this.getAdvertMaxFee(advertFilterVO);
                if (advertPriceVO == null) {
                    filterResult.addFilterId(ErrorCode.E0500030.getErrorCode(), null, advertId);
                    continue;
                }

                //dmp日志打印
                advertRecommendService.dmpAdvertDOS(filterResult,advertId,advertPriceVO);

                try {
                    DBTimeProfile.enter("finishBiz");
                    advertExposeService.finishBiz(req, rsp, advertId, advertVO, filterResult, advertPriceVO, advertPriceVO.getFee(), advertFilter);
                } catch (TuiaException ex) {
                    logger.warn("finishBiz happen error, duibaOrderId={}, type={}",req.getOrderId(), filterResult.getType(), ex);
                    // 过滤掉之后需要添加到过滤结果中
                    filterResult.addFilterId(ex.getResultCode(), null, advertId);
                    if(ex.getResultCode().equals(ErrorCode.E0500006.getErrorCode())){break;}
                    else { continue;}
                } finally {
                    DBTimeProfile.release();
                }

                if (rsp.isResult()) {
                    filterResult.setResultCode(ErrorCode.E0000000.getErrorCode());
                    filterResult.setSuccessId(advertId);
                    filterResult.setAdvertOrderId(rsp.getAdvertOrderId());
                    //出价
                    filterResult.setFee(advertPriceVO.getFee());
                    //计费方式
                    filterResult.setChargeType(ChargeTypeEnum.getByCode(advertPriceVO.getChargeType()).getDesc());
                    //包的类型 1-人工包 2-系统托管包
                    filterResult.setPackageType(advertPriceVO.getPackageType());
                    //记录活动类型
                    filterResult.setActivitySceneType(advertPriceVO.getActivityType());
                    // 中券成功的情况需要记录过滤结果
                    filterResult.setPlanId(advertPriceVO.getAdvertOrientationPackageId());
                    break;
                }
            }
        } finally {
            DBTimeProfile.release();
        }
    }

    /**
     * 获取活动领取限制数.
     *
     * @param consumerId 请求广告的用户Id
     * @param activityId 活动id
     * @param actReceiveType 活动领券券数：0-普通活动领券次数限制，获取activity.receive.count，1-特殊活动领券次数限制，获取activity.receive.special.count
     * @return 活动领取限制数
     * @throws TuiaException the tuia exception
     */
    public void checkActivityLimit(Long consumerId, Long activityId, List<ConsumerInteractiveRecordDO> consumerRecords, Integer actReceiveType) throws TuiaException {
        // 1.从缓存中获取已经领取限制次数
        Integer activityLimit = null;
        if (null != actReceiveType && actReceiveType == AdvertSystemConfigureConstants.activityReceiveSpecialType) {
            activityLimit= serviceManager.getIntValue(AdvertSystemConfigureConstants.ACTIVITY_RECEIVE_SPECIAL_COUNT);
        }else{
            activityLimit= serviceManager.getIntValue(AdvertSystemConfigureConstants.ACTIVITY_RECEIVE_COUNT);
        }
        if (activityLimit != null && activityLimit != 0) {
            int receiveCount = consumerRecordSerivce.getTodayAcJoinTimes(consumerRecords, activityId);
            // 2.从订单表中获取已经领取的次数
            if (receiveCount >= activityLimit) {
                throw new TuiaException(ErrorCode.E0500001);
            }
        }
    }

    /**
     * 查询之前请求的广告优惠券.
     *
     * @param req the req
     * @return the query advert rsp
     */
    public QueryAdvertRsp queryAdvert(QueryAdvertReq req) {
        QueryAdvertRsp rsp = new QueryAdvertRsp();
        rsp.setResult(false);
        try {
            // 1.参数校验
            if (req == null || StringUtils.isEmpty(req.getOrderId())) {
                logger.error("queryAdvert error, req = [{}], please check the", req);
                throw new TuiaException(ErrorCode.E0100002);
            }

            // 2.查询广告订单
            AdvertOrderDO advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), null);
            if(advertOrderDO == null){
                logger.error("queryAdvert advertOrderDO is null, consumerId=[{}], orderId=[{}]", req.getConsumerId(), req.getOrderId());
            }else {
                rsp = buildQueryAdvertResult(rsp, advertOrderDO, req.getShowType());
            }
        } catch (TuiaException ex) {
            logger.info("queryAdvert happen error, ex = {}", ex.getResultMessage());
        }
        return rsp;
    }

    /**
     * 校验兑吧请求时的输入参数 <一句话功能描述>.
     *
     * @param req the req
     * @throws TuiaException the tuia exception
     */
    @SuppressWarnings("squid:S3776")
    private void checkObtainAdvertReq(ObtainAdvertReq req) throws TuiaException {
        //1.请求为空或者请求类型为预加载，则不投广告
        if (req == null || req.isPreloadingMaterial())  {
            logger.warn("obtainAdvert error,req is null or preloadMaterial is true,[{}]",req);
            CatUtil.log(CatGroupEnum.CAT_107019.getCode());
            WarningUtils.markThresholdWarning("reqNull", catMonitorWarnThreshold.getReqNull());
            throw new TuiaException(ErrorCode.E0100002);
        }
        //2.针对互动广告的逻辑，展示广告不应该发券
        if (req.getActivityType() != null && req.getActivityType().intValue() == PackagePlanConstants.SHOW_ACTIVITY_TYPE) {
            logger.error("obtainAdvert error,req type is [{}]",req.getActivityType());
            CatUtil.log(CatGroupEnum.CAT_107022.getCode());
            throw new TuiaException(ErrorCode.E0100002);
        }
        //3.用户id,媒体id,活动id,活动订单id为空验证
        if (req.getConsumerId() == null || req.getAppId() == null
                || req.getActivityId() == null || StringUtils.isEmpty(req.getOrderId())) {
            logger.warn("obtainAdvert error, req = [{}], please check the", req);
            CatUtil.log(CatGroupEnum.CAT_107023.getCode());
            WarningUtils.markThresholdWarning("reqConsAppActOrderIdIsEmpty", catMonitorWarnThreshold.getConsEmpty());
            throw new TuiaException(ErrorCode.E0100002);
        }
        //4.请求ip为空验证
        if (StringUtils.isEmpty(req.getIp())) {
            logger.warn("obtainAdvert error, req = [{}], please check the", req);
            CatUtil.log(CatGroupEnum.CAT_107021.getCode());
            WarningUtils.markThresholdWarning("reqIpIsEmpty", catMonitorWarnThreshold.getIpEmpty());
            throw new TuiaException(ErrorCode.E0100002);
        }
        //5.判断广告用途类型，为空时给默认值0，表明普通活动
        if (null == req.getActivityUseType()) {
            logger.warn("obtainAdvert error,activityUseType is null");
            req.setActivityUseType(0);
        }
        //6.判断DuibaActivityId和DuibaActivityType为null，暂时置为-1
        if (null == req.getDuibaActivityId() || null == req.getDuibaActivityType()) {
            req.setDuibaActivityId(-1L);
            req.setDuibaActivityType(1);
        }
        //7.如果是插件活动，则设置活动ID 为传递过来的负数,推啊活动特殊传了activityType为1,所以得根据userType进行区分,2:推啊商业活动
        if (req.getActivityType() != null && req.getActivityUseType() != 2
                && PackagePlanConstants.PLUGIN_ACTIVITY_TYPE == req.getActivityType()) {
            req.setActivityId(0 - req.getActivityId());
        }
        //8.UA校验和监控
        if (StringUtils.isBlank(req.getUa()) || CommonConstants.UNKNOWN.equals(req.getUa())) {
            CatUtil.log(CatGroupEnum.CAT_107004.getCode());
            WarningUtils.markThresholdWarning("uaIsEmptyOrUnknown", catMonitorWarnThreshold.getUaEmpty());
            req.setUa(CommonConstants.UNKNOW);
        }
        //9.ua没有过滤到
        if (!CommonConstants.UA.contains(req.getUa())) {
            logger.info("ua is invalid,the ua is [{}]", req.getUa());
            WarningUtils.markThresholdWarning("uaNotInAndroidIOSUnknow", catMonitorWarnThreshold.getUaNotIn());
            CatUtil.log(CatGroupEnum.CAT_107005.getCode());//ua没有过滤到
        }
        //10.兑吧和推啊统一都会传duibaActivityType字段,活动投放场景设置
        Integer activityType = Optional.ofNullable(req.getDuibaActivityType()).orElse(0);
        if (!ActivityTypeEnum.NEW_VEDIO_ADVERT_ACTIVITY_TYPE.getCode().equals(req.getActivitySceneType()) &&
                !ActivityTypeEnum.DP_ADVERT_ACTIVITY_TYPE.getCode().equals(req.getActivitySceneType())) {
            if (ActivityTypeEnum.ENC_ACTIVITY_TYPE.getCode().equals(req.getActivitySceneType())) {
                req.setActivitySceneType(PackagePlanConstants.ENC_ACTIVITY_TYPE);
            } else if (activityType == PackagePlanConstants.TUIA_PLUGIN_ACTIVITY_TYPE
                    || activityType == PackagePlanConstants.DUIBA_PLUGIN_ACTIVITY_TYPE) {
                req.setActivitySceneType(PackagePlanConstants.PLUGIN_ACTIVITY_TYPE);
            } else {
                req.setActivitySceneType(PackagePlanConstants.ACT_ACTIVITY_TYPE);
            }
        }
        //11.浮标投放类型
        if (req.getDeliveryType() == PackagePlanConstants.DELIVERY_TYPE_FLOAT) {
            req.setActivitySceneType(PackagePlanConstants.FLOAT_ACTIVITY_TYPE);
        }
        if (req.getReplaceLowArpu() == null){
            req.setReplaceLowArpu(CommonConstant.NO);
        }

        List<Integer> activityTypeExt = req.getActivityTypeExt();
        if(null != activityTypeExt && activityTypeExt.contains(12)){
            //开关
            String idMapStrByKeyStr = apolloPanGuService.getIdMapStrByKeyStr("tuia-engine.activity-expand.switch");
            if(!"1".equals(idMapStrByKeyStr)){
                List<Integer> integers = new LinkedList<>(activityTypeExt);
                integers.remove(new Integer(12));
                req.setActivityTypeExt(integers);
            }

        }


    }

    /**
     * 查询用户记录
     * getConsumerRecord:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private List<ConsumerInteractiveRecordDO> getConsumerRecord(Long consumerId) {
        if (null == consumerId) {
            return new ArrayList<>();
        }
        // 查询的时间间隔,初始化48小时（满足当天的概念），实际按最低时间处理
        Integer hoursDiff = 48;
        try {
            // 单个用户key重复领取的周期时间
            Integer singleRepeatDays = serviceManager.getIntValue(SystemConfigKeyConstant.ADVERT_SINGLE_REPEAT_DAY);
            // 重复领取周期，折算成小时
            Integer singleRepeatDaysHours = (singleRepeatDays + 1) * 24;
            // 重复发券过滤时间间隔
            Integer beforeHours = serviceManager.getIntValue(SystemConfigKeyConstant.TUIA_ADVERT_SINGLE_REPEAT_HOURS);
            // 取最大值（这样查询出来的记录，就可以满足后面的使用逻辑了，不用全量）
            hoursDiff = singleRepeatDaysHours > beforeHours ? singleRepeatDaysHours : beforeHours;
            // 至少要一天的（至少24h）
            hoursDiff = hoursDiff > 24 ? hoursDiff : 24;
        } catch (Exception e) {
            logger.error("EngineServiceImpl.getConsumerRecord 用户记录出错：",e);
        }
        final Integer hoursDiffFinal = hoursDiff;

        try{
            DBTimeProfile.enter("getConsumerRecord");
            List<ConsumerInteractiveRecordDO> record = consumerRecordDAO.selectInteractiveRecordHours(consumerId,hoursDiffFinal);
            if (CollectionUtils.isEmpty(record)) {
                return Collections.emptyList();
            }
            // 过滤出互动广告
            List<ConsumerInteractiveRecordDO> collect = record.stream().filter(this::filterAdvertType).collect(toList());
            return collect;
        }catch (Exception e){
            logger.error("EngineServiceImpl.getConsumerRecord mysql异常：",e);
            return new ArrayList<>();
        } finally{
            DBTimeProfile.release();
        }
    }

    private boolean filterAdvertType(ConsumerInteractiveRecordDO recordDO) {
        if(recordDO == null){
            return false;
        }

        ConsumerRecordJsonVO recordJsonVO = JSON.parseObject(recordDO.getJson(), ConsumerRecordJsonVO.class);
        if(recordJsonVO == null){
            return true;
        }

        Integer advertType = recordJsonVO.getAdt();
        return advertType == null || AdvertTypeEnum.HD_ADVERT_TYPE.getCode().equals(advertType);
    }

    /**
     * 查询接口中构造兑吧返回结果  <一句话功能描述>.
     *
     * @param rsp           the rsp
     * @param advertOrderDO 广告订单信息
     * @return the query advert rsp
     */
    @SuppressWarnings("squid:S3776")
    private QueryAdvertRsp buildQueryAdvertResult(QueryAdvertRsp rsp, AdvertOrderDO advertOrderDO,
                                                  Integer showType) {

        try {
            OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
            //获取推啊或dsp广告  目前dsp 广告都是免审 不做判断
            AdvertVO advertVO = null;
            AdxAdvertMaterialDO adxAdvert = null;
            if (vo != null && vo.getDspId() != null) {
                //adxAdvert = dspComparePriceService.getAdxAdvertCache(vo.getDspId(), advertOrderDO.getAdvertId());
                rsp.setThumbnailPngUrl(vo.getTbp());
                rsp.setDspId(vo.getDspId());
            } else {
                advertVO = advertMapCacheManager.getAdvertCache(advertOrderDO.getAdvertId());
            }
            //判断是否有广告数据
            if (advertVO == null && adxAdvert == null) {
                return rsp;
            }
            AdvertPlan advertPlan = advertVO != null ? advertVO.getAdvertPlan() : null;
            //日志拓展字段解析，包含屏蔽策略类型，广告定向配置包id，计费方式，当前出价等。
            Map<String, Object> logExtMap = new HashMap<>(256);

            rsp.setStrategyType(vo.getSt());
            rsp.setEncArpuResult(vo.getEncAr());

            // 与流量命中的人群定向标签
            rsp.setHitUserInterest(vo.getHui());

            rsp.setSlotId(advertOrderDO.getSlotId());
            //去掉兑吧落地页日志广告位id
            if (StringUtils.isNotBlank(vo.getuT())) {
                Integer ut = Integer.parseInt(vo.getuT());
                if(ut == 0 || ut == 1){
                    rsp.setDuibaSlotId(rsp.getSlotId());
                    rsp.setSlotId(null);
                }
            }

            if (vo.getCt() != null) {
                logExtMap.put(AdvertOrderJsonKeyEnum.KEY_CHARGE_TYPE.getCode(), ChargeTypeEnum.getDescByCode(vo.getCt()));
            }
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_FEE.getCode(), vo.getFe());
            rsp.setAdSpecId(null == vo.getPid() ? 0L : vo.getPid());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_TIMES.getCode(), String.valueOf(vo.getTs()));

            activitySourceSet(advertOrderDO.getDuibaOrderId(), logExtMap);
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_APP_ID.getCode(), advertOrderDO.getAppId());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_ID.getCode(), advertOrderDO.getDuibaActivityId());
            if(vo.getDspId() == null){
                logExtMap.put(AdvertOrderJsonKeyEnum.KEY_EFFECTIVE_MAIN_TYPE.getCode(),advertVO.getEffectMainType());
            }
            logExtMap.put(AdvertReqLogExtKeyConstant.GMT_CREATE_TIME, StringTool.getStringTime(advertOrderDO.getGmtCreate()));
            logExtMap.put(AdvertReqLogExtKeyConstant.CID, advertOrderDO.getConsumerId());
            logExtMap.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_URL, advertOrderDO.getPromoteUrl());
            logExtMap.put(AdvertReqLogExtKeyConstant.FLOW_TAG, vo.getfTag());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), vo.getAst());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACCOUNT_ID.getCode(), vo.getDspId() != null ? vo.getDspId() : advertPlan.getAccountId());
            logExtMap.put(AdvertOrderJsonKeyEnum.KEY_AGENT_ID.getCode(), vo.getDspId() != null ? vo.getDspId() : advertPlan.getAgentId());;
            logExtMap.put(AdvertReqLogExtKeyConstant.TARGET_RECOMMEND_TYPE, Optional.ofNullable(vo.getTrt()).orElse(0) + "");

            logExtMap.put(AdvertReqLogExtKeyConstant.GAME_TAG,Optional.ofNullable(vo.getGm()).orElse(CommonServiceImpl.BAICHUAN_GAME_TAG));
            logExtMap.put(AdvertReqLogExtKeyConstant.TRUSTEESHIP, Optional.ofNullable(vo.getTsp()).orElse(0));
            logExtMap.put(AdvertReqLogExtKeyConstant.TRUSTEESHIP_CONVERT_COST, vo.getTspFee());
            logExtMap.put(AdvertReqLogExtKeyConstant.RISK_CHEAT,vo.getRc());
            logExtMap.put(AdvertReqLogExtKeyConstant.APP_TYPE,Optional.ofNullable(vo.getAt()).orElse(NewAppAdvertTradeDO.APP_TYPE_OLD.toString()));
            logExtMap.put(AdvertReqLogExtKeyConstant.NEW_APP_TEST_FEE,String.valueOf(vo.getNbf()));
            logExtMap.put(AdvertReqLogExtKeyConstant.DSM, vo.getDsm());
            logExtMap.put(AdvertReqLogExtKeyConstant.DCM, vo.getDcm());
            logExtMap.put(AdvertReqLogExtKeyConstant.DPM, vo.getDpm());
            logExtMap.put(AdvertReqLogExtKeyConstant.DSM2, vo.getDsm2());
            logExtMap.put(AdvertReqLogExtKeyConstant.DUIBA_ACTIVITY_TYPE, vo.getAcT());
            logExtMap.put(AdvertReqLogExtKeyConstant.TARGET_PACKAGE_ID, vo.getTap() == null ? null : vo.getTap() + "");
            logExtMap.put(AdvertReqLogExtKeyConstant.ENC_ARPU_RESULT, vo.getEncAr() + "");
            logExtMap.put(AdvertReqLogExtKeyConstant.DIRECTPAGE, vo.getDtPage());
            if (vo.getSty() != null) {
                logExtMap.put(AdvertReqLogExtKeyConstant.SUBTYPE, vo.getSty());
            }
            logExtMap.put(AdvertReqLogExtKeyConstant.DEPTH_SUBTYPE, vo.getDsty());
            logExtMap.put(AdvertReqLogExtKeyConstant.PUT_TARGET_TYPE, String.valueOf(vo.getPtt()));
            logExtMap.put(AdvertReqLogExtKeyConstant.FOCUS_APP_CONVERT_COST, String.valueOf(vo.getFacc()));
            logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_USE_TYPE, vo.getuT());
            logExtMap.put(AdvertReqLogExtKeyConstant.REPEAT_LUNCH_TYPE, Optional.ofNullable(vo.getRlt()).map(rlt -> rlt.toString()).orElse(null));
            logExtMap.put(AdvertReqLogExtKeyConstant.TRADE_APP_LUNCH_TYPE, Optional.ofNullable(vo.getTat()).map(tat -> tat.toString()).orElse(null));
            logExtMap.put(AdvertReqLogExtKeyConstant.RESOURCE_TAG, vo.getRt());
            logExtMap.put(AdvertReqLogExtKeyConstant.BUDGET_SMOOTH, Optional.ofNullable(vo.getBs()).map(bs -> bs.toString())
                    .orElse(AdvertOrientationPackageDO.BUDGET_SMOOTH_DEFULT.toString()));

            logExtMap.put(AdvertReqLogExtKeyConstant.IDEAL_ID,vo.getIdeId());
            logExtMap.put(AdvertReqLogExtKeyConstant.PRICE_TYPE,vo.getPte());
            logExtMap.put(AdvertReqLogExtKeyConstant.PAR_PRICE,vo.getPp());
            logExtMap.put(AdvertReqLogExtKeyConstant.BILL_TYPE,vo.getBt());
            logExtMap.put(AdvertReqLogExtKeyConstant.FEE_TYPE,vo.getFt());
            logExtMap.put(AdvertReqLogExtKeyConstant.ADX_RID,vo.getArd());
            logExtMap.put(AdvertReqLogExtKeyConstant.PUT_TYPE,vo.getPt());

            logExtMap.put(AdvertReqLogExtKeyConstant.OS_VERSION,vo.getOsv());

            logExtMap.put(AdvertReqLogExtKeyConstant.DELIVERYTYPE, vo.getDeli());

            // 自定义活动（活动工具）打印
            if (StringUtils.isNotBlank(vo.getAp())){
                logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE,vo.getAp());
            }

            //日志补全新加
            // 只在互动广告打印（为空时不打印）
            if (StringUtils.isNotBlank(vo.getSaw())){
                logExtMap.put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY,vo.getSaw());
            }
            logExtMap.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, AdvertReqLogExtKeyConstant.INTERACT);
            logExtMap.put(AdvertReqLogExtKeyConstant.DUIBA_SLOT_id, rsp.getDuibaSlotId());
            logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_STATUS, vo.getAss() + "");
            logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT_STATUS, vo.getSws() + "");
            logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT, vo.getSw() + "");
            logExtMap.put(AdvertReqLogExtKeyConstant.TARGET_APP_LIMIT, String.valueOf(vo.getTal()));
            logExtMap.put(AdvertReqLogExtKeyConstant.STRONG_TARGET, String.valueOf(vo.getSwt()));
            logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_ID, vo.getAcI());

            logExtMap.put(AdvertReqLogExtKeyConstant.A_FEE,vo.getNaf()+"");
            logExtMap.put(AdvertReqLogExtKeyConstant.PUT_INDEX,vo.getPi());
            logExtMap.put(AdvertReqLogExtKeyConstant.CITY_ID,vo.getCi());
            logExtMap.put(AdvertReqLogExtKeyConstant.PRICE_SECTION,vo.getPs());
            logExtMap.put(AdvertReqLogExtKeyConstant.BRAND_NAME,vo.getBn());
            logExtMap.put(AdvertReqLogExtKeyConstant.APP_FLOW_TYPE,vo.getAft());
            logExtMap.put(AdvertReqLogExtKeyConstant.MODEL,vo.getMl());
            logExtMap.put(AdvertReqLogExtKeyConstant.USER_AGENT,vo.getUat());
            logExtMap.put(AdvertReqLogExtKeyConstant.DEVICE_ID,vo.getDevi());
            // 设备类型
            logExtMap.put(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL,vo.getEquipmentModel());
            // 原生的Ua很长那种，这里再打印一个ip
            logExtMap.put(AdvertReqLogExtKeyConstant.USER_IP,vo.getIp());
            // 获取 deviceId
            String deviceIdM5 = getDeviceId(vo);
            logExtMap.put(AdvertReqLogExtKeyConstant.DEVICE_ID_M5,deviceIdM5);
            // 广告主落地页，和广告主的回传链接
            logExtMap.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_BACK_URL, vo.getDspId() != null ? null : advertVO.getPromoteBackUserUrl());

            logExtMap.put(AdvertReqLogExtKeyConstant.COLL_RID,vo.getCrd());
            logExtMap.put(AdvertReqLogExtKeyConstant.PACKAGE_TYPE,vo.getPkt());
            logExtMap.put(AdvertReqLogExtKeyConstant.APP_ID,vo.getAid());
            //logExtMap.put(AdvertReqLogExtKeyConstant.ADSPEC_ID,vo.getPid());
            logExtMap.put(AdvertReqLogExtKeyConstant.FLOW_TAG,vo.getFtg()+"");
            logExtMap.put(AdvertReqLogExtKeyConstant.FEE,vo.getFe());


            logExtMap.put(AdvertReqLogExtKeyConstant.IS_TEST_ACTIVITY_TYPE,vo.getIt());
            logExtMap.put(AdvertReqLogExtKeyConstant.PLAN_ID,vo.getPli());
            logExtMap.put(AdvertReqLogExtKeyConstant.SHORT_ACTIVITY_ID,vo.getSat());
            // 落地页来源 标识{@link PromoteSource}
            logExtMap.put(AdvertReqLogExtKeyConstant.ADVERT_PROMOTE_SOURCE,String.valueOf(vo.getPros()));
            // 分媒体出价
            logExtMap.put(AdvertReqLogExtKeyConstant.DIS_APP_FEE_TYPE,Optional.ofNullable(vo.getDaft()).map(type -> type.toString()).orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode().toString()));
            //素材提高测试
            Optional.ofNullable(vo.getPaId()).ifPresent(testPlanId ->logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_PLAN_ID,testPlanId));
            Optional.ofNullable(vo.getMtp()).ifPresent(materialType ->logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TYPE,materialType));
            //素材测试新增
            Optional.ofNullable(vo.getMta()).ifPresent(materialTest ->logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST,materialTest));
            Optional.ofNullable(vo.getMtId()).ifPresent(materialTestId->logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_ID,materialTestId));
            Optional.ofNullable(vo.getMtr()).ifPresent(materialTestResult ->logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_RESULT,materialTestResult));

            // 设置设备属性
            logExtMap.put(AdvertReqLogExtKeyConstant.IMEI, vo.getIme());
            logExtMap.put(AdvertReqLogExtKeyConstant.IMEI_MD5, vo.getIme5());
            logExtMap.put(AdvertReqLogExtKeyConstant.IDFA, vo.getIdfa());
            logExtMap.put(AdvertReqLogExtKeyConstant.IDFA_MD5, vo.getIdfa5());
            logExtMap.put(AdvertReqLogExtKeyConstant.PRE_ARUP,vo.getArup());
            logExtMap.put(AdvertReqLogExtKeyConstant.OAID,vo.getOaid());
            logExtMap.put(AdvertReqLogExtKeyConstant.OAID_MD5,vo.getOaid5());


            // 活动素材id
            logExtMap.put(AdvertReqLogExtKeyConstant.SCK_ID, vo.getSckId());
            // 分流标识
            logExtMap.put(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE, vo.getSft());
            // UA
            logExtMap.put(AdvertReqLogExtKeyConstant.UA, vo.getUa());
            // 虚拟广告位模拟出券标识
            logExtMap.put(AdvertReqLogExtKeyConstant.IMITATE_REQ, vo.getImoa());

            // 资源位
            logExtMap.put(AdvertReqLogExtKeyConstant.SOURCE_PAGE, vo.getSop());
            // 盘古测试字段
            logExtMap.put(AdvertReqLogExtKeyConstant.PANGE_TEST, vo.getPgt());
            logExtMap.put(AdvertReqLogExtKeyConstant.BELONG_TO_GROUP, vo.getBtg());
            logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE, vo.getAskt());
            logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_SECOND_TYPE, vo.getAset());
            logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_SUB_ACTIVITY, vo.getAsa());
            logExtMap.put(AdvertReqLogExtKeyConstant.MEDIA_UNIT, vo.getMu());

            logExtMap.put(AdvertReqLogExtKeyConstant.WIND_ID,vo.getWd());
            logExtMap.put(AdvertReqLogExtKeyConstant.IS_TAGE,vo.getTage());
            logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_MATERIAL_TYPE,vo.getAmt());

            //20191105新增
            logExtMap.put(AdvertReqLogExtKeyConstant.ACTIVITY_PUT_INDEX,vo.getApi());
            logExtMap.put(AdvertReqLogExtKeyConstant.PLUGIN_TYPE,vo.getpType());
            logExtMap.put(AdvertReqLogExtKeyConstant.XYSCJ_FREQUENCY,vo.getXf());
            logExtMap.put(AdvertReqLogExtKeyConstant.XYSCJ_PASS_TYPE,vo.getXpt());
            logExtMap.put(AdvertReqLogExtKeyConstant.PG_RESOURCE_TEST,vo.getPrt());
            logExtMap.put(AdvertReqLogExtKeyConstant.PLUGIN_ID,vo.getPgId());
            logExtMap.put(AdvertReqLogExtKeyConstant.ACT_CONF_RSP_PLUGIN_ID,vo.getAcrp());

            //20191127 人群标签 需求文档: http://cf.dui88.com/pages/viewpage.action?pageId=38785182
            logExtMap.put(AdvertReqLogExtKeyConstant.NEZHA_HITUSERINTEREST_TAGS, vo.getNh());
            logExtMap.put(AdvertReqLogExtKeyConstant.SDK_VERSION,vo.getSdkV());
            logExtMap.put(AdvertReqLogExtKeyConstant.ADX_SCENE,vo.getAdxs());
            logExtMap.put(AdvertReqLogExtKeyConstant.ALG_TYPE,vo.getAlgT());
            logExtMap.put(AdvertReqLogExtKeyConstant.ADX_GROUPID,vo.getAgid());
            //20200221新增字段 需求文档:http://cf.dui88.com/pages/viewpage.action?pageId=48342961
            logExtMap.put(AdvertReqLogExtKeyConstant.PRE_LAUNCH,vo.getPlh());
            logExtMap.put(AdvertReqLogExtKeyConstant.IS_TEST_GROUP,vo.getItg());

            //20191231新增字段
            logExtMap.put(AdvertReqLogExtKeyConstant.ALGO_VERSION,vo.getAlgV());
            logExtMap.put(AdvertReqLogExtKeyConstant.ALGO_TEST_PLANID,vo.getAlgTp());
            logExtMap.put(AdvertReqLogExtKeyConstant.SEQ_INDEX,vo.getSeI());

            //20200302新增字段
            logExtMap.put(AdvertReqLogExtKeyConstant.APP_PAID,vo.getApid());

            //20200401新增字段
            logExtMap.put(AdvertReqLogExtKeyConstant.ADX_BID_PRICE,vo.getBip());

            //20200108全链路字段
            if(vo.getLgEp() != null){
                logExtMap.putAll(vo.getLgEp());
            }

            //20200326字段
            logExtMap.put(AdvertReqLogExtKeyConstant.RESOURCE_ID, vo.getRsd());
            logExtMap.put(AdvertReqLogExtKeyConstant.STRATEGY, vo.getStgy());
            logExtMap.put(AdvertReqLogExtKeyConstant.LEVEL, vo.getLvl());

            //20200512新增  广告扶持信息
            if (StringUtils.isNotBlank(vo.getIsp())) {
                logExtMap.put(AdvertReqLogExtKeyConstant.IS_SUPPORT_PLAN, vo.getIsp());
                logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_PROMOTE, vo.getSpp());
                logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_WEIGHT, vo.getSpw());
                logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_TARGET_TYPE, vo.getSptt());
                logExtMap.put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_TARGET_COST, vo.getSptc());
            }

            //20201120新增字段  配置的投放类型 activityType
            logExtMap.put(AdvertReqLogExtKeyConstant.ORIENT_ACTIVITY_TYPE, vo.getOact());

            //20201224新增字段  dp链接
            if(StringUtils.isNotBlank(vo.getDpl())) {
                logExtMap.put(AdvertReqLogExtKeyConstant.DP_LINK_URL, vo.getDpl());
            }

            logExtMap.put(AdvertReqLogExtKeyConstant.MATERIAL_ID,advertOrderDO.getMaterialId());

            rsp.setLogExtMap(logExtMap);

            rsp.setAdvertId(advertOrderDO.getAdvertId());
            rsp.setMaterialId(advertOrderDO.getMaterialId());
            rsp.setResult(true);

            // 优惠券，券面素材信息(showType:0:根据订单表里的素材id查询素材信息,1:默认广告素材信息,2:不需要素材信息)
            if (showType != null && showType == 2) {
                return rsp;
            }

            if (vo.getDspId() != null) {
                // 优惠券，基本信息
                rsp.setCouponRemark(adxAdvert.getCouponName());
                rsp.setCouponType(AdvertDO.GENERAL_PREFERENCE_CODE);
                rsp.setThumbnailPngUrl(vo.getTbp());
                rsp.setIsWeixin(0);
                rsp.setSpecialHide(0);
                // 设置落地页标签
                rsp.setPromoteUrlTags(adxAdvert.getPromoteTags());
                rsp.setAdvertiserName(adxAdvert.getDspName());
                //设置素材信息
                rsp.setBannerPngUrl(adxAdvert.getImgUrl());
                rsp.setViceTitle(adxAdvert.getCouponName());
                rsp.setTitle(adxAdvert.getCouponName());
                rsp.setButtonText(adxAdvert.getButtonText() != null ? adxAdvert.getButtonText() : AdvertCoupon.DEFAULT_BTN_TEXT);
            } else {
                AdvertCoupon advertCoupon = serviceManager.getAdvertCouponByLocal(advertPlan.getId());
                // 优惠券，基本信息
                rsp.setCouponRemark(advertCoupon.getCouponRemark());
                rsp.setCouponType(advertCoupon.getCouponType().intValue() == 0 ? AdvertDO.GENERAL_PREFERENCE_CODE : advertCoupon.getCouponType());
                rsp.setThumbnailPngUrl(advertCoupon.getThumbnailPng());
                rsp.setIsWeixin(advertCoupon.getIsWeixin() ? 1 : 0);
                rsp.setSpecialHide(advertCoupon.getIsDisplayMenu() ? 1 : 0);
                ////设置素材信息
                buildMaterialInfo(rsp, advertOrderDO, showType, advertCoupon);
//                rsp.setPromoteDeepLink(advertVO.getPromoteDeepLink());
                rsp.setPromoteDeepLink(StringUtils.isBlank(vo.getRdp())?advertVO.getPromoteDeepLink():vo.getRdp());
                rsp.setAppDownloadUrl(advertVO.getAppDownloadUrl());
                Optional.ofNullable(serviceManager.getAdvertSdkDtoByAdvertId(advertPlan.getId())).ifPresent(advertSdkDO -> {
                    rsp.setPackageName(advertSdkDO.getPackageName());
                    rsp.setAppName(advertSdkDO.getApplicationName());
                    rsp.setAppIconUri(advertSdkDO.getAppIconUri());
                    rsp.setAppPro(advertSdkDO.getAppProUrls());
                });
                // 设置落地页标签
                rsp.setPromoteUrlTags(Optional.ofNullable(advertVO.getAdvertTagDO())
                        .map(tag -> tag.getPromoteUrlTags()).orElse(Collections.emptyList()));
                rsp.setAdvertiserName(advertVO.getAdvertiserName());
            }
            //落地页链接从历史订单表里取 发券时的落地页 url
//            rsp.setPromoteUrl(advertOrderDO.getPromoteUrl());
            rsp.setPromoteUrl(StringUtils.isBlank(vo.getRpl())?advertOrderDO.getPromoteUrl():vo.getRpl());
            rsp.setEndValid(advertOrderDO.getOverDue());
            rsp.setWindId(vo.getWd());
        } catch (Exception e) {
            logger.error("buildQueryAdvertResult happen error", e);
            rsp.setResult(false);
        }
        return rsp;
    }

    /**
     * 设置deviceId
     * @param vo
     * @return
     */
    private String getDeviceId(OrderJsonVO vo) {

        String deviceIdM5;

        if (StringUtils.isNotEmpty(vo.getIme5())) {
            deviceIdM5 = vo.getIme5();
        }else if(StringUtils.isNotEmpty(vo.getIdfa5())){
            deviceIdM5 = vo.getIdfa5();
        }else{
            deviceIdM5 = vo.getOaid5();
        }
        return deviceIdM5;
    }

    /**
     * 设置素材信息
     * @param rsp
     * @param showType
     * @param advertCoupon
     */
    @SuppressWarnings("squid:S3776")
    private void buildMaterialInfo(QueryAdvertRsp rsp, AdvertOrderDO advertOrderDO, Integer showType, AdvertCoupon advertCoupon) {

        OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
        Long defaultMaterialId = advertMaterialRecommendService.getDefaultByAdvertId(rsp.getAdvertId());
        Long materialId = advertOrderDO.getMaterialId();

        boolean isDefault = false;
        AdvertMaterialVO advertMaterialCache = null;
        if (null == materialId || -1L == materialId || (showType != null && showType == 1) || materialId.equals(defaultMaterialId)) {
            isDefault = true;
            advertMaterialCache = advertMaterialRealtionService.getMaterialCache(defaultMaterialId);
        } else {
            advertMaterialCache = advertMaterialRealtionService.getMaterialCache(materialId);
            if(null == advertMaterialCache){
                isDefault = true;
            }
        }
        rsp.setBannerPngUrl(isDefault ? advertCoupon.getBannerPng() : advertMaterialCache.getBannerPng());
        rsp.setViceTitle(isDefault ? advertCoupon.getDescription() : advertMaterialCache.getDescription());
        if(isDefault){
            rsp.setTitle(null == advertMaterialCache ? advertCoupon.getCouponName() :
                    advertMaterialRealtionService.getMaterialTitle(advertMaterialCache,vo.getProv(),
                            StringUtils.isNotBlank(vo.getNtw()) ? Integer.valueOf(vo.getNtw()) : null,
                            StringUtils.isNotBlank(vo.getOpri()) ? Integer.valueOf(vo.getOpri()) : null,
                            vo.getUa(),
                            vo.getCity()));
            rsp.setButtonText(advertCoupon.getButtonText() != null ? advertCoupon.getButtonText() : AdvertCoupon.DEFAULT_BTN_TEXT);
        }else{
            rsp.setTitle(advertMaterialRealtionService.getMaterialTitle(advertMaterialCache,vo.getProv(),
                    StringUtils.isNotBlank(vo.getNtw()) ? Integer.valueOf(vo.getNtw()) : null,
                    StringUtils.isNotBlank(vo.getOpri()) ? Integer.valueOf(vo.getOpri()) : null,
                    vo.getUa(),
                    vo.getCity()));
            rsp.setButtonText(advertMaterialCache.getButtonText() != null ? advertMaterialCache.getButtonText() : AdvertCoupon.DEFAULT_BTN_TEXT);
            //视频广告需要
            rsp.setMaterialName(advertMaterialCache.getMaterialName());
            rsp.setCouponName(advertMaterialCache.getCouponName());
            rsp.setVideoCoverUrl(advertMaterialCache.getVideoCoverUrl());
            rsp.setVideoCompletionUrl(advertMaterialCache.getVideoCompletionUrl());
            rsp.setVideoDuration(advertMaterialCache.getVideoDuration());
            rsp.setVideoActivityId(advertMaterialCache.getVideoActivityId());
            rsp.setVideoCompletionUrlVertical(advertMaterialCache.getVideoCompletionUrlVertical());
            rsp.setVideoCompletionDirection(advertMaterialCache.getVideoCompletionDirection());
            rsp.setVideoCardUrl(advertMaterialCache.getVideoCardUrl());
            rsp.setVideoExt(advertMaterialCache.getVideoExt());
        }
    }

    private void activitySourceSet(String duibaOrderId, Map<String, Object> logExtMap) {
        if (StringUtils.isNotBlank(duibaOrderId)) {
            if (duibaOrderId.startsWith("taw")) {
                logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_SOURCE.getCode(), ActivitySourceEnum.SOURCE_TUIA.getCode());
            } else {
                logExtMap.put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_SOURCE.getCode(), ActivitySourceEnum.SOURCE_DUIBA.getCode());
            }
        }
    }

    @Deprecated
    public QueryPreloadingAdvertRsp queryPreloadingAdvert(ObtainAdvertReq req) {
        QueryPreloadingAdvertRsp rsp = new QueryPreloadingAdvertRsp();
        // 请求广告
        req.setPreloadingMaterial(Boolean.TRUE);
        ObtainAdvertRsp obtainAdvertRsp = this.obtainAdvert(req);
        Long advertId = obtainAdvertRsp.getAdvertId();
        if (null == advertId) {
            return rsp;
        }
        rsp.setAdvertId(advertId);
        rsp.setListMaterialUrl(listMaterialUrl(advertId));
        return rsp;
    }

    /**
     * 获取素材
     * @param advertId
     * @return
     */
    public List<String> listMaterialUrl(Long advertId) {
        // 获取广告素材
        List<AdvertMaterialDto> advertMarialList = advertMaterialRecommendService.getMaterialListByAdvertId(advertId);
        List<String> marialUrlList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(advertMarialList)) {
            // 过滤默认素材
            marialUrlList.addAll(advertMarialList.stream().filter(marial -> marial.getIsDefault()!=AdvertMaterialDto.IS_DEFAULT)
                    .map(AdvertMaterialDto::getBannerPng).distinct().collect(Collectors.toList()));
        }
        // 从商品中心获取默认素材
        try {
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
            if (advertVO != null && null != advertVO.getCouponBase()) {
                AdvertCoupon advertCoupon = serviceManager.getAdvertCouponByLocal(advertId);
                marialUrlList.add(advertCoupon.getBannerPng());
            }
        } catch (TuiaException e) {
            logger.error("get advert Coupon Cache error, advertId=[{}]", advertId, e);
        }
        return marialUrlList;
    }

    /**
     * dsp广告订单保存
     *
     * @param req the req
     * @return the query advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    public void insertDspAdvertOrder(ObtainAdvertReq req, AdxAdvertPriceDto adxAdvertPrice) {
        try {
            // 1.查询广告订单
            AdvertOrderDO advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), null);

            //2.组装新的广告订单数据
            advertOrderDO.setAdvertId(adxAdvertPrice.getAdvertId());
            advertOrderDO.setMaterialId(adxAdvertPrice.getId());
            //把落地页url放到订单里，给日志需要的时候查询订单即可
            advertOrderDO.setPromoteUrl(adxAdvertPrice.getPromoteUrl());
            OrderJsonVO vo = JSONObject.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
            vo.setDspId(adxAdvertPrice.getDspId());
            vo.setAdxFe(adxAdvertPrice.getDecryptPrice());
            vo.setEnFe(adxAdvertPrice.getPrice());
            //供活动使用 fee 进行一些判断，dsp adx 广告精确到0.001  活动只用于比较的话 可以向上取正而不影响结果
            vo.setFe(Double.valueOf(Math.ceil(adxAdvertPrice.getFee())).longValue());
            vo.setTbp(adxAdvertPrice.getImgUrl());

            // 用户记录,全量数据
            Map<String, Integer> allUserAdxMap = new HashMap<>();
            try {
                //获取【全量时间】内用户的，广告和广告点击次数
                int recordKeepDays = serviceManager.getIntValue(AdvertSystemConfigureConstants.ADVERT_REPEAT_RECORD_KEEP_DAYS);
                consumerRecordSerivce.getHistoryAdvertTimes(req, recordKeepDays, allUserAdxMap);
            } catch (Exception e) {
                logger.error("EngineServiceImpl.insertDspAdvertOrder 用户记录异步开启异常：",e);
            }
            String key=String.valueOf(req.getDspId())+";"+String.valueOf(adxAdvertPrice.getAdvertId());
            int times = advertOrderCacheService.getAdxAdvertLaunched(allUserAdxMap, key) + 1;
            vo.setTs(times);

            String originJson = JSONObject.toJSONString(vo);
            //json信息设入
            advertOrderDO.setJson(originJson);

            //3.保存订单到hbase
            AdvertOrderExtDO orderExtDO = new AdvertOrderExtDO();
            orderExtDO.setId(adxAdvertPrice.getAdvertOrderId());
            orderExtDO.setDuibaOrderId(req.getOrderId());
            orderExtDO.setShowUrl(adxAdvertPrice.getShowUrl());
            orderExtDO.setClickUrl(adxAdvertPrice.getPromoteUrl());
            advertExposeService.insertDspAdvertOrder(advertOrderDO, orderExtDO);

            //4.更新广告订单缓存
            serviceManager.setAdvertOrderDO(req.getConsumerId(), req.getOrderId(), advertOrderDO);
        } catch (Exception ex) {
            logger.error("insertDspAdvertOrder, ex = {}", ex.getMessage());
        }
    }
    /**
     * dsp-engine 发券日志补打
     * @param req
     * @param rsp
     * @param adxAdvertPrice
     */
    public void dspLaunchLog(ObtainAdvertReq req,ObtainAdvertRsp rsp, AdxAdvertPriceDto adxAdvertPrice){
        try {
            // 1.参数校验
            checkObtainAdvertReq(req);
            req.setAdvertId(rsp.getAdvertId());
            advertExposeService.dspLaunchLog(req,rsp,adxAdvertPrice);
        }catch (Exception e){
            logger.error("dspLaunchLog, ex = {}", e.getMessage());
        }
    }

    /**
     * 互动广告补打发券日志
     */
    public void reLog(SpmlogReq req){
        //互动的发券日志打印
        advertExposeService.reLog(BeanUtils.copy(req,SpmlogReq.class));
        //互动的曝光日志打印
        iSpmService.showLog(BeanUtils.copy(req,SpmlogReq.class));
        //互动的点击日志打印
        //iSpmService.clickLog(BeanUtils.copy(req,SpmlogReq.class));
    }

    @CatTransaction(type = "obtainAdvert", name = "memoryFilter")
    public Map<Long, AdvertFilterVO> preFilterAdvertWithEsHystrix(AdvQueryParam advQueryParamTmp, ObtainAdvertReq req, FilterResult filterResult, AdvertFilter advertFilter) {





        return advertPreFilterService.preFilterAdvertWithEsHystrix(advQueryParamTmp, req, filterResult, advertFilter);
    }

    /**
     * logExtExpMap 添加额外参数用于全链路日志打印
     *
     * @param req 广告请求参数
     */
    private void addToLogExtExpMap(ObtainAdvertReq req) {
        if (CollectionUtils.isEmpty(req.getActivityTypeExt())) {
            return;
        }

        try {
            if (null == req.getLogExtExpMap()) {
                req.setLogExtExpMap(new HashMap<>());
            }
            // 增加 activityTypeExt (活动类型补充)，由于长度限制会导致分割，不能使用 "," 作为分隔符，故使用 "."
            req.getLogExtExpMap().put("activityTypeExt", Joiner.on(".").join(req.getActivityTypeExt()));
        } catch (Exception e) {
            logger.error("addToLogExtExpMap error", e);
        }
    }
}
