package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.dao.advertNewtrade.TagNewTradeDAO;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.ExpAppLimitReleaseService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;


/**
 * 限流媒体 释放逻辑实验 相关配置服务
 */
@Slf4j
@Service
public class ExpAppLimitReleaseServiceImpl implements ExpAppLimitReleaseService {

    public static final String layerCode = "REQUESTADS";
    public static final String hitValue = "1";


    public static final String APP_TRADE_KEY = "engine.exp.applimit.apptrade";

    public static final String BLACKLIST_KEY = "engine.exp.applimit.blacklist";


    @Autowired
    private ApolloPanGuService apolloPanGuService;

    @Autowired
    private TagNewTradeDAO tagNewTradeDAO;



    private LoadingCache<String,Map<Long, Set<String>>> appTradeCache = Caffeine.newBuilder()
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .build(this::appTradeCacheLoadConfig);

    private Map<Long, Set<String>> appTradeCacheLoadConfig(String apolkey) {
        String idMapStrByKeyStr = apolloPanGuService.getIdMapStrByKeyStr(apolkey);
        Map<Long,Set<String>> rtnMap = new HashMap<>();
        if(StringUtils.isNotBlank(idMapStrByKeyStr)){
            String[] levelOneList = idMapStrByKeyStr.split("&");
            for (String str : levelOneList) {
                if(StringUtils.isBlank(str)){
                    continue;
                }
                try {
                    String[] split = str.split("=");
                    //解析行业
                    String newTradeName = split[0];
//                    List<String> tradeNumList = getTradeNumListByLevelOneTradeName(split[0]);

                    String appids = split[1];
                    for (String appIdStr : appids.split(",")) {
                        Long appId = null;
                        try {
                            appId = Long.valueOf(appIdStr);
                        } catch (NumberFormatException e) {
                            log.info("参数设置错误=" + appIdStr);
                            continue;
                        }

                        Set<String> tradeNumSet = rtnMap.get(appId);
                        if (null == tradeNumSet) {
                            tradeNumSet = new HashSet<>();
                            rtnMap.put(appId,tradeNumSet);
                        }
                        tradeNumSet.add(newTradeName);
                    }
                } catch (Exception e) {
                    log.info("参数异常="+str);
                }
            }
        }
        return rtnMap;
    }

    private List<String> getTradeNumListByLevelOneTradeName(String newTradeName) {
        return tagNewTradeDAO.selectTradeNumByName(newTradeName);
    }


    private LoadingCache<String, Set<Long>> blackListCache = Caffeine.newBuilder()
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .build(this::blackListCacheLoadConfig);

    private Set<Long> blackListCacheLoadConfig(String apolkey) {
        String idMapStrByKeyStr = apolloPanGuService.getIdMapStrByKeyStr(apolkey);
        if(StringUtils.isBlank(idMapStrByKeyStr)){
            return Collections.emptySet();
        }

        Set<Long> rtnSet = new HashSet<>();
        String[] split = idMapStrByKeyStr.split(",");
        for (String s : split) {
            try {
                Long advertId = Long.valueOf(s);
                rtnSet.add(advertId);
            } catch (NumberFormatException e) {
                log.info("字符串解析异常="+idMapStrByKeyStr);
            }
        }

        return rtnSet;
    }


    @Override
    public String getLayerCode() {
        return layerCode;
    }


    @Override
    public void buildExpParam(ObtainAdvertReq req, AdvQueryParam advQueryParam, ABResult abResult) {

        //命中实验
        Map<String, String> arguments = abResult.getArguments();
        if (MapUtils.isNotEmpty(arguments) && hitValue.equals(arguments.get(layerCode))) {

            Map<Long, Set<String>> longSetMap = appTradeCache.get(APP_TRADE_KEY);

            if(MapUtils.isNotEmpty(longSetMap)) {
                //获取媒体命中的行业
                advQueryParam.setExpTradeSet(longSetMap.get(req.getAppId()));
            }
            // 获取广告黑名单
            advQueryParam.setExpBlackList(blackListCache.get(BLACKLIST_KEY));
        }

    }
}
