package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.service.ExpNetCarrierService;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class ExpNetCarrierServiceImpl implements ExpNetCarrierService {

    public static final String LAYERCODE = "NetCarrier";
    public static final String HIT_VALUE = "1";


    @Override
    public String getLayerCode() {
        return LAYERCODE;
    }

    @Override
    public void buildExpParam(AdvQueryParam advQueryParam, ABResult abResult) {

        Map<String, String> arguments = abResult.getArguments();
        if (MapUtils.isNotEmpty(arguments) && HIT_VALUE.equals(arguments.get(LAYERCODE))) {
            advQueryParam.setExpNetCarrierHit(HIT_VALUE);
        }
    }
}
