package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.dao.advert.GlobalConfigFlowDAO;
import cn.com.duiba.tuia.domain.model.GlobalConfigFlowDto;
import cn.com.duiba.tuia.domain.vo.GlobalConfigFlowVO;
import cn.com.duiba.tuia.service.GlobalConfigFlowService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

@Service
public class GlobalConfigFlowServiceImpl implements GlobalConfigFlowService {

    @Autowired
    private GlobalConfigFlowDAO globalConfigFlowDAO;

    @Resource
    private ExecutorService executorService;

    private static final Integer QUERY_ALL_KEY=1;


    private LoadingCache<Integer, Optional<List<GlobalConfigFlowVO>>> GLOBAL_CONFIG_FLOW_CACHE = CacheBuilder.newBuilder().initialCapacity(100).
            refreshAfterWrite(1,TimeUnit.HOURS).expireAfterWrite(3, TimeUnit.HOURS).
            build(new CacheLoader<Integer, Optional<List<GlobalConfigFlowVO>>>() {
                @Override
                public Optional<List<GlobalConfigFlowVO>> load(Integer key) throws Exception {
                    return Optional.ofNullable(queryAllGlobalConfig());
                }

                @Override
                public ListenableFuture<Optional<List<GlobalConfigFlowVO>>> reload(Integer key, Optional<List<GlobalConfigFlowVO>> oldValue) throws Exception {
                    ListenableFutureTask<Optional<List<GlobalConfigFlowVO>>> task= ListenableFutureTask.create(new Callable<Optional<List<GlobalConfigFlowVO>>>() {
                        @Override
                        public Optional<List<GlobalConfigFlowVO>> call() throws Exception {
                            return Optional.ofNullable(queryAllGlobalConfig());
                        }
                    });
                    executorService.submit(task);
                    return task;
                }
            });


    private List<GlobalConfigFlowVO> queryAllGlobalConfig() {


            List<GlobalConfigFlowDto> globalConfigFlowDtos=globalConfigFlowDAO.queryAll();

            if(CollectionUtils.isEmpty(globalConfigFlowDtos)){
                return Collections.emptyList();
            }

            List<GlobalConfigFlowVO> globalConfigFlowVOS= Lists.newArrayListWithCapacity(globalConfigFlowDtos.size());
            globalConfigFlowDtos.stream().forEach(dto->{

                GlobalConfigFlowVO globalConfigFlowVO=BeanUtils.copy(dto,GlobalConfigFlowVO.class);

                globalConfigFlowVO.setConfigItemValue(JSON.parseArray(dto.getConfigItemValue()));
                globalConfigFlowVO.setConfigConditionValue(JSON.parseObject(dto.getConfigConditionValue()));

                globalConfigFlowVOS.add(globalConfigFlowVO);
            });

            return globalConfigFlowVOS;

        }


    @Override
    public List<GlobalConfigFlowVO> queryAll() {
        return GLOBAL_CONFIG_FLOW_CACHE.getUnchecked(QUERY_ALL_KEY).orElse(Lists.newArrayList());
    }
}
