package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.constants.ApolloPanGuConstant;
import cn.com.duiba.tuia.constants.CommonConstants;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.IQiyiService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
@Slf4j
public class IQiyiServiceImpl implements IQiyiService {

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    /**
     * 是否爱奇艺流量
     *
     * @param req
     * @return
     */
    @Override
    public boolean isIQiyiFlow(ObtainAdvertReq req) {
        return (null != req.getFlowTag() && req.getFlowTag().equals(1) && isOpen());
    }

    /**
     * 是否要替换爱奇艺
     *
     * @param req
     * @param advertPriceVO
     * @param scene
     * @return
     */
    @Override
    public boolean isReplace(ObtainAdvertReq req, AdvertPriceVO advertPriceVO, String scene) {
        if (Objects.isNull(req.getFlowTag()) || !req.getFlowTag().equals(1)) {
            return true;
        }

        if (!isOpen()) {
            return true;
        }

        if (scene.equals(CommonConstants.PROMOTE_URL) && !advertPriceVO.getOrientPkgFilterUrlDO().isAdvertSupport()) {
            return false;
        }
        if (scene.equals(CommonConstants.ORIENT_PKG_URL) && !advertPriceVO.getOrientPkgFilterUrlDO().isPkgSupport()) {
            return false;
        }

        return true;
    }

    private boolean isOpen() {
        try {
            String value = apolloPanGuService.getIdMapStrByKeyStr(ApolloPanGuConstant.IQIYI_SWITCH);
            if (StringUtils.isBlank(value)) {
                return false;
            }
            return Integer.valueOf(value).equals(1) ? true : false;
        } catch (Exception e) {
            log.error("阿波罗配置文件获取失败", e);
            return false;
        }
    }
}
