/**
 * Project Name:engine-service<br>
 * File Name:ISpmServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.service.impl<br>
 * Date:2016年11月28日下午2:08:00<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.nezha.engine.api.enums.DayuArgumentsEnum;
import cn.com.duiba.nezha.engine.api.enums.StabilityABtestEnum;
import cn.com.duiba.tuia.cache.AdvertCompensateCacheService;
import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.constants.AdvertConstants;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.core.api.enums.advert.AdvertPkgPeriodTypeEnum;
import cn.com.duiba.tuia.dao.engine.AdvertOrderDAO;
import cn.com.duiba.tuia.domain.dataobject.*;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.log.LogConfig;
import cn.com.duiba.tuia.log.StatClickJsonLog;
import cn.com.duiba.tuia.log.StatExposureJsonLog;
import cn.com.duiba.tuia.message.ons.PracFeeOnsProducer;
import cn.com.duiba.tuia.message.rocketmq.*;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.tuia.utils.MD5;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.UrlUtils2;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.enums.*;
import cn.com.tuia.advert.model.SpmlogReq;
import cn.com.tuia.advert.service.ISpmService;
import cn.tuia.tools.api.dto.advert.AdvertCallBackDTO;
import cn.tuia.tools.api.remote.RemoteAdvertCallBackService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

/**
 * ClassName: ISpmServiceImpl <br/>
 * Function: 打点日志. <br/>
 * date: 2016年11月28日 下午2:08:00 <br/>
 *
 * @author leiliang
 * @since JDK 1.6
 */
@RestController("iSpmServiceImpl")
public class ISpmServiceImpl extends BaseService implements ISpmService {


    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private AdvertOrientationService advertOrientationService;
    @Autowired
    private PracFeeOnsProducer pracFeeOnsProducer;
    @Autowired
    private PracFeeRocketMqProducer pracFeeRocketMqProducer;
    @Autowired
    private RoiClickRocketMqProducer roiClickRocketMqProducer;
    @Autowired
    private AdvertRealDataService advertRealDataService;
    @Autowired
    private AdvertPeriodService advertPeriodService;
    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private CommonService commonService;

    @Resource
    private ExecutorService executorService;

    @Resource
    protected StringRedisTemplate stringRedisTemplate;

    @Autowired
    private DeviceApiRocketMqProducer deviceApiRocketMqProducer;
    @Resource
    private AdvertCompensateCacheService advertCompensateCacheService;

    @Autowired
    private ConsumerRecordSerivce consumerRecordSerivce;

    @Autowired
    private DeviceIpDriftCheckProducer deviceIpDriftCheckProducer;

    @Autowired
    private DataReportService dataReportService;
    @Resource
    private DspComparePriceService dspComparePriceService;
    @Autowired
    private AdvertOrderDAO advertOrderDAO;

    @Autowired
    private RemoteAdvertCallBackService advertCallBackRemoteService;

    @Autowired
    protected LogConfig logConfig;

    @Autowired
    private HotPracFeeRocketMqProducer hotPracFeeRocketMqProducer;

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    @Override
    public void showLog(SpmlogReq req) {
        try {
            //曝光请求参数验证
            if (null == req.getAdvertId() || null == req.getAppId() || null == req.getConsumerId()) {
                return;
            }
            //查询广告订单信息
            AdvertOrderDO advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), null);
            if (null == advertOrderDO) {
                logger.info("showLog advertOrderDO is null, req={}", req);
                return;
            }
            //广告id纠正
            req.setAdvertId(advertIdCorrect(advertOrderDO, req.getAdvertId()));

            //dsp adx 广告点击日志
            OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
            if (vo != null && vo.getDspId() != null) {
                showLogForDsp(req,advertOrderDO,vo);
                return;
            }

            //获取广告信息
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(req.getAdvertId());
            if (null == advertVO || null == advertVO.getAdvertPlan()) {
                logger.info("showLog advert is null, req={}, advertOrderDO={}", req, JSON.toJSONString(advertOrderDO));
                return;
            }
            AdvertPlan advertPlan = advertVO.getAdvertPlan();

            //1.曝光日志参数封装
            req = spmLogReqCommit(req, advertVO, advertOrderDO, SpmType.SPM_LOG_EXPOSURE);

            // 虚拟广告位模拟请求发券标签
            String imitateReq = req.getLogExtMap().get(AdvertReqLogExtKeyConstant.IMITATE_REQ);

            //记录折扣率
            this.setDiscountRate(req);

            //account表中的1和2扣除的都是杭州推啊账户余额，属于杭州主体，只有3扣除的才是霍尔果斯余额
            req.setEffectiveMainType(advertVO.getEffectMainType());

            //2.代理商平台统计曝光数据
            advertRealDataService.incrExposureAdvert(advertPlan.getAgentId(),
                    advertPlan.getAccountId(), req.getAdvertId(), advertPlan.getAdvertPlanId(), req.getEffectiveMainType());

            Integer encArpuResult = getEncArpuResult(req.getLogExtMap());
            //4.曝光日志打印
            if("1".equals(imitateReq)){

                // 打印虚拟发券点击日志
                StatExposureJsonLog.imitateLog(req);

                //替换了低arpu值的券则不打印正常日志
            }else if (encArpuResult == CommonConstant.YES) {
                StatExposureJsonLog.lowArpulog(req);
            } else {
                StatExposureJsonLog.log(req);
            }

            //5.记录素材展示次数,更新新老素材
            if (null != req.getMaterialId()) {
                serviceManager.updateMaterialStatus(req.getAdvertId(), req.getMaterialId(), req.getAppId());
            }

            //6.记录用户消费记录(增值替换不记录用户记录 @周艺伟)
            if(!Objects.equals(encArpuResult,CommonConstant.YES)){
                recordConsumerRecord(advertOrderDO,advertVO,req);
            }

            //7.广告主后端数据归因 ip漂移检查
            ipDriftCheck(req.getIp(),req.getDeviceId(),advertPlan.getAccountId());

        } catch (Exception e) {
            logger.error("showLog happen error, req:{}", req , e);
        }
    }

    /**
     * dsp adx 广告点击日志
     *
     * @param req
     * @param advertOrderDO
     * @param vo
     */
    private void showLogForDsp(SpmlogReq req, AdvertOrderDO advertOrderDO, OrderJsonVO vo) {
        //如果是dsp 查询广告扩展表  获取监控链接数据
        AdvertOrderExtDO orderExt = advertOrderDAO.getAdvertOrderExt(req.getConsumerId(), req.getOrderId());
        if (orderExt != null) {
            vo.setcUrl(orderExt.getClickUrl());
            vo.setsUrl(orderExt.getShowUrl());
        }

        try {
            dspComparePriceService.adxAdvertShowLog(req, advertOrderDO, vo);
            //记录用户消费记录
            recordAdxAdvertConsumerRecord(advertOrderDO, vo, req);
            //记录计费日志
            dspComparePriceService.adxAdvertConsumeLog(req, advertOrderDO, vo);
        }catch (Exception e){
            logger.info("showLogForDsp exception",e);
        }
    }

    /**
     * dsp adx advert 领取记录
     * @param advertOrderDO
     * @param vo
     * @param req
     */
    private void recordAdxAdvertConsumerRecord(AdvertOrderDO advertOrderDO, OrderJsonVO vo, SpmlogReq req) {
        try {
            DBTimeProfile.enter("finishBiz.addAdxAdvertRecordReq");

            FilterResult filterResult = new FilterResult();

            // 资源标签
            filterResult.setRepeatLunchType(vo.getRlt());
            filterResult.setRepeatResourceTag(vo.getRrt());
            filterResult.setTradeAppLunchType(vo.getTat());
            filterResult.setRandomServiceTag(vo.getRst());

            // 是否是风控导量广告位出券标记
            String slotDirection = vo.getSdt();

            // 是否参与素材测试
            Boolean testPlanMaterial = vo.getTpm();

            //广告主发券限制标记
            String limitAccountType = vo.getLat();
            AdxAdvertMaterialDO adxAdvert = dspComparePriceService.getValidAdxAdvert(vo.getDspId(), req.getAdvertId());
            String industryTags = adxAdvert == null ? null : StringTool.getStringByList(adxAdvert.getIndustryTags());
            consumerRecordSerivce.addRecordReq(advertOrderDO, industryTags, req.getMaterialId(),
                    vo.getDspId(), limitAccountType, slotDirection, filterResult, testPlanMaterial, vo);
        } finally {
            DBTimeProfile.release();
        }
    }

    /**
     * 记录用户消费记录
     * @param advertOrderDO
     * @param advertVO
     * @param req
     */
    private void recordConsumerRecord(AdvertOrderDO advertOrderDO,AdvertVO advertVO,SpmlogReq req) {
        try {
            DBTimeProfile.enter("finishBiz.addRecordReq");

            OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

            FilterResult filterResult = new FilterResult();

            // 资源标签
            filterResult.setRepeatLunchType(vo.getRlt());
            filterResult.setRepeatResourceTag(vo.getRrt());
            filterResult.setTradeAppLunchType(vo.getTat());
            filterResult.setRandomServiceTag(vo.getRst());

            // 是否是风控导量广告位出券标记
            String slotDirection = vo.getSdt();

            // 是否参与素材测试
            Boolean testPlanMaterial = vo.getTpm();

            //广告主发券限制标记
            String limitAccountType = vo.getLat();

            consumerRecordSerivce.addRecordReq(advertOrderDO, this.getTagsStr(advertVO), req.getMaterialId(),
                advertVO.getAdvertPlan().getAccountId(), limitAccountType, slotDirection, filterResult, testPlanMaterial,vo);
        } finally {
            DBTimeProfile.release();
        }
    }

    private Integer getEncArpuResult(Map<String, String> logExtMap) {
        try {
            String encArpuResult = logExtMap.get(AdvertReqLogExtKeyConstant.ENC_ARPU_RESULT);
            if (StringUtils.isBlank(encArpuResult) || !StringUtils.isNumeric(encArpuResult)) {
                return CommonConstant.NO;
            }
            return Integer.valueOf(encArpuResult);
        } catch (Exception e) {
            logger.error("getEncArpuResult exception,logExtMap:{}", JSON.toJSONString(logExtMap), e);
            return CommonConstant.NO;
        }
    }

    @Override
    @SuppressWarnings("squid:S3776")
    public void clickLog(SpmlogReq req) {
        try {
            //曝光请求参数验证
            if (null == req.getAdvertId() || null == req.getAppId() || null == req.getConsumerId()) {
                return;
            }

            //查询广告订单信息
            AdvertOrderDO advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), req.getAdxMediaType());
            if (null == advertOrderDO) {
                logger.info("clickLog advertOrderDO is null, req={}", JSON.toJSONString(req));
                return;
            }
            //广告id纠正
            req.setAdvertId(advertIdCorrect(advertOrderDO, req.getAdvertId()));


            OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

            //dsp adx 广告点击日志
            if (vo != null && vo.getDspId() != null) {
                dspComparePriceService.adxAdvertClickLog(req, advertOrderDO,vo);
                return;
            }

            //获取广告信息
            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(req.getAdvertId());
            if (null == advertVO || null == advertVO.getAdvertPlan()) {
                logger.info("clickLog advert is null, req={}, advertOrderDO={}", JSON.toJSONString(req), JSON.toJSONString(advertOrderDO));
                return;
            }
            AdvertPlan advertPlan = advertVO.getAdvertPlan();

            //1.点击日志参数封装
            req = spmLogReqCommit(req, advertVO, advertOrderDO, SpmType.SPM_LOG_CLICK);

            // 虚拟广告位模拟请求发券标签
            String imitateReq = req.getLogExtMap().get(AdvertReqLogExtKeyConstant.IMITATE_REQ);


            //判断试投素材点击量是否超过1000
            //判断当前广告落地页是否接入js
            Boolean isJs = checkIsJs(advertOrderDO);

            //广告主后端数据归因 ip漂移检查
            //ipDriftCheck(req.getIp(),req.getDeviceId());

            //广告主数据归因 ip+ua 数据采集
            saveDeviceToHbase(req, advertVO, vo,isJs);

            // 设置赔付日期x
            setCompensateDate(req, vo);

            //2.获取广告出价
            req = getFee(advertOrderDO, req);

            //3.对广告计费类型进行判断.如果是cpa类型,发送点击消息
            sendOnsOCPCMes(req, advertOrderDO);

            //4.记录用户领取的广告被点击（重复曝光）
            consumerService.flagAdvertClicked(req.getConsumerId(), req.getAdvertId());

            //5.记录折扣率
            this.setDiscountRate(req);

            String date = new DateTime().toString("yyyy-MM-dd");
            //6.检查当前点击有效性
            boolean isClickVaild = serviceManager.checkClickVaild(req.getAppId(), req.getAdvertId(), req.getConsumerId(), date);
            //判断从广告券领取到广告券点击是否未超过24 小时
            boolean timeFlag = advertOrderDO.getGmtCreate() != null && System.currentTimeMillis() - advertOrderDO.getGmtCreate().getTime() > 86400000 ? false : true;
            if (isClickVaild && timeFlag) {
                req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CLICK_VAILD, String.valueOf(CommonConstant.YES));
                try{
                    boolean isEnoughBudget = commonService.isEnoughBudget(advertVO, req.getFee());
                    req.setEffectiveMainType(advertVO.getEffectMainType());
                    //6.1 发送扣费消息
                    checkClickValid(isEnoughBudget, advertVO.getCurrentMainStatus(), req, advertOrderDO, date,advertPlan.getAccountId());

                    // 计划赔付处理
                    handleCompensate(req.getFee(), advertOrderDO.getAdvertId(), vo.getCmpd());
                } catch (Exception e) {
                    logger.error("isEnoughBudget happen error, because of=[{}]", e);
                }
            }else{
                req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CLICK_VAILD, String.valueOf(CommonConstant.NO));
            }
            //account表中的1和2扣除的都是杭州推啊账户余额，属于杭州主体，只有3扣除的才是霍尔果斯余额
            req.setEffectiveMainType(advertVO.getEffectMainType());
            // 新媒体试投参数
            NewAppTest newAppTest = getNewAppTest(vo.getAt(), req.getAppId(), req.getAdvertId(), vo.getAtn());
            //7.记录点击数,获取代理商平台使用
            advertRealDataService.incrClickAdvert(advertPlan.getAgentId(),
                    advertPlan.getAccountId(), req.getAdvertId(), advertPlan.getAdvertPlanId(),req.getEffectiveMainType(), newAppTest);

            //8.记录点击日志

            Integer encArpuResult = getEncArpuResult(req.getLogExtMap());
            if("1".equals(imitateReq)){

                // 打印虚拟发券点击日志
                StatClickJsonLog.imitateLog(req);

                //替换了低arpu值的券则不打印正常日志
            }else if (encArpuResult == CommonConstant.YES) {
                //被替换掉的一般不会发生点击，但是为了防止0.01%的可能，所以增加这个判断
                StatClickJsonLog.lowArpulog(req);
            } else {
                StatClickJsonLog.log(req);
            }

            //9.数据回传广告主
            reportToAdvert(req,advertVO,vo);

        } catch (Exception e) {
            logger.error("clickLog happen error, because of=[{}]", e);
        }
    }

    /**
     * 给广告主回传信息
     *
     * @param req
     */
    private void reportToAdvert(SpmlogReq req,AdvertVO advertVO,OrderJsonVO vo) {

        //这里只有美团ADX的点击流量才会进行数据上报
        String adxMediaType = req.getAdxMediaType();
        if(!AdxSceneEnum.ADX_MEITUAN.getCode().equals(adxMediaType)){
            return;
        }


        String promoteBackUserUrl = Optional.ofNullable(advertVO.getPromoteBackUserUrl()).orElse("");
        if (StringUtils.isNotBlank(promoteBackUserUrl)) {
            if (!promoteBackUserUrl.startsWith("http")) {
                // 如果没有协议头，默认http请求
                promoteBackUserUrl = "http://" + promoteBackUserUrl;
            }

            Map<String, String> promoteBackUserUrlParam = UrlUtils2.extractUrlParamsFromUrl(promoteBackUserUrl);
            //是否需要回传数据
            if (promoteBackUserUrlParam != null && "2".equals(promoteBackUserUrlParam.get("macro"))) {
                //新的上报逻辑
                publicReport(req, advertVO, vo, promoteBackUserUrl);

            }else{
                if (promoteBackUserUrl.trim().startsWith("https://wcp.taobao.com/adstrack/track.json")) {
                    dataReportService.reportShouTao(req, advertVO, promoteBackUserUrl);
                } else {
                    dataReportService.reportStandard(req, advertVO, vo, promoteBackUserUrl);
                }
            }
        }
    }

    private void publicReport(SpmlogReq req, AdvertVO advertVO, OrderJsonVO vo, String promoteBackUserUrl) {
        //新上报逻辑数据组装
        AdvertCallBackDTO param = new AdvertCallBackDTO();
        param.setPromoteBackUserUrl(promoteBackUserUrl);
        JSONObject orderJsonVO = buildJsonObj(req,advertVO,vo);
        param.setOrderJsonVO(orderJsonVO);
        advertCallBackRemoteService.advertCallBackHttp(param);
    }

    /**
     * 此处map put的顺序请勿随意更改
     * @param req
     * @param advertVO
     * @param vo
     * @return
     */
    private JSONObject buildJsonObj(SpmlogReq req, AdvertVO advertVO, OrderJsonVO vo) {

        String reqStr = JSON.toJSONString(req);
        String voStr = JSON.toJSONString(vo);

        Map<String,String> reqMap = JSONObject.parseObject(reqStr,Map.class);
        Map<String, String> logExtMap = req.getLogExtMap();
        Map<String, String> logExtExpMap = req.getLogExtExpMap();
        Map<String,String> voMap = JSONObject.parseObject(voStr,Map.class);

        //
        if(reqMap.containsKey("logExtMap")){
            reqMap.remove("logExtMap");
        }

        if(reqMap.containsKey("logExtExpMap")){
            reqMap.remove("logExtExpMap");
        }

        JSONObject rtnObject = new JSONObject();
        rtnObject.putAll(reqMap);
        rtnObject.putAll(logExtMap);
        rtnObject.putAll(logExtExpMap);
        rtnObject.putAll(voMap);

        return rtnObject;
    }

    /**
     * 判断当前广告对应的落地页是否接入js
     * @param advertOrderDO
     * @return
     */
    private Boolean checkIsJs(AdvertOrderDO advertOrderDO){

        Long advertId = null;
        String promoteUrl = null;
        String duibaOrderId = null;
        try {
            //获取当前订单中的落地页地址
            advertId = advertOrderDO.getAdvertId();
            promoteUrl = advertOrderDO.getPromoteUrl();
            duibaOrderId = advertOrderDO.getDuibaOrderId();

            String promoteUrlMd5 = MD5.md5(promoteUrl);
            String key = advertId+"-"+promoteUrlMd5;

            //从缓存中获取,当前key 是否接入js
            return serviceManager.getPromoteJsFromCache(key);
        }catch (Exception e){
            return false;
        }
    }

    private void handleCompensate(Long fee, Long advertId, String compensateDate) {
        advertCompensateCacheService.handleConsume(fee, advertId, compensateDate);
    }

    private void setCompensateDate(SpmlogReq req, OrderJsonVO vo) {
        if(StringUtils.isNotBlank(vo.getCmpd())){
            req.getLogExtMap().put("compensateDate", vo.getCmpd());
        }
    }

    /**
     * 广告主数据归因 ip 漂移检查
     * @param ip
     * @param deviceId
     */
    private void ipDriftCheck(String ip,String deviceId,Long accountId){

        if(org.apache.commons.lang.StringUtils.isBlank(ip) || org.apache.commons.lang.StringUtils.isBlank(deviceId)){
            return;
        }

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("ip",ip);
        jsonObject.put("deviceId",deviceId);
        jsonObject.put("accountId", accountId);

        try {
            deviceIpDriftCheckProducer.sendMsg(jsonObject.toJSONString(), null);
        }catch (Exception e){
            logger.warn("ipDriftCheck exception,deviceId:{}",deviceId,e);
        }
    }

    /**
     * 将设备id 存入到hbase
     * @param req
     * @param advertVO
     * @param vo
     */
    private void saveDeviceToHbase(SpmlogReq req, AdvertVO advertVO, OrderJsonVO vo,Boolean isJs) {

        String imeMd5 = vo.getIme5();
        String idfMd5 = vo.getIdfa5();

        // IP 或 UA 为空,不发送消息
        if (StringUtils.isBlank(imeMd5) && StringUtils.isBlank(idfMd5)) {
            if (StringUtils.isBlank(vo.getIp()) || StringUtils.isBlank(vo.getUat())) {
                return;
            }
        }


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("deviceId", StringUtils.isNotBlank(imeMd5)? imeMd5:idfMd5);
        jsonObject.put("accountId", advertVO.getAdvertPlan().getAccountId());
        jsonObject.put("orderId", req.getActivityOrderId());

        jsonObject.put("ip",req.getIp());
        jsonObject.put("ua",req.getUserAgent());
        jsonObject.put("isJs",isJs);
        jsonObject.put("device",req.getDeviceId());
        try {
            logger.info("clickLog ....param:{}", jsonObject.toJSONString());
            deviceApiRocketMqProducer.sendMsg(jsonObject.toJSONString(), null);
        } catch (Exception e) {
            logger.info("spmLogReqCommit exception.", e);
        }
    }

    /**
     * getNewAppTest:(新媒体试投参数组装). <br/>
     *
     * @param type
     * @param appId
     * @param advertId
     * @param tradeName
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    private NewAppTest getNewAppTest(String type, Long appId, Long advertId, String tradeName) {
        NewAppTest newAppTest = new NewAppTest();
        if (type != null && type.equals(NewAppAdvertTradeDO.APP_TYPE_NEW_TEST.toString())) {
            newAppTest.setAdvertId(advertId);
            newAppTest.setAppId(appId);
            newAppTest.setNewAppType(NewAppAdvertTradeDO.APP_TYPE_NEW_TEST);
            newAppTest.setTradeName(tradeName);
        }
        return newAppTest;
    }

    /**
     * 设置折扣率
     *
     * @param req
     */
    private void setDiscountRate(SpmlogReq req) {

        ChargeTypeEnum chargeTypeEnum = ChargeTypeEnum.getByDesc(req.getChargeType());
        double discountrate = advertMapCacheManager.getAdvertBidRate(req.getAdvertId(), chargeTypeEnum.getCode());
        req.setDiscountRate(discountrate);
    }

    /**
     * 判断有效点击，发送ons消息消费
     * checkClickValid:<br/>
     *
     * @param isEnoughBudget
     * @param req
     * @param advertOrderDO
     * @author zp
     * @since JDK 1.6
     */

    private void checkClickValid(boolean isEnoughBudget,Integer currentMainStatus,SpmlogReq req,AdvertOrderDO advertOrderDO,String date,Long accountId){
        try {
            //扣费帐号余额判断
            if (!isEnoughBudget) {
                return;
            }
            req.setType(SpmType.SPM_LOG_CHARGE);
            AsynReq asynReq = new AsynReq();
            asynReq.setReqType(AsynReqType.CONSUME);
            asynReq.setAdvertId(req.getAdvertId());
            asynReq.setAppId(req.getAppId());
            asynReq.setAdvertOrderId(advertOrderDO.getId());
            asynReq.setReqTime(date);
            asynReq.setAdvertPackageId(req.getOrientationId());
            asynReq.setCurrentMainStatus(currentMainStatus);
            OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
            Optional.ofNullable(vo.getSty()).map(CVRTypeEnum::changeSubtypeToCVRType).ifPresent(asynReq::setCvrType);
            //投放时段
            asynReq.setPeriod(buildPeriod(vo, req));
            asynReq.setFee(req.getFee());
            asynReq.setHitUserInterest(vo.getHui());

            //热点广告主 的 计费消息走另外一个消息队列
            Map<String, String> idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.hot-account");
            if(null != idMapByKeyStr && idMapByKeyStr.containsKey(String.valueOf(accountId))){
                hotPracFeeRocketMqProducer.sendMsg(req,asynReq);
            }else{
                pracFeeRocketMqProducer.sendMsg(req, asynReq);
            }

        } catch (Exception e) {
            logger.error("send consume Fee ons happen error, because of=[{}]", e);
        }
    }

    /**
     * 从订单json字段取内容，并打在日志里面 specifyConfigBagReq:<br/>
     *
     * @param vo
     * @param req
     * @author zp
     * @since JDK 1.6
     */
    private SpmlogReq specifyConfigBagReq(OrderJsonVO vo, SpmlogReq req, AdvertVO advertVO) { // NOSONAR
        if (null == vo) {
            // 定向配置报为空时，插入默认id
            req.setOrientationId(0L);
            return req;
        }
        // 记录定向配置包id
        req.setOrientationId(null == vo.getPid() ? 0L : vo.getPid());
        if (vo.getCt() != null) {
            req.setChargeType(ChargeTypeEnum.getDescByCode(vo.getCt()));
        }
        req.setFee(vo.getFe());
        req.setPriceSection(vo.getPs());

        // 记录请求来源
        if (StringUtils.isNotBlank(vo.getuT())) {
            req.setActivityUseType(Integer.parseInt(vo.getuT()));
        }
        // 记录请求活动类型
        if (StringUtils.isNotBlank(vo.getAcT())) {
            req.setDuibaActivityType(vo.getAcT());
        }
        //ua
        if (StringUtils.isNotBlank(vo.getUa())) {
            req.setUa(vo.getUa());
        }
        //设备id
        if (StringUtils.isNotBlank(vo.getDevi())) {
            req.setDeviceId(vo.getDevi());
        }

        if (null == req.getLogExtMap()) {
            req.setLogExtMap(Maps.newHashMap());
        }

        //日志拓展字段，全链路都打
        req.setLogExtExpMap(vo.getLgEp());

        //点击位置，该字段只需要互动广告点击和计费日志有，其他地方不需要打印
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CLICK_POSITION, String.valueOf(req.getClickPosition()));
        // 记录领券次数
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_TIMES.getCode(), String.valueOf(vo.getTs()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_STRATEGY_TYPE.getCode(), vo.getSt());
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PRIVILEGE.getCode(), String.valueOf(vo.getTp()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACCOUNT_ID.getCode(),
                String.valueOf(advertVO.getAdvertPlan().getAccountId()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_AGENT_ID.getCode(),
                String.valueOf(advertVO.getAdvertPlan().getAgentId()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_EXPS.getCode(), String.valueOf(vo.getExps()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.FLOW_TAG.getCode(), String.valueOf(vo.getfTag()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_PACKAGE_TYPE.getCode(), String.valueOf(vo.getPkt()));
        req.getLogExtMap().put(AdvertOrderJsonKeyEnum.KEY_ACTIVITY_TYPE.getCode(), String.valueOf(vo.getAst()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP, vo.getTsp() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRUSTEESHIP_CONVERT_COST, vo.getTspFee() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.GAME_TAG, Optional.ofNullable(vo.getGm()).orElse(CommonServiceImpl.BAICHUAN_GAME_TAG));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.RISK_CHEAT, vo.getRc());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_TYPE, Optional.ofNullable(vo.getAt()).orElse(NewAppAdvertTradeDO.APP_TYPE_OLD.toString()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEW_APP_TEST_FEE, String.valueOf(vo.getNbf()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_PACKAGE_ID, vo.getTap() == null ? null : vo.getTap() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_RECOMMEND_TYPE, Optional.ofNullable(vo.getTrt()).orElse(0) + "");

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_STATUS, vo.getAss() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT_STATUS, vo.getSws() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_WEIGHT, vo.getSw() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ENC_ARPU_RESULT, vo.getEncAr() + "");
        if (vo.getSty() != null) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUBTYPE, String.valueOf(vo.getSty()));
        }
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEPTH_SUBTYPE, String.valueOf(vo.getDsty()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TARGET_TYPE, String.valueOf(vo.getPtt()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TARGET_APP_LIMIT, String.valueOf(vo.getTal()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.STRONG_TARGET, String.valueOf(vo.getSwt()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.FOCUS_APP_CONVERT_COST, String.valueOf(vo.getFacc()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FEE, String.valueOf(vo.getAppFee()));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.REPEAT_LUNCH_TYPE, Optional.ofNullable(vo.getRlt()).map(rlt -> rlt.toString()).orElse(null));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.TRADE_APP_LUNCH_TYPE, Optional.ofNullable(vo.getTat()).map(tat -> tat.toString()).orElse(null));
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.RESOURCE_TAG, vo.getRt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BUDGET_SMOOTH, Optional.ofNullable(vo.getBs()).map(bs -> bs.toString())
                .orElse(AdvertOrientationPackageDO.BUDGET_SMOOTH_DEFULT.toString()));

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDEAL_ID, vo.getIdeId());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_TYPE, vo.getPte());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PAR_PRICE, vo.getPp());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BILL_TYPE, vo.getBt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.FEE_TYPE, vo.getFt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_RID, vo.getArd());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_TYPE, vo.getPt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DSM2, vo.getDsm2());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.OS_VERSION, vo.getOsv());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.UA, vo.getUa());

        //日志补全新加
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.A_FEE, vo.getNaf() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PUT_INDEX, vo.getPi() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CITY_ID, vo.getCi());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRICE_SECTION, vo.getPs());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BRAND_NAME, vo.getBn());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.EQUIPMENT_MODEL, vo.getEquipmentModel());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_FLOW_TYPE, vo.getAft());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MODEL, vo.getMl());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.CONNECTION_TYPE, vo.getNtwn());
        //req.getLogExtMap().put(AdvertReqLogExtKeyConstant.USER_AGENT,vo.getUa());
        //req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DEVICE_ID,vo.getDevi());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_TEST_ACTIVITY_TYPE, vo.getIt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PLAN_ID, vo.getPli());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SHORT_ACTIVITY_ID, vo.getSat());
        // 落地页来源 标识{@link PromoteSource}
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADVERT_PROMOTE_SOURCE, String.valueOf(vo.getPros()));
        // 分媒体出价类型
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.DIS_APP_FEE_TYPE,Optional.ofNullable(vo.getDaft()).map(type -> type.toString())
                               .orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode().toString()));

        //素材提高测试
        Optional.ofNullable(vo.getPaId()).ifPresent(testPlanId ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_PLAN_ID,String.valueOf(testPlanId)));
        Optional.ofNullable(vo.getMtp()).ifPresent(materialType ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TYPE,materialType));
        Optional.ofNullable(vo.getMta()).ifPresent(materialTest ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST,""+materialTest));
        Optional.ofNullable(vo.getMtId()).ifPresent(materialTestId ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_ID,""+materialTestId));
        Optional.ofNullable(vo.getMtr()).ifPresent(materialTestResult ->req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MATERIAL_TEST_RESULT,""+materialTestResult));

        //如何是兑吧的活动，则无广告位概念
        // 测试广告位子投放方式 :只在互动广告打印（为空时不打印）
        if (StringUtils.isNotBlank(vo.getSaw())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUB_ACTIVITY_WAY, vo.getSaw());
        }
        // 自定义活动（活动工具）打印
        if (StringUtils.isNotBlank(vo.getAp())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_PAGE, vo.getAp());
        }
        // 如何是兑吧的活动，则无广告位概念
        if (req.getActivityUseType() != null && (0 == req.getActivityUseType() || 1 == req.getActivityUseType())) {
            req.setDuibaSlotId(req.getSlotId());
            req.setSlotId(null);
        }

        // 设置设备信息
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IMEI, vo.getIme());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IMEI_MD5, vo.getIme5());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDFA, vo.getIdfa());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IDFA_MD5, vo.getIdfa5());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_ARUP,vo.getArup()+"");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.OAID,vo.getOaid());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.OAID_MD5,vo.getOaid5());

        // 活动素材id
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SCK_ID, vo.getSckId());
        // 分流标识
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SCK_FORM_TYPE, vo.getSft());
        // 资源位
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SOURCE_PAGE, vo.getSop());
        // 盘古测试字段
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PANGE_TEST, vo.getPgt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.BELONG_TO_GROUP, vo.getBtg());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_SKIN_TYPE, vo.getAskt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_SECOND_TYPE, vo.getAset());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_SUB_ACTIVITY, vo.getAsa());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.MEDIA_UNIT, vo.getMu());
        // ADX 参数
        setAdxParam(vo, req);

        // 虚拟广告位模拟发券请求
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IMITATE_REQ, vo.getImoa());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_MATERIAL_TYPE,vo.getAmt()+"");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.WIND_ID,vo.getWd()+"");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_TAGE,vo.getTage()+"");
        //201911005新增
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACTIVITY_PUT_INDEX,vo.getApi());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PLUGIN_TYPE,vo.getpType());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.XYSCJ_FREQUENCY,vo.getXf());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.XYSCJ_PASS_TYPE,vo.getXpt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PG_RESOURCE_TEST,vo.getPrt());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PLUGIN_ID,vo.getPgId());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ACT_CONF_RSP_PLUGIN_ID,vo.getAcrp());

        // 人群标签
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.NEZHA_HITUSERINTEREST_TAGS, vo.getNh());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ALG_TYPE,vo.getAlgT());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SDK_VERSION,vo.getSdkV());

        // adx 推广组ID
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_GROUPID, vo.getAgid());

        //20200221新增字段 需求文档:http://cf.dui88.com/pages/viewpage.action?pageId=48342961
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_LAUNCH, vo.getPlh());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_TEST_GROUP,vo.getItg());

        //20191231新增
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ALGO_VERSION,vo.getAlgV());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ALGO_TEST_PLANID,vo.getAlgTp());
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SEQ_INDEX,vo.getSeI());

        //20200220新增
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.REAL_TIME_RTA, vo.getRlr());

        //20200302新增
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.APP_PAID, vo.getApid());

        //20200401新增
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_BID_PRICE, vo.getBip());

        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CTR, vo.getPctr() == null ? null : vo.getPctr() + "");
        req.getLogExtMap().put(AdvertReqLogExtKeyConstant.PRE_CVR, vo.getPcvr() == null ? null : vo.getPcvr() + "");


        //20200512新增  广告扶持信息
        if (StringUtils.isNotBlank(vo.getIsp())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_SUPPORT_PLAN, vo.getIsp());
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_PROMOTE, vo.getSpp());
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_WEIGHT, vo.getSpw());
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_TARGET_TYPE, vo.getSptt());
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.SUPPORT_PLAN_TARGET_COST, vo.getSptc());
        }

        return req;
    }

    private void setAdxParam(OrderJsonVO vo, SpmlogReq req) {

        if (StringUtils.isNotBlank(vo.getRsd())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.RESOURCE_ID, vo.getRsd());
        }

        if (StringUtils.isNotBlank(vo.getApl())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_PRICE_LEVEL, vo.getApl());
        }

        if (StringUtils.isNotBlank(vo.getIcg())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.IS_COMPARE_GROUP, vo.getIcg());
        }

        if (StringUtils.isNotBlank(vo.getLvl())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.LEVEL, vo.getLvl());
        }

        if (StringUtils.isNotBlank(vo.getStgy())) {
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.STRATEGY, vo.getStgy());
        }

        if(StringUtils.isNotBlank(vo.getAdxs())){
            req.getLogExtMap().put(AdvertReqLogExtKeyConstant.ADX_SCENE,vo.getAdxs());
        }
    }

    private Period buildPeriod(OrderJsonVO vo, SpmlogReq req) {
        // 投放时段id为空
        if (vo == null || vo.getPeid() == null) {
            return null;
        }
        AdvertPlanPeriodDO palnPeriod = advertPeriodService.getPeriodCacheById(vo.getPeid());
        if (palnPeriod == null) {
            return null;
        }
        Period period = new Period();
        period.setPeriodId(vo.getPeid());
        period.setPeriodValue(palnPeriod.getPeriodValue());
        period.setPeriodType(palnPeriod.getPeriodType());
        if (AdvertPkgPeriodTypeEnum.PERIOD_TYPE_COUNT_BUDGET.getCode().equals(palnPeriod.getPeriodType())
                || AdvertPkgPeriodTypeEnum.PERIOD_TYPE_HOUR_BUDGET.getCode().equals(palnPeriod.getPeriodType())) {
            period.setExpendBudget(req.getFee());
            period.setCurPeriodTime(advertPeriodService.getCurPeriodTime(period.getPeriodType()));
        }
        return period;
    }

    /**
     * 广告Id纠正
     *
     * @param advertOrderDO
     * @param advertId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private Long advertIdCorrect(AdvertOrderDO advertOrderDO, Long advertId) {
        if (null == advertId || advertId.equals(0L) || !advertId.equals(advertOrderDO.getAdvertId())) {
            return advertOrderDO.getAdvertId();
        }
        return advertId;
    }

    /**
     * 活动id纠正
     * activityIdCorrent:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param advertOrderDO
     * @param activityId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private Long activityIdCorrent(AdvertOrderDO advertOrderDO, Long activityId) {
        if (null == activityId || activityId.equals(0L) || !activityId.equals(advertOrderDO.getDuibaActivityId())) {
            return advertOrderDO.getDuibaActivityId();
        }
        return activityId;
    }
    
    
    /**
     * appId纠正
     * appIdCorrent:(appId纠正，以广告订单为准). <br/>
     *
     * @param advertOrderDO
     * @param appId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    private Long appIdCorrent(AdvertOrderDO advertOrderDO, Long appId) {
        if (null == appId || appId.equals(0L) || !appId.equals(advertOrderDO.getAppId())) {
            return advertOrderDO.getAppId();
        }
        return appId;
    }
    

    /**
     * 获取扣费单价.
     *
     * @param advertOrderDO the advert order do
     * @param req           the req
     * @return the fee
     * @throws TuiaException the tuia exception
     * @author zp
     * @since JDK 1.6
     */
    private SpmlogReq getFee(AdvertOrderDO advertOrderDO, SpmlogReq req) throws TuiaException {
        OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
        if (null != vo && null != vo.getFe()) {
            if (vo.getCt() != null) {
                req.setChargeType(ChargeTypeEnum.getDescByCode(vo.getCt()));
            }
            req.setFee(vo.getFe());
            return req;
        }
        if (null != vo && null != vo.getPid() && vo.getPid() != 0) {
            AdvertOrientationPackageDO packageDO = advertOrientationService.getOrientation(vo.getPid());
            if (packageDO.getChargeType() != null) {
                req.setChargeType(ChargeTypeEnum.getDescByCode(packageDO.getChargeType()));
            } else {
                req.setChargeType(ChargeTypeEnum.TYPE_CPC.getDesc());
            }
            req.setFee(packageDO.getFee());
            return req;
        }

        if (null != vo && null != vo.getPid() && vo.getPid() == 0) {
            AdvertOrientationPackageDO packageDO = advertOrientationService.getOrientation(advertOrderDO.getAdvertId(), AdvertConstants.DEFAULT_ORIENTATION_ID);
            if (packageDO.getChargeType() != null) {
                req.setChargeType(ChargeTypeEnum.getDescByCode(packageDO.getChargeType()));
            } else {
                req.setChargeType(ChargeTypeEnum.TYPE_CPC.getDesc());
            }
            req.setFee(packageDO.getFee());
        }

        return req;
    }

    /**
     * 发送OCPC维稳消息 sendOnsOCPCMes:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param req
     * @param advertOrderDO
     * @author zp
     * @since JDK 1.6
     */
    private void sendOnsOCPCMes(SpmlogReq req, AdvertOrderDO advertOrderDO) {
        try {
            if (null == req.getChargeType() || !req.getChargeType().equals("CPA")) {
                return;
            }
            OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);
            if (null == vo || null == vo.getAfe()) {
                return;
            }

            // 判断是否命中了新维稳，如果是，则不用发送消息
            Map<String, String> logExtExpMap = req.getLogExtExpMap();
            if (logExtExpMap != null && !logExtExpMap.isEmpty()) {

                String abTest = logExtExpMap.get(DayuArgumentsEnum.STABILITY_AB.getKey());

                if (StabilityABtestEnum.NEW_STABILITY.getCodeStr().equals(abTest)) {
                    return;
                }
            }

            AdvertClick click = new AdvertClick();
            click.setAdid(req.getAdvertId());

            // 配置原本价格：Optional处理上线期间的兼容
            click.setTargetCpa(String.valueOf(Optional.ofNullable(vo.getTca()).orElse(vo.getAfe())));

            // 分媒体出价
            click.setAppTargetCpa(String.valueOf(vo.getAppFee()));

            if (vo.getFacc() != null) {
                click.setAppTargetCpa(String.valueOf(vo.getFacc()));
            }
            // 如果分媒体出价为空，则用配置出价 --- 亚伟 20191202
            if (StringUtils.isBlank(click.getAppTargetCpa()) || "null".equals(click.getAppTargetCpa())) {
                click.setAppTargetCpa(click.getTargetCpa());
            }

            click.setPackageId(String.valueOf(req.getOrientationId()));
            AdvertOrientationPackageDO packageDO = advertOrientationService.getOrientation(req.getAdvertId(), req.getOrientationId());
            click.setBudgetPerDay(MoreObjects.firstNonNull(packageDO.getBudgetPerDay(),
                    Long.parseLong(String.valueOf(Integer.MAX_VALUE))));
            click.setAppId(MoreObjects.firstNonNull(req.getAppId(), 0L));
            click.setSlotId(MoreObjects.firstNonNull(req.getSlotId(), 0L));
            click.setActivityId(buildActivityId(req.getActivityOrderId(), req.getActivityId()));
            click.setCvrType(Optional.ofNullable(req.getLogExtMap()).map(map ->
                    Optional.ofNullable(map.get(AdvertReqLogExtKeyConstant.SUBTYPE))
                            .map(subType -> CVRTypeEnum.changeSubtypeToCVRType(Integer.parseInt(subType)))
                            .orElse(null)
            ).orElse(null));
            click.setMaterialId(advertOrderDO.getMaterialId() + "");
            click.setTrusteeship(vo.getTsp());
            click.setReleaseTarget(vo.getPtt());
            // 分媒体出价覆盖时，给nezha维稳的值为8
            Integer disAppFeeType = Optional.ofNullable(vo.getDaft()).orElse(DisAppFeeTypeEnum.DEFULT_TYPE.getCode());
            Integer appCostStableSwitch = Optional.ofNullable(vo.getAcs()).orElse(SwitchTypeEnum.CLOSE_TYPE.getCode());
            if (disAppFeeType.equals(DisAppFeeTypeEnum.ORDINARY_APP_CPA_TYPE.getCode()) && appCostStableSwitch.equals(SwitchTypeEnum.OPEN_TYPE.getCode())) {
                click.setReleaseTarget(AdvertClick.APP_COST_STABLE_SWITCH_UNM);
            }

            // 命中流量人群的标签
            click.setHitUserInterest(vo.getHui());

            logger.info("点击维稳日志：orderId={}, content={}", advertOrderDO.getDuibaOrderId(), JSON.toJSONString(click));
            roiClickRocketMqProducer.sendMsg(click, String.valueOf(req.getAdvertId()));
        } catch (Exception e) {
            logger.error("sendOnsOCPCMes error", e);
        }
    }

    private String buildActivityId(String activityOrderId, Long activityId) {
        if (null != activityOrderId && activityOrderId.startsWith("taw")) {
            return ActivitySourceEnum.SOURCE_TUIA.getCode() + "_" + activityId;
        } else {
            return ActivitySourceEnum.SOURCE_DUIBA.getCode() + "_" + activityId;
        }
    }

    /**
     * 广告曝光，点击参数封装
     * spmLogReqCommit:(). <br/>
     *
     * @param spmlogReq
     * @param advertVO
     * @param advertOrderDO
     * @param type
     * @return
     * @throws Exception
     * @author zp
     * @since JDK 1.6
     */
    private SpmlogReq spmLogReqCommit(SpmlogReq spmlogReq, AdvertVO advertVO, AdvertOrderDO advertOrderDO, String type) {
        spmlogReq.setActivityId(activityIdCorrent(advertOrderDO, spmlogReq.getActivityId()));//活动id 纠正
        spmlogReq.setAppId(appIdCorrent(advertOrderDO, spmlogReq.getAppId()));

        spmlogReq.setSlotId(advertOrderDO.getSlotId());
        spmlogReq.setMaterialId(advertOrderDO.getMaterialId());
        spmlogReq.setActivityOrderId(spmlogReq.getOrderId());
        if (spmlogReq.getActivityUseType() == null) {
            spmlogReq.setActivityUseType(spmlogReq.getSlotId() == null ? 0 : 1);
        }
        spmlogReq.setInfo(String.valueOf(advertOrderDO.getId()));
        spmlogReq.setOrderId(String.valueOf(advertOrderDO.getId()));
        spmlogReq.setType(type);

        OrderJsonVO vo = JSON.parseObject(advertOrderDO.getJson(), OrderJsonVO.class);

        // 订单json字段获取塞入日志里面
        spmlogReq = specifyConfigBagReq(vo, spmlogReq, advertVO);
        Map<String, String> map = spmlogReq.getLogExtMap();
        if (null == map) {
            map = new HashMap<>(10);
        }
        map.put(AdvertReqLogExtKeyConstant.LAUNCH_LOG_PROMOTE_URL, advertOrderDO.getPromoteUrl());
        return spmlogReq;
    }

    private String getTagsStr(AdvertVO advertVO) {
        AdvertTagDO advertTagDO = advertVO.getAdvertTagDO();
        if (advertTagDO == null) {
            return null;
        } else {
            return advertTagDO.getMatchTagNums();
        }
    }
}
