package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.service.IdWokerService;
import cn.com.duiba.tuia.utils.IdWorker;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;

/**
 * Created by houwen on 09/08/2017.
 */
@Service
public class IdWorkerServiceImpl implements IdWokerService {


    @Resource
    protected StringRedisTemplate stringRedisTemplate;

    private static volatile  IdWorker       idWorker;

    private static final Long     MAX_ID        = 1024L;
    private static final String   ID_WORKER_KEY = "tuia_engine_order_idworker";


    @Override
    public Long getNextID() {
        if (idWorker == null) {
            synchronized (IdWorkerServiceImpl.class) {
                if (idWorker == null) {
                    Long workerId = stringRedisTemplate.opsForValue().increment(ID_WORKER_KEY, 1L);
                    if (workerId.equals(MAX_ID)) {
                        workerId = stringRedisTemplate.opsForValue().increment(ID_WORKER_KEY, 0 - MAX_ID);
                    }
                    idWorker = new IdWorker(workerId);
                }
            }
        }
        return idWorker.nextId();
    }

}
