package cn.com.duiba.tuia.service.impl;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.AdvertTargetAppCacheService;
import cn.com.duiba.tuia.service.LimitingMaximunService;
import cn.com.tuia.advert.model.AdvOrientationDto;
import cn.com.tuia.advert.service.InteractiveMemoryService;

import com.google.common.collect.Lists;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;

/**
 *
 * @author peanut.huang
 * @date 2019/1/28
 * @since JDK 1.8
 */
@RestController
public class InteractiveMemoryServiceImpl implements InteractiveMemoryService {

    @Resource
    private EurekaClient eurekaClient;
    @Resource
    private AdvertMapCacheManager advertMapCacheManager;
    @Autowired
    private AdvertTargetAppCacheService advertTargetAppCacheService;
    @Resource
    private LimitingMaximunService limitingMaximunService;

    /**
     * 引擎服务名
     */
    private static final String SERVER_NAME = "tuia-engine";


    @Override
    public List<String> findServerList() {

        // tuia-engine应用
        Optional<Application> applicationOpt = eurekaClient.getApplications()
                                                            .getRegisteredApplications()
                                                            .stream()
                                                            .filter(e -> e.getName().equalsIgnoreCase(SERVER_NAME))
                                                            .findFirst();

        List<String> serverList = Lists.newArrayListWithExpectedSize(20);
        if(applicationOpt.isPresent()) {

            // 获取机器调用地址
            Application application = applicationOpt.get();
            List<InstanceInfo> instanceInfoList = application.getInstances();
            serverList = instanceInfoList.stream().map(InstanceInfo::getHomePageUrl).collect(Collectors.toList());
        }
        return serverList;
    }
    @Override
    public AdvOrientationDto findAdvOrientation(Long advertId, Long orientationId){
        return null;
    }


    @Override
    public Boolean refreshAdvOrientation(Long advertId, Long orientationId) {
        advertMapCacheManager.updateValidPkgFilterCache(advertId, orientationId);

        // 定向
        advertTargetAppCacheService.invalidAdvertTargetAppCache(advertId, orientationId);

        // 限流
        limitingMaximunService.updateLimitingMaximunCache(advertId, orientationId, null);

        return Boolean.TRUE;
    }
}
