package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.constants.CommonConstants;
import cn.com.duiba.tuia.constants.ErrorCode;
import cn.com.duiba.tuia.constants.TrusteeshipConstants;
import cn.com.duiba.tuia.core.api.enums.advert.AdvertPkgPeriodTypeEnum;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertPlanPeriodDO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.log.StatClickJsonLog;
import cn.com.duiba.tuia.log.StatExposureJsonLog;
import cn.com.duiba.tuia.log.StatRequestJsonLog;
import cn.com.duiba.tuia.message.rocketmq.HotPracFeeRocketMqProducer;
import cn.com.duiba.tuia.message.rocketmq.PracFeeRocketMqProducer;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.*;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.tuia.advert.constants.CommonConstant;
import cn.com.tuia.advert.enums.CVRTypeEnum;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.SpmlogReq;
import cn.com.tuia.advert.service.ISpmService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

/**
 * @author fanjia
 * @date 2021年05月12日 上午10:55
 */

@Service
@Slf4j
public class LianTongIntegralConsumeServiceImpl implements LianTongIntegralConsumeService {

    @Resource
    private CommonService commonService;
    @Resource
    private AdvertMapCacheManager advertMapCacheManager;
    @Resource
    private MediaCacheService mediaCacheService;
    @Resource
    private AdvertExposeService advertExposeService;
    @Resource
    private AdvertMaterialRecommendService advertMaterialRecommendService;

    @Resource
    private ApolloPanGuService apolloPanGuService;
    @Resource
    private ISpmService iSpmService;

    @Autowired
    private HotPracFeeRocketMqProducer hotPracFeeRocketMqProducer;


    @Autowired
    private PracFeeRocketMqProducer pracFeeRocketMqProducer;

    @Autowired
    private AdvertPeriodService advertPeriodService;
    @Autowired
    private ServiceManager serviceManager;

    @Autowired
    private IdWokerService idWokerService;

    @Override
    public ObtainAdvertRsp lianTongIntegralConsumeObtainAdvert(ObtainAdvertReq req) {
        DBTimeProfile.enter("LianTongIntegralConsumeService.lianTongIntegralConsumeObtainAdvert");

        ObtainAdvertRsp rsp = new ObtainAdvertRsp();
        rsp.setSlotId(req.getSlotId());
        rsp.setResult(false);
        try {
            //1.参数校验
            checkReq(req);
            //2.打请求日志
            FilterResult filterResult = printReqLog(req);
            //查询有效的广告列表
            List<AdvOrientationItem> originalList = advertMapCacheManager.getValidPkgFilterCache();
            if (CollectionUtils.isEmpty(originalList)) {
                log.warn("advOrientationItemList is empty");
                CatUtil.log(CatGroupEnum.CAT_106005.getCode());
                advertMapCacheManager.initAllValidAdvertFilterCache();
                return rsp;
            }

            // 复制配置荐
            List<AdvOrientationItem> orientationItemList = copyOrientationItem(req.getActivityMaterialType(), originalList);

            //3.盘古获取配置的联通广告id

            List<Long> lianTongAdvertIdList = getLiantongAdvertIdList("tuia-engine.liantong.advertIds");
            if (CollectionUtils.isEmpty(lianTongAdvertIdList)) {
                log.error("盘古获取联通广告id配置有误");
                return rsp;
            }
            //4.广告列表与盘古取出来的联通广告id取交，并随便取出一个配置进行发券
            AdvOrientationItem orientationItem = retainAndPickOrientation(lianTongAdvertIdList, orientationItemList);
            if (orientationItem == null) {
                log.error("lianTongIntegralConsumeObtainAdvert retainAndPickOrientation is null, orderId={}, whiteList={}", req.getOrderId(), lianTongAdvertIdList);
                return rsp;
            }

            AdvertFilter advertFilter = new AdvertFilter();
            advertFilter.setAppId(req.getAppId());
            advertFilter.setSlotId(req.getSlotId());
            advertFilter.setOrderId(req.getOrderId());
            advertFilter.setActivityId(req.getActivityId());


            // 4、出券

            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(orientationItem.getAdvertId());
            if (null == advertVO || null == advertVO.getAdvertPlan()) {
                log.error("lianTongIntegralConsumeObtainAdvert advert is null, advertId={}", orientationItem.getAdvertId());
                return rsp;
            }
            finishObtain(req, rsp, filterResult, orientationItem, advertFilter, advertVO);

            SpmlogReq spmlogReq = obtainAdvertReqChangeSpmlogReq(req, orientationItem, advertVO, rsp.getMaterialId());

            //5.打曝光日志:
            StatExposureJsonLog.log(spmlogReq);
            // 6.打点击日志:
            StatClickJsonLog.log(spmlogReq);
            // 7.发消息去扣费
            sendMsg(spmlogReq, advertVO);

        } catch (Throwable e) {
            log.error("lianTongIntegralConsumeObtainAdvert error", e);
        } finally {
            DBTimeProfile.release();
        }

        return rsp;
    }

    private List<Long> getLiantongAdvertIdList(String panGuConfigKey) {
        String advertIdsStr = apolloPanGuService.getIdMapStrByKeyStr(panGuConfigKey);
        if (StringUtils.isEmpty(advertIdsStr)) {
            log.error("盘古获取联通广告id获取为null  apolloKey {} ", panGuConfigKey);
        }
        return StringTool.getLongListByStr(advertIdsStr);
    }


    private void sendMsg(SpmlogReq req, AdvertVO advertVO) throws TuiaException {

        boolean isEnoughBudget = commonService.isEnoughBudget(advertVO, req.getFee());

        req.setEffectiveMainType(advertVO.getEffectMainType());
        String date = new DateTime().toString("yyyy-MM-dd");
        AdvertPlan advertPlan = advertVO.getAdvertPlan();
        //查询广告订单信息
        AdvertOrderDO advertOrderDO = serviceManager.getAdvertOrderDO(req.getConsumerId(), req.getOrderId(), req.getAdxMediaType());
        if (null == advertOrderDO) {
            log.info("clickLog advertOrderDO is null, req={}", JSON.toJSONString(req));
            return;
        }
        checkClickValid(isEnoughBudget, advertVO.getCurrentMainStatus(), req, date, advertPlan.getAccountId(),advertOrderDO.getId());

    }

    private void checkClickValid(boolean isEnoughBudget, Integer currentMainStatus, SpmlogReq req, String date, Long accountId, Long advertOrderId) {
        try {
            //扣费帐号余额判断
            if (!isEnoughBudget) {
                log.error("sendMsg checkClickValid isEnoughBudget is false");
                return;
            }
            req.setType(SpmType.SPM_LOG_CHARGE);
            AsynReq asynReq = new AsynReq();
            asynReq.setReqType(AsynReqType.CONSUME);
            asynReq.setAdvertId(req.getAdvertId());
            asynReq.setAppId(req.getAppId());

            asynReq.setAdvertOrderId(advertOrderId);
            asynReq.setReqTime(date);
            asynReq.setAdvertPackageId(req.getOrientationId());
            asynReq.setCurrentMainStatus(currentMainStatus);

            asynReq.setFee(req.getFee());
            asynReq.setHitUserInterest(StringUtils.EMPTY);

            //热点广告主 的 计费消息走另外一个消息队列
            Map<String, String> idMapByKeyStr = apolloPanGuService.getIdMapByKeyStr("tuia-engine.hot-account");
            if (null != idMapByKeyStr && idMapByKeyStr.containsKey(String.valueOf(accountId))) {
                hotPracFeeRocketMqProducer.sendMsg(req, asynReq);
            } else {
                pracFeeRocketMqProducer.sendMsg(req, asynReq);
            }

        } catch (Exception e) {
            log.error("send consume Fee ons happen error, because of=[{}]", e);
        }
    }

    private Period buildPeriod(OrderJsonVO vo, SpmlogReq req) {
        // 投放时段id为空
        if (vo == null || vo.getPeid() == null) {
            return null;
        }
        AdvertPlanPeriodDO palnPeriod = advertPeriodService.getPeriodCacheById(vo.getPeid());
        if (palnPeriod == null) {
            return null;
        }
        Period period = new Period();
        period.setPeriodId(vo.getPeid());
        period.setPeriodValue(palnPeriod.getPeriodValue());
        period.setPeriodType(palnPeriod.getPeriodType());
        if (AdvertPkgPeriodTypeEnum.PERIOD_TYPE_COUNT_BUDGET.getCode().equals(palnPeriod.getPeriodType())
                || AdvertPkgPeriodTypeEnum.PERIOD_TYPE_HOUR_BUDGET.getCode().equals(palnPeriod.getPeriodType())) {
            period.setExpendBudget(req.getFee());
            period.setCurPeriodTime(advertPeriodService.getCurPeriodTime(period.getPeriodType()));
        }
        return period;
    }

    private SpmlogReq obtainAdvertReqChangeSpmlogReq(ObtainAdvertReq req, AdvOrientationItem orientationItem, AdvertVO advertVO, Long materialId) {
        SpmlogReq spmlogReq = new SpmlogReq();
        spmlogReq.setLogExtExpMap(req.getLogExtExpMap());

        spmlogReq.setDeliveryType(req.getDeliveryType());

        spmlogReq.setLogExtMap(req.getLogExtMap());
        spmlogReq.setActivityUseType(req.getActivityUseType());
        spmlogReq.setVirtualActivityId(req.getVirtualActivityId());


        spmlogReq.setTime(req.getTime());
        spmlogReq.setType(req.getType());
        spmlogReq.setDeviceId(req.getDeviceId());
        spmlogReq.setFingerPrint(req.getFingerPrint());
        spmlogReq.setCoordinate(req.getCoordinate());
        spmlogReq.setBrowserName(req.getBrowserName());
        spmlogReq.setBrowserVersion(req.getBrowserVersion());
        spmlogReq.setBrowserAlias(req.getBrowserAlias());
        spmlogReq.setUrl(req.getUrl());
        spmlogReq.setUrlPattern(req.getUrlPattern());
        spmlogReq.setPreUrl(req.getPreUrl());
        spmlogReq.setPreurlPattern(req.getPreurlPattern());
        spmlogReq.setLoginType(req.getLoginType());
        spmlogReq.setButtonType(req.getButtonType());
        spmlogReq.setInfoType(req.getInfoType());
        spmlogReq.setInfo(req.getInfo());
        spmlogReq.setOs(req.getOs());
        spmlogReq.setUserAgent(req.getUserAgent());
        spmlogReq.setConsumerId(req.getConsumerId());

        spmlogReq.setIp(req.getIp());
        spmlogReq.setUa(req.getUa());

        spmlogReq.setTimestamp(req.getTimestamp());

        spmlogReq.setDuibaActivityType(req.getDuibaActivityType() + "");
        spmlogReq.setDuibaSlotId(req.getDuibaSlotId());
        spmlogReq.setAdxMediaType(req.getAdxMediaType() + "");

        //重要的几个参数

        spmlogReq.setAppId(req.getAppId());
        spmlogReq.setSlotId(req.getSlotId());
        spmlogReq.setActivityId(req.getActivityId());
        spmlogReq.setAdvertId(orientationItem.getAdvertId());
        spmlogReq.setOrientationId(orientationItem.getOrientationId());
        spmlogReq.setOrderId(req.getOrderId());
        //这个金额值  打印是否就是打印传递过来的联通金额值
        spmlogReq.setFee(req.getLianTongIntegralChangeMoney());

        spmlogReq.setLocationId(1);

        spmlogReq.setDiscountRate(null);


        spmlogReq.setPriceSection("");


        spmlogReq.setFlowSource(1);
        spmlogReq.setClickPosition(1);
        spmlogReq.setEffectiveMainType(advertVO.getEffectMainType());

        spmlogReq.setChargeType(ChargeTypeEnum.TYPE_CPC.getDesc());
        spmlogReq.setActivityOrderId(req.getOrderId());
        spmlogReq.setMaterialId(materialId);

        //跟帅帅对一下
        spmlogReq.setChannel(null);
        spmlogReq.setExps(null);
        spmlogReq.setStyleType(null);
        spmlogReq.setVirtualSlotId(null);
        return spmlogReq;
    }

    private void finishObtain(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, AdvOrientationItem orientationItem, AdvertFilter advertFilter, AdvertVO advertVO) throws TuiaException {
        Long advertId = orientationItem.getAdvertId();
        // 配置对象转化为PriceVO
        AdvertPriceVO advertPriceVO = orientation2PriceVO(orientationItem);

        Long fee = advertPriceVO.getFee();

        // 出券
        advertExposeService.finishBiz(req, rsp, advertId, advertVO, filterResult, advertPriceVO, fee, advertFilter);
    }

    private AdvertPriceVO orientation2PriceVO(AdvOrientationItem advOrientationItem) {
        Long advertId = advOrientationItem.getAdvertId();

        AdvertPriceVO priceVO = new AdvertPriceVO(advOrientationItem.getPeriodList(), advOrientationItem.getCpcPrice(), advOrientationItem.getChargeType());

        priceVO.setAdvertId(advertId);
        priceVO.setAdvertOrientationPackageId(advOrientationItem.getOrientationId());
        priceVO.setOriginalOrientationId(advOrientationItem.getInitialOrientationId());

        priceVO.setSupportStatus(advOrientationItem.getSupportStatus());
        priceVO.setNewTradeTagNum(advOrientationItem.getNewTradeTagNum());
        priceVO.setNewTradeTagId(advOrientationItem.getNewTradeTagId());

        //
        priceVO.setTrusteeship(advOrientationItem.getTargetAppLimit() == TrusteeshipConstants.AUTO_MODE ? CommonConstant.YES : CommonConstant.NO);
        priceVO.setTargetAppLimit(Optional.ofNullable(advOrientationItem.getTargetAppLimit()).orElse(1));
        priceVO.setStrongTarget(advOrientationItem.getStrongTarget());

        priceVO.setPackageType(advOrientationItem.getPackageType());
        priceVO.setActivityType(advOrientationItem.getActivityType());
        priceVO.setBudgetPerDay(advOrientationItem.getBudgetPerDay());
        //如果开启了自动托管则设置自动托管转换出价，用于打日志和传给哪吒
        priceVO.setConvertCost(advOrientationItem.getCpaPrice());
        priceVO.setAppTargetPackage(advOrientationItem.getAppTargetPackage());
        priceVO.setSlotTargetPackage(advOrientationItem.getSlotTargetPackage());
        priceVO.setTargetRecommendType(advOrientationItem.getTargetRecommendType());

        //设置签收因子,如果是ocpc并且改配置选择了 调整因子为签收
        priceVO.setSubtype(advOrientationItem.getSubtype());
        priceVO.setDepthSubtype(advOrientationItem.getDepthSubtype());
        priceVO.setDepthTargetPrice(advOrientationItem.getDepthTargetPrice());
        priceVO.setPutTargetType(AdvOrientationItem.configPutTargetType(advOrientationItem.getPutTargetType(), advOrientationItem.getStrongTarget(), advOrientationItem.getTargetAppLimit()));

        // 分媒体出价（重点媒体转化出价，潜力广告分媒体出价，普通的分媒体出价）
        // disAppFeeChange(priceVO, advOrientationItem, req.getAppId());

        priceVO.setResourceTag(advOrientationItem.getResourceTag());

        // 消耗模式
        priceVO.setBudgetSmooth(advOrientationItem.getBudgetSmooth());

        //多连接测试链接设置
        priceVO.setPromoteTestUrl(advOrientationItem.getPromoteTestUrl());

        //设置 是否在 托管底价白名单 中
        priceVO.setIsObctTag(advOrientationItem.getIsObctTag());

        priceVO.setMaterialsBind(advOrientationItem.getLeftMaterial());

        return priceVO;
    }

    private AdvOrientationItem retainAndPickOrientation(List<Long> lianTongAdvertIdList, List<AdvOrientationItem> validAdvertIdList) {
        List<AdvOrientationItem> restPkgList = validAdvertIdList.stream().filter(
                e -> lianTongAdvertIdList.contains(e.getAdvertId())
        ).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(restPkgList)) {
            return null;
        }

        int index = ThreadLocalRandom.current().nextInt(1, restPkgList.size() + 1);
        return restPkgList.get(index - 1);
    }

    private List<AdvOrientationItem> copyOrientationItem(Integer activityMaterialType, List<AdvOrientationItem> originalList) {

        List<AdvOrientationItem> result = new ArrayList<>(originalList.size());

        originalList.stream().filter(
                e -> {
                    //返回cpc类型的
                    int chargeType = Optional.ofNullable(e.getChargeType()).orElse(0);
                    return ChargeTypeEnum.TYPE_CPC.getCode() == chargeType;
                }
        ).forEach(item -> {
            AdvOrientationItem advOrientationItem = BeanUtils.copy(item, AdvOrientationItem.class);
            Set<Long> materialIds = advertMaterialRecommendService.getMaterialSetByAdvertId(item.getAdvertId());
            advOrientationItem.setLeftMaterial(materialIds);
            result.add(advOrientationItem);
        });
        return result;
    }


    private FilterResult printReqLog(ObtainAdvertReq req) {

        FilterResult filterResult = new FilterResult(req, null);
        // 1.获取ip对应的城市id
        AdvQueryParam advQueryParam = commonService.ipGeoAnalysis(req.getIp(), req.getIpAreaDto(),
                req.getLogExtMap(), req.getDeviceId(), false, null, filterResult);
        String cityId = advQueryParam.getRegionId();
        filterResult.setCityId(cityId);
        //2.设置城市
        if (req.getLogExtExpMap() != null) {
            req.getLogExtExpMap().put("cityId", cityId);
            req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.MAIN_TYPE, AdvertReqLogExtKeyConstant.INTERACT);
        } else {
            Map<String, String> logExtMap = Maps.newHashMap();
            logExtMap.put("cityId", cityId);
            logExtMap.put(AdvertReqLogExtKeyConstant.MAIN_TYPE, String.valueOf(AdvertReqLogExtKeyConstant.INTERACT));
            req.setLogExtMap(logExtMap);
        }

        //3.打印请求日志
        req.setType(SpmType.SPM_LOG_REQUEST);
        StatRequestJsonLog.log(req);

        return filterResult;

    }

    private void checkReq(ObtainAdvertReq req) throws TuiaException {


        // 2.用户id,媒体id,活动id,活动订单id为空验证
        if (req.getConsumerId() == null || req.getAppId() == null || req.getSlotId() == null
                || req.getActivityId() == null || StringUtils.isEmpty(req.getOrderId())) {
            log.warn("obtainAdvert error, req = [{}], please check the", req);
            throw new TuiaException(ErrorCode.E0100002);
        }
        // 3.请求ip为空验证
        if (StringUtils.isEmpty(req.getIp())) {
            log.warn("obtainAdvert error, req = [{}], please check the", req);
            throw new TuiaException(ErrorCode.E0100002);
        }

        // 4.UA校验和监控
        if (StringUtils.isBlank(req.getUa()) || CommonConstants.UNKNOWN.equals(req.getUa())) {
            CatUtil.log(CatGroupEnum.CAT_107004.getCode());
            req.setUa(CommonConstants.UNKNOW);
        }
    }


}

