package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.dao.promotetest.AdvertPromoteTestDAO;
import cn.com.duiba.tuia.domain.dataobject.AdvertPromoteTestDO;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.MaterialBindPromoteUrlService;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service
@Slf4j
public class MaterialBindPromoteUrlServiceImpl implements MaterialBindPromoteUrlService {

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    @Autowired
    private AdvertPromoteTestDAO advertPromoteTestDAO;

    private static final String PANGU_KEY = "tuia-engine.promoteurl.config";

    private static final Integer CHECK_PASS = 1;

    private LoadingCache<String, Map<String, String>> cache = Caffeine.newBuilder()
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .build(this::loadConfig);

    private Map<String, String> loadConfig(String key) {

        try {
            String configStr = apolloPanGuService.getIdMapStrByKeyStr(key);
            return buildCacheMap(configStr);
        } catch (Exception e) {
            log.warn("获取盘古配置失败 configKey={}, error", key, e);
        }

        return Collections.emptyMap();
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    private static class ConfigData {
        String advertId;
        String materialId;
        String promoteUrl;
    }

    private Map<String, String> buildCacheMap(String configStr) {
        if (StringUtils.isBlank(configStr)) {
            return Collections.emptyMap();
        }

        List<ConfigData> configDataList = null;
        try {
            configDataList = JSONObject.parseArray(configStr, ConfigData.class);
        } catch (Exception e) {
            log.warn("数据解析异常，data = " + configStr, e);
            return Collections.emptyMap();
        }

        Map<String, String> rtnMap = new HashMap<>();

        Set<Long> advertIdSet = new HashSet<>();
        for (ConfigData configData : configDataList) {
            try {
                advertIdSet.add(Long.valueOf(configData.getAdvertId()));
            } catch (NumberFormatException e) {
                log.warn("盘古配置异常", e);
            }
        }

        List<AdvertPromoteTestDO> advertPromoteTestDOS = advertPromoteTestDAO.selectPromoteUrlList(new ArrayList<>(advertIdSet));
        if (CollectionUtils.isEmpty(advertPromoteTestDOS)) {
            return rtnMap;
        }

        Set<String> collect = advertPromoteTestDOS.stream().
                filter(advertPromoteTestDO -> CHECK_PASS.equals(advertPromoteTestDO.getStatus())).
                map(advertPromoteTestDO -> advertPromoteTestDO.getAdvertId() + "-" + advertPromoteTestDO.getPromoteUrl()).
                collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(collect)) {
            return rtnMap;
        }

        for (ConfigData configData : configDataList) {
            if (collect.contains(configData.getAdvertId()+"-"+configData.getPromoteUrl())) {
                rtnMap.put(configData.getAdvertId() + "-" + configData.getMaterialId(), configData.getPromoteUrl());
            }
        }

        return rtnMap;
    }

    @Override
    public String getBindPromoteUrl(Long advertId, Long materialId) {
        Map<String, String> cacheMap = this.cache.get(PANGU_KEY);
        String key = advertId + "-" + materialId;
        return cacheMap.get(key);
    }
}

@RestController
class Test{

    @Autowired
    MaterialBindPromoteUrlService materialBindPromoteUrlService;

    @RequestMapping(path={"/xxx/test"},method={RequestMethod.GET})
    public String test() {
        return materialBindPromoteUrlService.getBindPromoteUrl(1L,1L);
    }


}