package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.service.MeituanCheckUrlService;
import cn.com.duiba.tuia.ssp.center.api.remote.media.RemoteMeituanService;
import cn.com.duiba.tuia.ssp.center.api.remote.media.dto.CanServeAdvertDto;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
public class MeituanCheckUrlServiceImpl implements MeituanCheckUrlService {

    @Autowired
    private RemoteMeituanService remoteMeituanService;



    private LoadingCache<Long, Set<String>> cache = Caffeine.newBuilder()
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .build(this::loadConfig);

    private Set<String> loadConfig(Long advertId) {

        try {
            List<CanServeAdvertDto> canServeAdvertDtos = remoteMeituanService.canServeAdvertByAdvertId(advertId);

            if(CollectionUtils.isEmpty(canServeAdvertDtos)){
                return Collections.emptySet();
            }

            Set<String> set = new HashSet<>();
            for (CanServeAdvertDto canServeAdvertDto : canServeAdvertDtos) {
                Long materialId = canServeAdvertDto.getMaterialId();
                String promoteUrl = canServeAdvertDto.getLandingPage();
                set.add(buildUniqueKey(materialId,promoteUrl));
            }

            return set;
        } catch (Exception e) {
            log.warn("查询送审广告失败 advertId={}, error", advertId, e);
        }

        return Collections.emptySet();
    }

    private String buildUniqueKey(Long materialId, String promoteUrl) {
        return materialId + "#" + promoteUrl;
    }

    @Override
    public boolean checkOneUrl(Long advertId, Long materialId, String promoteTestUrl) {
        Set<String> strings = cache.get(advertId);
        if(CollectionUtils.isEmpty(strings)){
            return false;
        }
        return strings.contains(buildUniqueKey(materialId,promoteTestUrl));
    }

    @Override
    public boolean checkAllUrl(Long advertId, Long materialId, List<String> promoteUrls) {

        Set<String> strings = cache.get(advertId);
        if(CollectionUtils.isEmpty(strings)){
            return false;
        }

        for (String promoteUrl : promoteUrls) {
            if(!strings.contains(buildUniqueKey(materialId,promoteUrl))){
                return false;
            }
        }

        return true;
    }
}
