package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.MinPriceService;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * 底价判断服务实现
 *
 * @author zhangbaiqiang
 * @date 2021/6/16
 */
@Service
public class MinPriceServiceImpl implements MinPriceService {

    private static final Logger logger = LoggerFactory.getLogger(MinPriceServiceImpl.class);

    public static final String PANGU_KEY = "ocpc.min.price.app-slot.whitelist";

    @Autowired
    private ApolloPanGuService apolloPanGuService;

    @Resource
    private ExecutorService executorService;

    private CacheLoader<String, Map<String, String>> DATA_LOADER = new CacheLoader<String, Map<String, String>>() {
        @Override
        public Map<String, String> load(@NotNull String keyStr) {
            // 【RPC接口】盘古处理，根据 keyStr 获取value信息==>转化成Map
            Map<String,String> rtnMap = new ConcurrentHashMap<>();

            Map<String, String> map = apolloPanGuService.getIdMapByKeyStr(PANGU_KEY);
            if(MapUtils.isEmpty(map)){
                return rtnMap;
            }

            map.forEach((key,value)->{
                if(StringUtils.isBlank(key) || !StringUtils.isNumeric(value)){
                    return;
                }

                String[] split = key.split(",");
                for (String s : split) {
                    rtnMap.put(s,value);
                }
            });

            return rtnMap;
        }

        @Override
        public ListenableFuture<Map<String, String>> reload(String keyStr, Map<String, String> oldValue) {
            ListenableFutureTask<Map<String, String>> task = ListenableFutureTask.create(() -> load(keyStr));
            executorService.submit(task);
            return task;
        }
    };

    private LoadingCache<String, Map<String, String>> APP_SLOT_CACHE = CacheBuilder.newBuilder()
            .initialCapacity(1024).concurrencyLevel(20).refreshAfterWrite(60,
                    TimeUnit.SECONDS).expireAfterWrite(20,
                    TimeUnit.HOURS).build(DATA_LOADER);

    @Override
    public Long getMinPriceFromSlotWhitelist(Long appId, Long slotId) {
        if (null == appId || null == slotId) {
            return null;
        }

        try {
            Map<String, String> data = APP_SLOT_CACHE.get("data");
            //先取广告位的底价
            String key = appId + "-" + slotId;
            String slotValue = data.get(key);
            if(StringUtils.isNotBlank(slotValue)){
                return Long.valueOf(slotValue);
            }else{
                //再取媒体的底价
                String appValue = data.get(String.valueOf(appId));
                if (StringUtils.isNotBlank(appValue)) {
                    return Long.valueOf(appValue);
                }
            }
        } catch (Exception e) {
            logger.error("getMinPriceFromSlotWhitelist error, appId={},slotId={}",appId,slotId, e);
        }
        return null;
    }
}
