package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.constants.AdvertSystemConfigureConstants;
import cn.com.duiba.tuia.domain.model.AdvertPlan;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.service.AdvertSystemConfigService.AdvertSystemConfigEnum;
import cn.com.duiba.tuia.service.ConsumerService;
import cn.com.duiba.tuia.service.MultipleExposureService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.tuia.advert.constants.CommonConstant;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月07日 16:58
 * @descript:
 * @version: 1.0
 */
@Service
public class MultipleExposureServiceImpl implements MultipleExposureService {

    @Resource
    private ConsumerService consumerService;

    @Resource
    private AdvertMapCacheManager advertMapCacheManager;

    @Override
    public List<Long> filter(Long consumerId, List<Long> receiveAdvertIds, Map<Long, Integer> limitAdvertTodayMap) {

        try {
            DBTimeProfile.enter("MultipleExposureServiceImpl.filter");
            Map<Long, Integer> limitAndClickMaps = consumerService.getAllClickStatus(consumerId);
            //可以重复曝光的广告
            List<Long> multipleExposureIds = Lists.newArrayListWithCapacity(receiveAdvertIds.size());

            for (Long advertId : receiveAdvertIds) {

                AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
                if (advertVO == null) {
                    continue;
                }
                AdvertPlan advertPlan = advertVO.getAdvertPlan();
                //如果没有开启重复曝光，不需要过滤
                if (advertPlan.getRepeatExposure() == null || advertPlan.getRepeatExposure().equals(CommonConstant.NO))
                    continue;

                //如果达到上限重复曝光设置失效
                Integer limitCount = limitAdvertTodayMap.get(advertId);
                if (limitCount != null && ++limitCount > AdvertSystemConfigEnum.multipleExposureLimitCount.getIntValue())
                    continue;

                //如果已经被点击重复曝光设置失效
                Integer clickStatus = limitAndClickMaps.get(advertId);
                if ((clickStatus != null && clickStatus.equals(CommonConstant.YES)))
                    continue;

                multipleExposureIds.add(advertId);
            }
            return multipleExposureIds;
        } finally {
            DBTimeProfile.release();
        }

    }
}
