package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.domain.model.PhoneCacheEntity;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.service.PhoneLibraryService;
import cn.com.duiba.tuia.utils.WeightRandomUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author: panaihua
 * @date: 2017年02月27日 10:09
 * @descript:
 * @version: 1.0
 */
@Service("PhoneLibraryServiceProxyImpl")
public class PhoneLibraryServiceProxyImpl implements PhoneLibraryService {

    private static Logger log = LoggerFactory.getLogger(PhoneLibraryServiceProxyImpl.class);

    @Resource
    private ApolloPanGuService apolloPanGuService;

    @Resource(name="PhoneLibraryServiceAImpl")
    private PhoneLibraryService phoneLibraryServiceAImpl;

    @Resource(name="PhoneLibraryServiceBImpl")
    private PhoneLibraryService phoneLibraryServiceBImpl;

    //盘古分流权重配置key(新设备库的占比)
    private static final String AB_TEST_PHONE_KEY_B = "tuia-engine.abTest.phone.proportion.b";

    /**
     * 设备库标识
     * tb_phone设备库
     */
    private static String EQUIPMENT_TYPE_A = "1";

    /**
     * 设备库标识
     * tb_phone_b设备库
     */
    private static String EQUIPMENT_TYPE_B = "2";

    public Double getWeight() {
        try {
            String value = apolloPanGuService.getIdMapStrByKeyStr(AB_TEST_PHONE_KEY_B);
            if (StringUtils.isBlank(value)) {
                log.error("getWeight from pangu fail, value is null");
                return Double.valueOf(0);
            }
            Double weight = Double.valueOf(value);
            if (weight > 1 || weight < 0) {
                log.error("getWeight from pangu exception, value={}", value);
                return Double.valueOf(0);
            }
            return weight;
        } catch (Exception e) {
            log.error("setWeight error", e);
            return Double.valueOf(0);
        }
    }

    @Override
    public PhoneCacheEntity getPhoneInfoCacheByType(String phoneType) throws TuiaException {
        if (WeightRandomUtil.weightToSuccess(getWeight())){
            PhoneCacheEntity entity =  phoneLibraryServiceBImpl.getPhoneInfoCacheByType(phoneType);
            if (Objects.nonNull(entity)) {
                entity.setEquipmentType(EQUIPMENT_TYPE_B);
            }
            return entity;
        }
        PhoneCacheEntity entity =  phoneLibraryServiceAImpl.getPhoneInfoCacheByType(phoneType);
        if (Objects.nonNull(entity)) {
            entity.setEquipmentType(EQUIPMENT_TYPE_A);
        }
        return entity;
    }

    @Override
    public Object flushPhoneInfoCache() {
        phoneLibraryServiceAImpl.flushPhoneInfoCache();
        return phoneLibraryServiceBImpl.flushPhoneInfoCache();
    }
}
