package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.DMPForm;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice.RemoteDMPService;
import cn.com.duiba.tuia.dao.rta.RTADAO;
import cn.com.duiba.tuia.domain.vo.RTAAdvertPlanVO;
import cn.com.duiba.tuia.service.BaseService;
import cn.com.duiba.tuia.service.RTAService;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.tuia.advert.model.RTAAdvertPlanDto;
import cn.com.tuia.advert.model.RTAObtainReq;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @program: tuia-engine
 * @description:
 * @author: Micheal.Wang
 * @blog: <a href="http://www.micheal.top">MichealWang</a>
 * @create: 2020-04-17 15:28
 **/

@Service
public class RTAServiceImpl extends BaseService implements RTAService {
    @Autowired
    private RTADAO rtadao;

    @Resource
    private ExecutorService executorService;
    @Resource
    private RemoteDMPService remoteDMPService;

    @Override
    public List<RTAAdvertPlanDto> query() {
        return rtadao.query();
    }
    /**
     * RTA广告缓存 有消息同步，不用设置过期时间来保证避免读取旧值
     */
    private final LoadingCache<Long, Map<Long,RTAAdvertPlanVO>> RTAAdvertPlanCache = CacheBuilder.newBuilder()
            .initialCapacity(1000).expireAfterWrite(30, TimeUnit.MINUTES)
            .build(new CacheLoader<Long, Map<Long,RTAAdvertPlanVO>>() {
                @Override
                public Map<Long,RTAAdvertPlanVO> load(Long key) throws Exception {
                    return loadByChannelId(key);
                }

                @Override
                public ListenableFuture<Map<Long,RTAAdvertPlanVO>> reload(Long key,Map<Long,RTAAdvertPlanVO> oldValue)
                        throws Exception {
                    ListenableFutureTask<Map<Long,RTAAdvertPlanVO>> task = ListenableFutureTask.create(() -> load(key));
                    executorService.submit(task);
                    return task;
                }

            });

    /**
     * 缓存加载 todo 可能要修改
     * @param appId
     * @return
     */
    private Map<Long,RTAAdvertPlanVO> loadByChannelId(Long appId) {
        List<RTAAdvertPlanDto> dtos = rtadao.queryByAppId(appId);
        return dtos.stream().map(dto->{
                    RTAAdvertPlanVO copy = BeanUtils.copy(dto, RTAAdvertPlanVO.class);
                    copy.setSheildInterestTags(StringTool.getStringListByStr(dto.getSheildInterestTags()));
                    copy.setTargetedInterestTags(StringTool.getStringListByStr(dto.getTargetedInterestTags()));
                    return copy;
                }).collect(HashMap::new,(m,v)->m.put(v.getAccountId(),v),HashMap::putAll);
    }

    @Override
    public Map<Long,RTAAdvertPlanVO> getByChannelId(Long appId) {
        Map<Long,RTAAdvertPlanVO>map;
        try {
            map = RTAAdvertPlanCache.get(appId);
        } catch (Exception e) {
            logger.warn("RTAServiceImpl.getByChannelId cache happend error!",e);
            map = Maps.newHashMap();
        }

        return map;
    }

    @Override
    public void refreshAdvertExpandCache(Long appId) {
        try {
            RTAAdvertPlanCache.refresh(appId);
        } catch (Exception e) {
           logger.error("RTAAdvertPlanCache refresh error !",e);
        }
    }

    @Override
    @HystrixCommand(
            fallbackMethod = "getRtaDMPTagsFallback",
            commandProperties = {@HystrixProperty(name = "execution.isolation.thread.timeoutInMilliseconds", value = "10")})
    public DeviceTagDto getRtaDMPTags(RTAObtainReq rtaObtainReq) {
        DMPForm dmpForm = new DMPForm();
        dmpForm.setDeviceId(rtaObtainReq.getDeviceId());
        // dmp 查询标签
        DeviceTagDto tag = null;
        try {
            tag = remoteDMPService.getDeviceExtTag(dmpForm);
        } catch (Exception e) {
            logger.info("RemoteDMPService.getDeviceExtTag happend error!",e);
        }
        return tag;
    }

    public DeviceTagDto getRtaDMPTagsFallback(RTAObtainReq rtaObtainReq) {
       return null;
    }
}
