package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.enums.RandomServiceEnum;
import cn.com.duiba.tuia.service.RandomService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 此处 若有别的切量服务要用 还缺一个注册切量服务的功能，暂时写死后面用到再加吧
 */

@RefreshScope
@Service
public class RandomServiceImpl implements RandomService {

    @Value("${tuia.engine.randomService.RepeatExposureRate:100}")
    private String repeatExposureRate;

    @Value("${tuia.engine.randomService.LowNeedsAdRate:100}")
    private String lowNeedsAdRate;


    /**
     * 用于解码 某个服务的 切量值
     *
     * @param randomTag
     * @param repeatExposureRandomService
     * @return
     */
    @Override
    public Boolean decodeRandomTag(Long randomTag, RandomServiceEnum repeatExposureRandomService) {
        long l = 1L & (randomTag >> repeatExposureRandomService.getBit());
        return l == 1;
    }

    /**
     * 用于生成所有切量服务的切量值
     *
     * @return
     */
    @Override
    public Long makeRandomServiceTag() {

        long randomTag = 0L;

        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        Boolean isLucky = threadLocalRandom.nextInt(100) < Integer.valueOf(repeatExposureRate);
        if (isLucky) {
            randomTag = randomTag | (1L << RandomServiceEnum.REPEAT_EXPOSURE_RANDOM_SERVICE.getBit());
        }

        isLucky = threadLocalRandom.nextInt(100) < Integer.valueOf(lowNeedsAdRate);
        if (isLucky) {
            randomTag = randomTag | (1L << RandomServiceEnum.LOW_NEEDS_AD_RANDOM_SERVICE.getBit());
        }

        return randomTag;
    }
}
