package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.constants.RepeatAdvertTestConstant;
import cn.com.duiba.tuia.domain.model.RepeatTestGroup;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.RepeatAdvertTestService;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * [重复发券测试需求]接口实现
 *
 * @author zhangbaiqiang
 * @date 2020/7/15
 */
@Service
public class RepeatAdvertTestServiceImpl implements RepeatAdvertTestService {

    private final Logger logger = LoggerFactory.getLogger(RepeatAdvertTestServiceImpl.class);

    @Autowired
    private ServiceManager serviceManager;

    @Override
    public RepeatTestGroup calculateRepeatTestGroup(Long consumerId) {
        if (null == consumerId) {
            return null;
        }

        try {
            List<RepeatTestGroup> groups = queryRepeatTestGroups();
            if (CollectionUtils.isEmpty(groups)) {
                return null;
            }

            int p = Math.abs(consumerId.hashCode()) % 100;

            for (RepeatTestGroup group : groups) {
                if (p < group.getRatio()) {
                    return group;
                }
                p -= group.getRatio();
            }
        } catch (Exception e) {
            logger.warn("calculateRepeatTestGroup error, consumerId={}", consumerId, e);
        }

        return null;
    }

    @Override
    public List<RepeatTestGroup> queryRepeatTestGroups() {
        try {
            String value = serviceManager.getStrValue(SystemConfigKeyConstant.ADVERT_REPEAT_INTERVAL_TEST);
            if (StringUtils.isNotBlank(value)) {
                List<RepeatTestGroup> groups = JSON.parseArray(value, RepeatTestGroup.class);
                if (CollectionUtils.isNotEmpty(groups)) {
                    groups.sort(Comparator.comparingInt(RepeatTestGroup::getOrder));
                }
                return groups;
            }
        } catch (TuiaException e) {
            logger.warn("queryRepeatTestGroups error", e);
        }

        return Collections.emptyList();
    }

    @Override
    public Boolean isRepeatIntervalLessThanTodayHours(RepeatTestGroup group) {
        if (null == group || null == group.getInterval() || Objects.equals(group.getGroup(), RepeatAdvertTestConstant.CONTROL_GROUP)) {
            return false;
        }

        Date now = new Date();
        return DateUtils.hoursAddOrSub(now, -group.getInterval()).after(DateUtils.getDayStartTime(now));
    }
}
