package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.domain.model.AdvOrientationItem;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilterType;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.tuia.advert.enums.AdvertFilterTypeEnum;
import cn.com.duiba.tuia.service.RandomService;
import cn.com.duiba.tuia.service.RepeatExposureFilterService;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.hutool.core.collection.ConcurrentHashSet;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class RepeatExposureFilterServiceImpl implements RepeatExposureFilterService {

    @Autowired
    private RandomService randomService;

    /**
     * 重复曝光过滤
     * @param listAdvOrientationItem
     * @param advQueryParam
     * @param filterTypeSets
     * @return
     */
    @Override
    public List<AdvOrientationItem> repeatExposureFilter(List<AdvOrientationItem> listAdvOrientationItem, AdvQueryParam advQueryParam, ConcurrentHashSet<AdvertFilterType> filterTypeSets) {
        if (!listAdvOrientationItem.isEmpty()) {
            List<AdvOrientationItem> leftList = new LinkedList<>();
            for (AdvOrientationItem advOrientationItem : listAdvOrientationItem) {
                //false 表示 不在过滤名单中 则 保留
                if (!filterCheck(advOrientationItem, AdvertFilterTypeEnum.REPEAT_EXPOSURE, advQueryParam, filterTypeSets)) {
                    leftList.add(advOrientationItem);
                }
            }
            return leftList;
        }
        return listAdvOrientationItem;
    }

    /**
     * 重复曝光过滤+释放
     * @param listAdvOrientationItem
     * @param advQueryParam
     * @param filterTypeSets
     * @param filterResult
     * @return
     */
    @SuppressWarnings("squid:S3776")
    @Override
    public List<AdvOrientationItem> filterRepeatExposureAd(List<AdvOrientationItem> listAdvOrientationItem, AdvQueryParam advQueryParam, ConcurrentHashSet<AdvertFilterType> filterTypeSets, FilterResult filterResult) {
        //TODO 重复曝光规则释放优化
        //过滤结果不为空，则进入 重复曝光过滤 及 释放优化规则
        if(!listAdvOrientationItem.isEmpty()) {
            List<AdvOrientationItem> leftList = new LinkedList<>();
            List<AdvOrientationItem> filteList = new LinkedList<>();
            for (AdvOrientationItem advOrientationItem : listAdvOrientationItem) {
                //true 表示 在过滤名单中 则 过滤
                if (filterCheck(advOrientationItem, AdvertFilterTypeEnum.REPEAT_EXPOSURE, advQueryParam, filterTypeSets)) {
                    filteList.add(advOrientationItem);
                } else {
                    leftList.add(advOrientationItem);
                }
            }

            //TODO 过滤后无可发的付费券 且 过滤的券中有付费券，则进入重复曝光过滤释放优化规则
            if (!judgeIfHaveNotAutoPaidPkg(leftList) && judgeIfHavePaidPkg(filteList)) {
                Set<Long> filterAdvertIds = new HashSet<>();
                Boolean randomServce = filterResult.getRepeatExposureLuckyConsumer();

                //进入切量捞取符合 过滤释放逻辑的配置
                //释放规则：1.有素材未被曝光过 且 2.重复曝光次数 < 3
                if (randomServce) {
                    //此处不会为空
                    Map<Long, Integer> limitAdvertTodayMap = advQueryParam.getLimitAdvertTodayMap();
                    for (AdvOrientationItem advOrientationItem : filteList) {
                        //TODO 从过滤的券中捞取可以释放的券(付费 且 符合释放规则)
                        //判断是否是付费券
                        if (isPaidPkg(advOrientationItem)) {
                            //将 重复曝光次数 < 3 的券都捞出来，后面会有 素材（重复曝光）过滤
                            Integer receiveTimes = limitAdvertTodayMap.get(advOrientationItem.getAdvertId());

                            if(null == receiveTimes){
                                receiveTimes = 0;
                            }

                            if (receiveTimes < 3) {
                                leftList.add(advOrientationItem);
                                filterAdvertIds.add(advOrientationItem.getAdvertId());
                                filterTypeSets.remove(new AdvertFilterType(advOrientationItem.getAdvertId(), advOrientationItem.getOrientationId(), AdvertFilterTypeEnum.REPEAT_EXPOSURE.getCode()));
                            }
                        }
                    }
                }
                filterResult.setRepeatExposureADList(filterAdvertIds);
            }
            return leftList;
        }
        return listAdvOrientationItem;
    }


    private Boolean checkNotInAdvertIds(Long advertId, Set<Long> notInAdvertIds) {
        if (CollectionUtils.isEmpty(notInAdvertIds)) {
            return false;
        }
        return notInAdvertIds.contains(advertId);
    }

    private boolean filterCheck(AdvOrientationItem item, AdvertFilterTypeEnum typeEnum, AdvQueryParam advQueryParam, ConcurrentHashSet<AdvertFilterType> filterTypeSets) {
        Boolean result = checkNotInAdvertIds(item.getAdvertId(), advQueryParam.getReceiveIds());
        if(result){
            filterTypeSets.add(new AdvertFilterType(item.getAdvertId(), item.getOrientationId(), typeEnum.getCode()));
        }
        return result;
    }

    private boolean isPaidPkg(AdvOrientationItem advOrientationItem){
        //cpc 取cpc的价格 cpa 取cpa的价格
        Integer chargeType = advOrientationItem.getChargeType();
        /**
         * 理论上不能为空
         */
        if(null == chargeType){
            //计费类型为null，认为是免费券
            return false;
        }

        if(ChargeTypeEnum.TYPE_CPC.getCode() == chargeType){
            return null != advOrientationItem.getCpcPrice() && advOrientationItem.getCpcPrice() > 0;
        }

        if(ChargeTypeEnum.TYPE_CPA.getCode() == chargeType){
            return null != advOrientationItem.getCpaPrice() && advOrientationItem.getCpaPrice() > 0;
        }

        //其余情况 返回为免费券
        return false;

    }

    private boolean judgeIfHaveNotAutoPaidPkg(List<AdvOrientationItem> leftList) {
        // 获取fee>0的券
        for (AdvOrientationItem advOrientationItem : leftList) {
            //非自动模式的付费券
            if(isPaidPkg(advOrientationItem)&&(!advOrientationItem.isAutoModeOrientPackage())){
                return true;
            }
        }
        //无付费券
        return false;
    }


    private boolean judgeIfHavePaidPkg(List<AdvOrientationItem> leftList) {
        // 获取fee>0的券
        for (AdvOrientationItem advOrientationItem : leftList) {
            //非自动模式的付费券
            if(isPaidPkg(advOrientationItem)){
                return true;
            }
        }
        //无付费券
        return false;
    }

}
