package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.core.api.enums.AppFlowStrategySwitchEnum;
import cn.com.duiba.tuia.domain.dataobject.SlotFLowStrategyDO;
import cn.com.duiba.tuia.domain.model.RspEngineAppFlowStrategyDto;
import cn.com.duiba.tuia.service.SlotFlowStrategyService;
import cn.com.duiba.tuia.tool.SwitchesUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Optional;

/**
 * Created by jzl on 18/4/15.
 */
@Service
public class SlotFlowStrategyServiceImpl extends MediaCacheService implements SlotFlowStrategyService {

    @Autowired
    private MediaCacheService mediaCacheService;



    @Override
    public RspEngineAppFlowStrategyDto findSlotFlowStrategyBySlotId(Long slotId) {
        try {
            Optional<SlotFLowStrategyDO> slotFlowStrategyDOOptional = mediaCacheService.getSlotFlowStrategyBySlotId(slotId);

            if (!slotFlowStrategyDOOptional.isPresent()) {
                return null;
            }
            RspEngineAppFlowStrategyDto rspEngineAppFlowStrategyDto = null;

            SlotFLowStrategyDO slotFlowStrategyDO = slotFlowStrategyDOOptional.get();
            rspEngineAppFlowStrategyDto = BeanUtils.copy(slotFlowStrategyDO, RspEngineAppFlowStrategyDto.class);
            //转换状态
            rspEngineAppFlowStrategyDto.setSwitchLuckybag(SwitchesUtil.switchChange(slotFlowStrategyDO.getSwitches(), AppFlowStrategySwitchEnum.STRATEGY_TYEP_LUCKYBAG.getCode()));
            rspEngineAppFlowStrategyDto.setSwitchStrategy(SwitchesUtil.switchChange(slotFlowStrategyDO.getSwitches(), AppFlowStrategySwitchEnum.STRATEGY_TYEP_STRATEGY.getCode()));
            rspEngineAppFlowStrategyDto.setSwitchProxy(SwitchesUtil.switchChange(slotFlowStrategyDO.getSwitches(), AppFlowStrategySwitchEnum.STRATEGY_TYEP_PROXY.getCode()));

            return rspEngineAppFlowStrategyDto;
        } catch (Exception e) {
            logger.error("findSlotFlowStrategyBySlotId error,", e);
        }
        return null;
    }

}