package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.dao.advert.AdvertDAO;
import cn.com.duiba.tuia.dao.media.MediaAccountWhiteDAO;
import cn.com.duiba.tuia.dao.media.MediaAdvertWhiteDAO;
import cn.com.duiba.tuia.dao.slot.SlotWhiteListDAO;
import cn.com.duiba.tuia.domain.dataobject.MediaAccountWhiteDO;
import cn.com.duiba.tuia.domain.dataobject.MediaAdvertWhiteDO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.BaseService;
import cn.com.duiba.tuia.service.SlotWhiteListService;
import cn.com.duiba.tuia.ssp.center.api.dto.slot.SlotListStatusDto;
import cn.com.duiba.tuia.ssp.center.api.remote.RemoteSlotBackendService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * Created by jzl on 18/4/16.
 */
@Service
public class SlotWhiteListServiceImpl extends BaseService implements SlotWhiteListService {

    @Autowired
    private SlotWhiteListDAO slotWhiteListDAO;

    @Autowired
    private MediaAdvertWhiteDAO mediaAdvertWhiteDAO;

    @Autowired
    private MediaAccountWhiteDAO mediaAccountWhiteDAO;

    @Autowired
    private RemoteSlotBackendService remoteSlotBackendService;

    @Autowired
    private ExecutorService executorService;

    @Override
    public List<Long> selectList(Long slotId) throws TuiaException {
        return slotWhiteListDAO.selectList(slotId);
    }

    @Override
    public List<Long> selectList(String strategyType, Long strategyId, Long slotId) throws TuiaException {
        return slotWhiteListDAO.selectList(strategyType, strategyId,slotId);
    }

//    @Override
//    public Boolean isSlotAdvertInWhiteList(String slotAdvertStr) throws TuiaException {
//
//        try {
//            if (StringUtils.isEmpty(slotAdvertStr)) {
//                return false;
//            }
//
//            String[] slotAdvertArr = slotAdvertStr.split("-");
//
//            if (slotAdvertArr.length != 2) {
//                return false;
//            }
//
//            Long slotId = Long.valueOf(slotAdvertArr[0]);
//            Long advertId = Long.valueOf(slotAdvertArr[1]);
//
//            Long advertValue = MEDIA_SLOT_ADVERT_CACHE.getUnchecked(SLOT_ADVERT_KEY).get(slotAdvertStr);
//
//            if (advertValue != null) {
//                return true;
//            }
//
//            //查询广告主维度白名单
//            Long accountValue = null;
//
//            AdvertVO advertVO = advertMapCacheManager.getAdvertCache(advertId);
//
//
//            if (advertVO != null && advertVO.getAdvertPlan() != null && advertVO.getAdvertPlan().getAccountId() != null) {
//               accountValue = MEDIA_SLOT_ACCOUNT_CACHE.getUnchecked(SLOT_ACCOUNT_KEY).get(slotId + "-" + advertVO.getAdvertPlan().getAccountId());
//            }
//            //如果当前广告和广告位在 广告主维度白名单,则代表在并名单中
//            return accountValue != null;
//        }catch (Exception e){
//            logger.warn("isSlotAdvertInWhiteList exception",e);
//            return false;
//        }
//    }



//    /**
//     * 广告位广告媒体白名单缓存
//     * @param slotIds
//     * @return
//     */

//    private final LoadingCache<String, Map<String,Long>> MEDIA_SLOT_ADVERT_CACHE = CacheBuilder.newBuilder().initialCapacity(1).maximumSize(10)
//            .refreshAfterWrite(5, TimeUnit.MINUTES).build(new CacheLoader<String, Map<String,Long>>() {
//                @Override
//                public Map<String,Long> load(String key) {
//                    try {
//                        List<MediaAdvertWhiteDO> mediaAdvertWhiteDOS = mediaAdvertWhiteDAO.selectMediaAdvertWhites();
//                        Map<String,Long> resultMap = new HashMap<>(mediaAdvertWhiteDOS.size());
//
//                        mediaAdvertWhiteDOS.stream().forEach(dto->{
//                            String keyStr = dto.getSlotId()+ "-" +dto.getAdvertId();
//                            resultMap.put(keyStr,1L);
//                        });
//                        return resultMap;
//                    }catch (Exception e){
//                        logger.error("MEDIA_SLOT_ADVERT_CACHE key:{} exception",key,e);
//                        return new HashMap<String,Long>();
//                    }
//                }
//
//                @Override
//                public ListenableFuture<Map<String,Long>> reload(final String key, Map<String,Long> map) {
//                    ListenableFutureTask<Map<String,Long>> task = ListenableFutureTask.create(()->load(key));
//                    executorService.submit(task);
//                    return task;
//                }
//            });


//    /**
//     * 广告位广告主媒体白名单缓存
//     * @param slotIds
//     * @return
//     */

//    private final LoadingCache<String, Map<String,Long>> MEDIA_SLOT_ACCOUNT_CACHE = CacheBuilder.newBuilder().initialCapacity(1).maximumSize(10)
//            .refreshAfterWrite(5, TimeUnit.MINUTES).build(new CacheLoader<String, Map<String,Long>>() {
//                @Override
//                public Map<String,Long> load(String key) {
//                    try {
//                        List<MediaAccountWhiteDO> mediaAccountWhiteDOS = mediaAccountWhiteDAO.selectMediaAccounts();
//                        Map<String,Long> resultMap = new HashMap<>(mediaAccountWhiteDOS.size());
//
//                        mediaAccountWhiteDOS.stream().forEach(dto->{
//                            String keyStr = dto.getSlotId()+ "-" +dto.getAccountId();
//                            resultMap.put(keyStr,1L);
//                        });
//                        return resultMap;
//                    }catch (Exception e){
//                        logger.error("MEDIA_SLOT_ACCOUNT_CACHE key:{} exception",key,e);
//                        return new HashMap<String,Long>();
//                    }
//                }
//
//                @Override
//                public ListenableFuture<Map<String,Long>> reload(final String key, Map<String,Long> map) {
//                    ListenableFutureTask<Map<String,Long>> task = ListenableFutureTask.create(()->load(key));
//                    executorService.submit(task);
//                    return task;
//                }
//            });


    /**
     * 广告位广告媒体白名单缓存
     * @param slotIds
     * @return
     */

    private final LoadingCache<Long, Optional<List<MediaAdvertWhiteDO>>> MEDIA_SLOT_ADVERT_LIST_CACHE = CacheBuilder.newBuilder().initialCapacity(1).maximumSize(5000)
            .refreshAfterWrite(5, TimeUnit.MINUTES).expireAfterWrite(1, TimeUnit.HOURS).build(new CacheLoader<Long, Optional<List<MediaAdvertWhiteDO>>>() {
                @Override
                public Optional<List<MediaAdvertWhiteDO>> load(Long slotId) {
                    try {
                        List<MediaAdvertWhiteDO> mediaAdvertWhiteDOS = mediaAdvertWhiteDAO.selectMediaAdvertListBySlotId(slotId);
                        return Optional.ofNullable(mediaAdvertWhiteDOS);
                    }catch (Exception e){
                        logger.error("MEDIA_SLOT_ADVERT_LIST_CACHE key:{} exception",slotId,e);
                        return Optional.empty();
                    }
                }

                @Override
                public ListenableFuture<Optional<List<MediaAdvertWhiteDO>>> reload(final Long slotId,Optional<List<MediaAdvertWhiteDO>> old) {
                    ListenableFutureTask<Optional<List<MediaAdvertWhiteDO>>> task = ListenableFutureTask.create(()->load(slotId));
                    executorService.submit(task);
                    return task;
                }
            });


    /**
     * 广告位广告主媒体白名单缓存
     * @param slotIds
     * @return
     */

    private final LoadingCache<Long, Optional<List<MediaAccountWhiteDO>>> MEDIA_SLOT_ACCOUNT_LIST_CACHE = CacheBuilder.newBuilder().initialCapacity(1).maximumSize(5000)
            .refreshAfterWrite(5, TimeUnit.MINUTES).expireAfterWrite(1, TimeUnit.HOURS).build(new CacheLoader<Long, Optional<List<MediaAccountWhiteDO>>>() {
                @Override
                public Optional<List<MediaAccountWhiteDO>> load(Long slotId) {
                    try {
                        List<MediaAccountWhiteDO> mediaAccountWhiteDOS = mediaAccountWhiteDAO.selectMediaAccountsListBySlotId(slotId);
                        return Optional.ofNullable(mediaAccountWhiteDOS);
                    }catch (Exception e){
                        logger.error("MEDIA_SLOT_ACCOUNT_LIST_CACHE key:{} exception",slotId,e);
                        return Optional.empty();
                    }
                }

                @Override
                public ListenableFuture<Optional<List<MediaAccountWhiteDO>>> reload(final Long slotId, Optional<List<MediaAccountWhiteDO>> old) {
                    ListenableFutureTask<Optional<List<MediaAccountWhiteDO>>> task = ListenableFutureTask.create(()->load(slotId));
                    executorService.submit(task);
                    return task;
                }
            });

    /**
     * 通知刷新 媒体广告位黑白名单
     */
    @Override
    public void updateMediaList(Long slotId) {
        MEDIA_SLOT_ADVERT_LIST_CACHE.refresh(slotId);
        MEDIA_SLOT_ACCOUNT_LIST_CACHE.refresh(slotId);
    }

    /**
     * 通知刷新 媒体广告位黑白名单开关状态
     */
    @Override
    public void updateMediaOpenStatus(Long slotId) {
        MEDIA_SLOT_SWITCH_CACHE.refresh(slotId);
    }

    /**
     * 广告位开关缓存 有消息同步，不用设置过期时间来保证避免读取旧值
     * @param slotIds
     * @return
     */

    private final LoadingCache<Long, Optional<SlotListStatusDto>> MEDIA_SLOT_SWITCH_CACHE = CacheBuilder.newBuilder().initialCapacity(4000).maximumSize(4000)
            .refreshAfterWrite(5, TimeUnit.MINUTES).build(new CacheLoader<Long, Optional<SlotListStatusDto>>() {
                @Override
                public Optional<SlotListStatusDto> load(Long key) {
                    try {
                        return Optional.ofNullable(getSlotSwitchStatus(key));
                    }catch (Exception e){
                        logger.error("MEDIA_SLOT_SWITCH_CACHE key:{} exception",key,e);
                        return Optional.ofNullable(null);
                    }
                }

                @Override
                public ListenableFuture<Optional<SlotListStatusDto>> reload(final Long key, Optional<SlotListStatusDto> oldValue) {
                    ListenableFutureTask<Optional<SlotListStatusDto>> task = ListenableFutureTask.create(()->load(key));
                    executorService.submit(task);
                    return task;
                }
            });


    private SlotListStatusDto getSlotSwitchStatus(Long slotId){

        SlotListStatusDto slotWhiteListStatusDto = null;
        if(slotId == null){
            return slotWhiteListStatusDto;
        }

        try {

            slotWhiteListStatusDto = remoteSlotBackendService.getSlotStatusById(slotId);
//            slotWhiteListStatusDto = remoteSlotBackendService.getSlotWhiteStatusById(slotId);
            logger.info("whiteListSwitch:{}", JSONObject.toJSONString(slotWhiteListStatusDto));
            return slotWhiteListStatusDto;
        }catch (Exception e){
            logger.error("getSlotSwitchStatus exception.",e);
            //返回降级类
            SlotListStatusDto jjSlotWhiteListStatusDto = new SlotListStatusDto();
            jjSlotWhiteListStatusDto.setOpenWihteList(0);
            jjSlotWhiteListStatusDto.setIsSyncWhiteList(0);
            jjSlotWhiteListStatusDto.setIsSyncBlackList(1);
            jjSlotWhiteListStatusDto.setOpenBlackList(1);
            return jjSlotWhiteListStatusDto;
        }
    }


    /**
     * 根据广告位id查询 媒体广告位名单（广告维度）
     *
     * @param slotId
     * @return
     */
    @Override
    public List<MediaAdvertWhiteDO> queryMediaAdvertList(Long slotId) {
        try {
            return MEDIA_SLOT_ADVERT_LIST_CACHE.get(slotId).orElse(Collections.emptyList());
        } catch (Exception e) {
            logger.error("MEDIA_SLOT_ADVERT_LIST_CACHE 查询异常",e);
            throw new RuntimeException(e.getMessage());
        }
    }

    /**
     * 根据广告位id查询 媒体广告位名单（广告主维度）
     *
     * @param slotId
     * @return
     */
    @Override
    public List<MediaAccountWhiteDO> queryMediaAccountList(Long slotId) {
        try {
            return MEDIA_SLOT_ACCOUNT_LIST_CACHE.get(slotId).orElse(Collections.emptyList());
        } catch (ExecutionException e) {
            logger.error("MEDIA_SLOT_ACCOUNT_LIST_CACHE 查询异常",e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public SlotListStatusDto isOpenSwitch(Long slotId) {

        Optional<SlotListStatusDto> slotWhiteListStatusDtoOptional = MEDIA_SLOT_SWITCH_CACHE.getUnchecked(slotId);

        if(slotWhiteListStatusDtoOptional.isPresent()){
            return slotWhiteListStatusDtoOptional.get();
        }

        SlotListStatusDto slotWhiteListStatusDto = new SlotListStatusDto();
        slotWhiteListStatusDto.setOpenWihteList(0);
        slotWhiteListStatusDto.setIsSyncWhiteList(0);
        slotWhiteListStatusDto.setIsSyncBlackList(0);
        slotWhiteListStatusDto.setOpenBlackList(0);
        return slotWhiteListStatusDto;
    }
}
