package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.nezha.engine.api.enums.DayuArgumentsEnum;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.domain.enums.ABTestLayerCodeEnum;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.service.ApolloConfig;
import cn.com.duiba.tuia.service.TransferDayuService;
import cn.com.duiba.tuia.service.router.FlowRouterProxyService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

@Service
@RefreshScope
public class TransferDayuServiceImpl implements TransferDayuService {

    @Resource
    private FlowRouterProxyService flowRouterProxyService;
    @Resource
    private ApolloConfig apolloConfig;

    public static final Map<String,String> TRANSFORM_MAP = new HashMap<>();

    static {
        //对照组
        TRANSFORM_MAP.put("control","1");
        //广告位实验组
        TRANSFORM_MAP.put("slotExp","2");
        //人群定向实验组
        TRANSFORM_MAP.put("peopleExp","3");
        //大盘组 
        TRANSFORM_MAP.put("main","4");

        // 融合实验组1
        TRANSFORM_MAP.put("mergeExp1","5");
        // 融合实验组2
        TRANSFORM_MAP.put("mergeExp2","6");
        // 融合实验组3
        TRANSFORM_MAP.put("mergeExp3","7");
    }


    //拓量开关1
    public static final String SLOT_PREFER = "slotPrefer";

    // 拓量开关
    public static final String EXPLORE_PREFER = "explorePrefer";

    //拓量开关2
    public static final String PEOPLE_PREFER = "peoplePrffer";

    //拓量实验名称
    public static final String EXPAND_NAME = "expandname";
    // 优化ocpc的实验名称
    public static final String MAJOR_OCPC_EXPNAME = "name";

    public static final String OPEN = "1";

    /**
     * 根据大禹切流
     * @param req
     * @param advQueryParam
     */
    @Override
    public void dayuCutByMajorOcpc(ObtainAdvertReq req, AdvQueryParam advQueryParam) {
        if (null == req.getLogExtExpMap()) {
            req.setLogExtExpMap(new HashMap<>());
        }

        // 获取大禹/AB平台实验结果
        ABResult dayuResult = flowRouterProxyService.routeFlow(req, ABTestLayerCodeEnum.PAY);
        Map<String, String> arguments = dayuResult.getArguments();

        req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.MAJOR_OCPC_EXPNAME, arguments.get(MAJOR_OCPC_EXPNAME));
        advQueryParam.setDayuArguments(arguments);

        //设置拓量的实验参数
        req.getLogExtExpMap().put(AdvertReqLogExtKeyConstant.OCPC_EXPAND_NAME,transform(arguments.get(EXPAND_NAME)));

        //设置新旧维稳分流标识
        req.getLogExtExpMap().put(DayuArgumentsEnum.STABILITY_AB.getKey(), arguments.get(DayuArgumentsEnum.STABILITY_AB.getKey()));
        // 设置扶持的实验标识
        req.getLogExtExpMap().put(DayuArgumentsEnum.SUPPORT_AB.getKey(), arguments.get(DayuArgumentsEnum.SUPPORT_AB.getKey()));

//        advQueryParam.setOcpcExpandName(arguments.get(EXPAND_NAME));

    }

    private String transform(String s) {
        if(StringUtils.isNotBlank(s)){
            return TRANSFORM_MAP.get(s);
        }
        return null;
    }
}
