package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.service.TransferService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


@Slf4j
@Service
@RefreshScope
public class TransferServiceImpl implements TransferService {

    public static final String MAP_NAME = "abtest";

    @Value("${tuia.micro.program.id}")
    private String EXPERIMENT_UNIQUE_KEY;

    //返回实验名称
    @Override
    public String getExperimentUniqueKey(){
        return this.EXPERIMENT_UNIQUE_KEY;
    }

    /**
     * ab测试 实验组 枚举
     */
    enum AbtestGroup {
        /**
         * 需要测试的实验组
         */
        MINI_PROGRAM(1000L, "jsjdhfhja9911");


        private static final String SPLIT = "#";

        private Long planId;
        private String groupId;

        AbtestGroup(Long planId, String groupId) {
            this.planId = planId;
            this.groupId = groupId;
        }


        public String getUniqueKey() {
            return this.planId + SPLIT + groupId;
        }

        public static String buildAbtestUniqueKey(Long planId, String groupId) {
            return planId + SPLIT + groupId;
        }

    }


    /**
     * 内部类 json反序列化需要
     */
    @Data
    private static class AbtestData {
        private Long planId;
        private String groupId;
    }

    /**
     * ab测试实验数据转换
     *
     * @param req
     * @param advQueryParam
     */
    @Override
    public void transferAbtestData(ObtainAdvertReq req, AdvQueryParam advQueryParam) {
        Map<String, String> logExtExpMap = req.getLogExtExpMap();
        String abTestJsonStr;
        if (null != logExtExpMap && null != (abTestJsonStr = logExtExpMap.get(MAP_NAME))) {
            Map<String, String> abtestMap = new ConcurrentHashMap<>();
            List<AbtestData> abtestDataList = null;
            try {
                abtestDataList = JSONObject.parseArray(abTestJsonStr, AbtestData.class);
            } catch (Exception e) {
                log.error("盘古平台传参无法解析，str=" + abTestJsonStr, e);
                abtestDataList = Collections.emptyList();
            }
            for (AbtestData abtestData : abtestDataList) {
                abtestMap.put(AbtestGroup.buildAbtestUniqueKey(abtestData.getPlanId(), abtestData.getGroupId()), "");
            }

            if (!abtestMap.isEmpty()) {
                advQueryParam.setAbtestMap(abtestMap);
            }
        }
    }
}

