/**
 * Project Name:engine-service File Name:ValidAdvertServiceImpl.java Package Name:cn.com.duiba.tuia.service.impl
 * Date:2018年2月11日上午11:05:50 Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.dao.advert.AdvertDAO;
import cn.com.duiba.tuia.dao.engine.SystemConfigDAO;
import cn.com.duiba.tuia.dao.validAdvert.ValidFreeAdvertDAO;
import cn.com.duiba.tuia.dao.validAdvert.ValidPayAdvertDAO;
import cn.com.duiba.tuia.domain.dataobject.ValidFreeAdvertOrderDO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.ValidAdvertService;

import com.google.common.collect.Lists;

/**
 * ClassName:ValidAdvertServiceImpl <br/>
 * Function: 有效广告. <br/>
 * Date: 2018年2月11日 上午11:05:50 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
@Service
public class ValidAdvertServiceImpl implements ValidAdvertService {

    @Autowired
    private ValidFreeAdvertDAO  validFreeAdvertDAO;

    @Autowired
    private ValidPayAdvertDAO   validPayAdvertDAO;

    @Autowired
    private SystemConfigDAO     systemConfigDAO;

    @Autowired
    private AdvertDAO           advertDAO;
    
    @Resource
    private ServiceManager      serviceManager;

    @Override
    public List<Long> getValidFreeAdvertAgain() throws TuiaException {

        // 查询免费代理商排序信息
        List<ValidFreeAdvertOrderDO> validFreeAgentList = validFreeAdvertDAO.selectValidFreeAgent();
        if (CollectionUtils.isEmpty(validFreeAgentList)) {
            return Lists.newArrayList();
        }
        // 免费有效广告排序信息
        List<ValidFreeAdvertOrderDO> validFreeAdvertDOList = validFreeAdvertDAO.selectValidFreeAdvert();
        if (CollectionUtils.isEmpty(validFreeAdvertDOList)) {
            return Lists.newArrayList();
        }
        Map<Long, List<Long>> validFreeAdvertIdMap = validFreeAdvertDOList.stream().collect(Collectors.groupingBy(ValidFreeAdvertOrderDO::getAgentId,
                                                                                                                  Collectors.collectingAndThen(Collectors.toList(),
                                                                                                                                               list -> list.stream().map(ValidFreeAdvertOrderDO::getSourceId).collect(Collectors.toList()))));
        // 组装数据
        List<Long> freeAdvertIds = Lists.newArrayList();
        validFreeAgentList.forEach(freeAgent -> {
            Optional.ofNullable(validFreeAdvertIdMap.get(freeAgent.getSourceId())).ifPresent(freeadId -> freeAdvertIds.addAll(freeadId));
        });
        return freeAdvertIds;
    }

    @Override
    public List<Long> selectValidPayAdvertFromDB() throws TuiaException {

        return validPayAdvertDAO.selectValidPayAdvert();
    }

    

}
