package cn.com.duiba.tuia.service.impl;

import cn.com.duiba.nezha.engine.api.enums.ActivitySceneEnum;
import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.domain.dataobject.OrderCustomAdvertDO;
import cn.com.duiba.tuia.domain.dataobject.SlotDO;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.AppDetail;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.service.OrderCustomAdvertService;
import cn.com.duiba.tuia.service.ShieldingStrategyService;
import cn.com.duiba.tuia.service.WhiteListService;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityAdvertDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertmonitor.ActivityAdvert4MonitorDto;
import cn.com.duiba.tuia.ssp.center.api.dto.advertmonitor.ActivityDirectMode4MonitorDto;
import cn.com.duiba.tuia.strategy.StrategyBeans;
import cn.com.duiba.tuia.tool.SwitchesUtil;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

@Slf4j
@Service
public class WhiteListServiceImpl implements WhiteListService {

    @Autowired
    private ServiceManager serviceManager;

    @Autowired
    private MediaCacheService mediaCacheService;

    @Autowired
    private OrderCustomAdvertService orderCustomAdvertService;


    /**
     * 执行白名单业务员
     *
     * @param req
     * @param rsp
     * @param filterResult
     * @param validAdverts
     * @param appDetail
     * @param advertFilter
     * @return
     */
    @Override
    public Map<Long, AdvertFilterVO> doWhiteListBusiness(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts, AppDetail appDetail, AdvertFilter advertFilter) {

        if (validAdverts.size() == 0) {
            return validAdverts;
        }

        //null 为老逻辑
        Integer isNeedExploit = null;
        try {
            Long slotId = req.getSlotId();

            WhitlistInfo activityWhitlistInfo = buildaActivityWhitlistInfo(req, filterResult);
            WhitlistInfo slotWhitlistInfo = buildaSlotWhitlistInfo(rsp, appDetail);

            //产品核心处理逻辑
            WhitlistInfo whitlistInfo = mergeInfo(activityWhitlistInfo,slotWhitlistInfo);

            //日志打印相关
            Map<String, String> logExtMap = req.getLogExtMap();
            if(null == logExtMap){
                logExtMap = new HashMap<>();
                req.setLogExtMap(logExtMap);
            }

            //打印命中的白名单日志
            if (null != whitlistInfo) {
                logExtMap.put(AdvertReqLogExtKeyConstant.WHITELIST_MODE,String.valueOf(whitlistInfo.getMode()));
            }

            //仅投过滤逻辑
            if(null != whitlistInfo && Objects.equals(WhitlistInfo.ONLY,whitlistInfo.getMode())){

                isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                Set<Long> whiteList = whitlistInfo.getWhiteList();
                if(CollectionUtils.isEmpty(whiteList)){
                    validAdverts.clear();
                }else {
                    validAdverts.keySet().retainAll(whiteList);
                }

                if (validAdverts.isEmpty()) {
                    return validAdverts;
                }
            }


            //顺序发券逻辑
            //活动发券顺序
            // 5.用户领取过的广告集合
            //仅投媒体白名单的 时候 活动发券顺序失效
//        WhitlistInfo.APP
            if (null == whitlistInfo || !Objects.equals(WhitlistInfo.APP,whitlistInfo.getOnlyMode())) {
                ActivityAdvert4MonitorDto activityAdvert4MonitorDto = filterResult.getActivityAdvert4MonitorDto();
                ActivityDirectMode4MonitorDto directMode4MonitorDto;
                if (null != activityAdvert4MonitorDto && null != (directMode4MonitorDto = activityAdvert4MonitorDto.getDirectMode4MonitorDto()) && Objects.equals(directMode4MonitorDto.getIsFixedOrderAdvert(), 1)) {
                    List<ActivityAdvertDto> activityAdvertDtoList = activityAdvert4MonitorDto.getActivityAdvertDtoList();
                    if (CollectionUtils.isNotEmpty(activityAdvertDtoList)) {
                        // 6.循环遍历，过滤定制化广告中的有效广告
                        //优投逻辑
                        if (null != whitlistInfo && CollectionUtils.isNotEmpty(whitlistInfo.getWhiteList()) && Objects.equals(WhitlistInfo.OPTIMIZATION, whitlistInfo.getMode())) {
                            Set<Long> whiteList = whitlistInfo.getWhiteList();
                            Long effectAdvertId = null;
                            for (ActivityAdvertDto activityAdvertDto : activityAdvertDtoList) {
                                Long advertId = activityAdvertDto.getAdvertId();
                                // 6.1 定向广告，而且用户未领取过
                                if (validAdverts.containsKey(advertId)) {
                                    if (whiteList.contains(advertId)) {
                                        validAdverts.keySet().retainAll(Arrays.asList(advertId));
                                        return validAdverts;
                                    }

                                    //取排序最靠前的非优投广告
                                    if (null == effectAdvertId) {
                                        effectAdvertId = advertId;
                                    }
                                }
                            }

                            if (null != effectAdvertId) {

                                isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                                validAdverts.keySet().retainAll(Arrays.asList(effectAdvertId));
                                return validAdverts;
                            }

                            HashSet<Long> longs1 = new HashSet<>(validAdverts.keySet());
                            longs1.retainAll(whiteList);
                            if (CollectionUtils.isNotEmpty(longs1)) {

                                isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                                validAdverts.keySet().retainAll(whiteList);
                                return validAdverts;
                            }

                            //优投降级 全发
                            return validAdverts;

                        }

                        //仅投逻辑
                        for (ActivityAdvertDto activityAdvertDto : activityAdvertDtoList) {
                            Long advertId = activityAdvertDto.getAdvertId();
                            // 6.1 定向广告，而且用户未领取过
                            if (validAdverts.containsKey(advertId)) {

                                isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                                validAdverts.keySet().retainAll(Arrays.asList(advertId));
                                return validAdverts;
                            }
                        }

                        return validAdverts;
                    }
                }
            }

            //广告位发券顺序
            // 有开关且要有顺序  有释放逻辑
            if (orderCustomAdvertService.isSwitchOpen(req)) {
                //此处用了 木白之前打的标记字段
                logExtMap.put(AdvertReqLogExtKeyConstant.ORDER_CUSTOM_FLAG,"1");
                try {
                    String slotJoinTimes = logExtMap.get("slotJoinTimes");
                    if(StringUtils.isNotBlank(slotJoinTimes)) {
                        Integer orderCount = Integer.valueOf(slotJoinTimes);
                        OrderCustomAdvertDO OrderCustomAdvertDO = orderCustomAdvertService.getConfigBySlotIdAndOrderCount(slotId, orderCount);
                        if (null != OrderCustomAdvertDO) {

                            Integer customDim = OrderCustomAdvertDO.getCustomDim();
                            String customValue = OrderCustomAdvertDO.getCustomValue();

                            //优投逻辑
                            if (null != whitlistInfo && CollectionUtils.isNotEmpty(whitlistInfo.getWhiteList()) && Objects.equals(WhitlistInfo.OPTIMIZATION, whitlistInfo.getMode())) {

                                Map<Long, AdvertFilterVO> priorityMap = new HashMap<>();
                                Map<Long, AdvertFilterVO> normalMap = new HashMap<>();

                                Set<Long> whiteList = whitlistInfo.getWhiteList();
                                validAdverts.forEach((key, value) -> {
                                    if (whiteList.contains(key)) {
                                        priorityMap.put(key, value);
                                    } else {
                                        normalMap.put(key, value);
                                    }
                                });

                                Set<Long> effectAdverts = OrderCustomUtil.getCustomAdverts(customDim, customValue, priorityMap);
                                if (CollectionUtils.isNotEmpty(effectAdverts)) {

                                    isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                                    validAdverts.keySet().retainAll(effectAdverts);
                                    return validAdverts;
                                }

                                effectAdverts = OrderCustomUtil.getCustomAdverts(customDim, customValue, normalMap);
                                if (CollectionUtils.isNotEmpty(effectAdverts)) {

                                    isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                                    validAdverts.keySet().retainAll(effectAdverts);
                                    return validAdverts;
                                }

                                HashSet<Long> longs1 = new HashSet<>(validAdverts.keySet());
                                longs1.retainAll(whiteList);
                                if (CollectionUtils.isNotEmpty(longs1)) {

                                    isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                                    validAdverts.keySet().retainAll(whiteList);
                                    return validAdverts;
                                }

                                //优投降级
                                return validAdverts;
                            }

                            //仅投 或者 普通发券逻辑
                            Set<Long> effectAdverts = OrderCustomUtil.getCustomAdverts(customDim, customValue, validAdverts);
                            if (CollectionUtils.isNotEmpty(effectAdverts)) {

                                isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                                validAdverts.keySet().retainAll(effectAdverts);
                                return validAdverts;
                            }

                            //降级 券次序发券失效
                            return validAdverts;
                        }
                    }
                } catch (Exception e) {
                    //ignore
                    log.warn("执行发券顺序异常", e);
                }
            }

            if(null != whitlistInfo && CollectionUtils.isNotEmpty(whitlistInfo.getWhiteList()) && Objects.equals(WhitlistInfo.OPTIMIZATION,whitlistInfo.getMode())) {
                //先发优投
                Set<Long> whiteList = whitlistInfo.getWhiteList();
                HashSet<Long> longs1 = new HashSet<>(validAdverts.keySet());
                longs1.retainAll(whiteList);
                if(CollectionUtils.isNotEmpty(longs1)){

                    isNeedExploit = ActivitySceneEnum.ACTIVITY_CUSTOMIZED_ADVERT.getCode();

                    validAdverts.keySet().retainAll(whiteList);
                    return validAdverts;
                }
                //再发非优投 即全量
                return validAdverts;
            }
        } finally {
            filterResult.setIsNeedExploit(isNeedExploit);
        }

        return validAdverts;
    }

    private WhitlistInfo mergeInfo(WhitlistInfo activityWhitlistInfo, WhitlistInfo slotWhitlistInfo) {

        if(null == activityWhitlistInfo){
            return slotWhitlistInfo;
        }

        if(null == slotWhitlistInfo){
            return activityWhitlistInfo;
        }

        return doMergeTwo(activityWhitlistInfo,slotWhitlistInfo);
    }

    private WhitlistInfo doMergeTwo(WhitlistInfo activityWhitlistInfo, WhitlistInfo slotWhitlistInfo) {
        WhitlistInfo mergeInfo = null;
        try {
            BiFunction<WhitlistInfo, WhitlistInfo, WhitlistInfo> excuteMethod = getExecuteMethod(activityWhitlistInfo,slotWhitlistInfo);

            mergeInfo = excuteMethod.apply(activityWhitlistInfo, slotWhitlistInfo);
        } catch (Exception e) {
            log.error("合并白名单数据异常",e);
        }

        return mergeInfo;
    }

    private BiFunction<WhitlistInfo, WhitlistInfo, WhitlistInfo> getExecuteMethod(WhitlistInfo activityWhitlistInfo, WhitlistInfo slotWhitlistInfo) {
        return WhitlistInfoUtil.functionMap.get(WhitlistInfoUtil.generateKey(activityWhitlistInfo.getMode(),slotWhitlistInfo.getMode()));
    }



    private WhitlistInfo buildaSlotWhitlistInfo(ObtainAdvertRsp rsp, AppDetail appDetail) {


        ShieldingStrategyService shieldingStrategy = StrategyBeans.shieldingStrategyMap.get(rsp.getStrategyType());

        List<Long> whiteList;
        try {
            whiteList = mediaCacheService.getWhiteList(appDetail, shieldingStrategy);
        } catch (TuiaException e) {
            whiteList = Collections.emptyList();
            log.error("查询广告位白名单发生异常",e);
        }

        if (CollectionUtils.isEmpty(whiteList)) {
            return null;
        }

        Integer mode = shieldingStrategy.isSendLuckybag(appDetail.getObjParam()) ? WhitlistInfo.OPTIMIZATION:WhitlistInfo.ONLY;

        WhitlistInfo rtn = new WhitlistInfo();
        rtn.setMode(mode);
        rtn.setWhiteList(new HashSet<>(whiteList));

        return rtn;
    }

    private boolean isNzSort(SlotDO slotDO,Integer strategyWhiteSortType) {
        int sortTypeBit = Optional.ofNullable(slotDO).map(solt -> Optional.ofNullable(solt.getNzSortType()).orElse(0)).orElse(0);
        // 位运算获取开关值
        int whiteSortType = SwitchesUtil.switchChange(sortTypeBit, strategyWhiteSortType);
        return MediaCacheService.SWITCH_OPEN == whiteSortType;
    }

    /**
     *  活动白名单信息
     */
    private WhitlistInfo buildaActivityWhitlistInfo(ObtainAdvertReq req, FilterResult filterResult) {

        if (req.getActivityUseType() == 0) {
            return null;
        }
        // 1.传参为null，直接降级。（过度阶段，后期严格校验参数后删除）
        if (req.getDuibaActivityId() == -1L && req.getDuibaActivityType() == 1) {
            return null;
        }
        // 2.查询定制化活动信息，判断是否开启定制化广告
        Optional<ActivityAdvert4MonitorDto> info = serviceManager.getBusinessActivityCache(req.getDuibaActivityId(), req.getActivityUseType());
        //没有活动信息，或者没有开启定制化广告，可回退降级
        if (!info.isPresent()) {
            return null;
        }
        ActivityAdvert4MonitorDto activityAdvert4MonitorDto = info.get();
        filterResult.setActivityAdvert4MonitorDto(activityAdvert4MonitorDto);
        filterResult.setActivityAdvert4MonitorReq(req.getDuibaActivityId() + "-" + (req.getActivityUseType() - 1));

        // 3.区分仅投定制化广告还是优先投放定制化广告，确定是否降级
        // 投放模式
        ActivityDirectMode4MonitorDto directMode4MonitorDto = activityAdvert4MonitorDto.getDirectMode4MonitorDto();
        // 广告列表
        List<ActivityAdvertDto> activityAdvertDtoList = activityAdvert4MonitorDto.getActivityAdvertDtoList();

        if (CollectionUtils.isEmpty(activityAdvertDtoList)) {
            return null;
        }

        List<Long> whiteList = activityAdvertDtoList.stream().map(ActivityAdvertDto::getAdvertId).collect(Collectors.toList());
        Integer mode = directMode4MonitorDto != null && directMode4MonitorDto.getDirectAdvertMode() == 1 ? WhitlistInfo.ONLY : WhitlistInfo.OPTIMIZATION;

        WhitlistInfo rtn = new WhitlistInfo();
        rtn.setMode(mode);
        rtn.setWhiteList(new HashSet<>(whiteList));

        return rtn;
    }
}


@Data
class WhitlistInfo{
    //仅投
    public static final Integer ONLY = 1;
    //优投
    public static final Integer OPTIMIZATION = 2;

    //仅投取了交集
    public static final Integer BOTH = 1;

    //仅投 活动白名单
    public static final Integer ACTIVITY = 2;

    //仅投 媒体白名单
    public static final Integer APP = 3;


    //投放模式 1-仅投，2-优投
    private Integer mode;

    //仅投标识 1、都是仅投，2、活动仅投，3、媒体仅投
    private Integer onlyMode;

    private Set<Long> whiteList;
}

/**
 * 白名单数据合并 工具类
 */
class WhitlistInfoUtil{

    final static Map<String,BiFunction<WhitlistInfo,WhitlistInfo,WhitlistInfo>> functionMap = new ConcurrentHashMap<>();

    static {
        /**
         * 合并核心逻辑
         */
        functionMap.put(generateKey(WhitlistInfo.ONLY, WhitlistInfo.ONLY),
                (WhitlistInfo a, WhitlistInfo b) -> {

                    WhitlistInfo whitlistInfo = new WhitlistInfo();
                    whitlistInfo.setMode(WhitlistInfo.ONLY);
                    whitlistInfo.setOnlyMode(WhitlistInfo.BOTH);

                    Set<Long> mergeSet = new HashSet<>(a.getWhiteList());
                    mergeSet.retainAll(b.getWhiteList());
                    whitlistInfo.setWhiteList(mergeSet);

                    return whitlistInfo;

                });

        functionMap.put(generateKey(WhitlistInfo.ONLY,WhitlistInfo.OPTIMIZATION),
                (WhitlistInfo a, WhitlistInfo b) -> {

                    WhitlistInfo whitlistInfo = new WhitlistInfo();
                    whitlistInfo.setMode(WhitlistInfo.ONLY);
                    whitlistInfo.setOnlyMode(WhitlistInfo.ACTIVITY);

                    Set<Long> mergeSet = new HashSet<>(a.getWhiteList());
                    whitlistInfo.setWhiteList(mergeSet);

                    return whitlistInfo;

                });

        functionMap.put(generateKey(WhitlistInfo.OPTIMIZATION,WhitlistInfo.ONLY),
                (WhitlistInfo a, WhitlistInfo b) -> {

                    WhitlistInfo whitlistInfo = new WhitlistInfo();
                    whitlistInfo.setMode(WhitlistInfo.ONLY);
                    whitlistInfo.setOnlyMode(WhitlistInfo.APP);

                    Set<Long> mergeSet = new HashSet<>(b.getWhiteList());
                    whitlistInfo.setWhiteList(mergeSet);

                    return whitlistInfo;

                });

        functionMap.put(generateKey(WhitlistInfo.OPTIMIZATION,WhitlistInfo.OPTIMIZATION),
                (WhitlistInfo a, WhitlistInfo b) -> {

                    WhitlistInfo whitlistInfo = new WhitlistInfo();
                    whitlistInfo.setMode(WhitlistInfo.OPTIMIZATION);

                    Set<Long> mergeSet = new HashSet<>(a.getWhiteList());
                    mergeSet.addAll(b.getWhiteList());
                    whitlistInfo.setWhiteList(mergeSet);

                    return whitlistInfo;

                });
    }

    static String generateKey(Integer mode1, Integer mode2) {
        return mode1+"#"+mode2;
    }

}

class OrderCustomUtil{
    private final static Map<Integer, BiFunction<AdvertFilterVO, String, Boolean>> functionMap = new ConcurrentHashMap<>();

    static {
        functionMap.put(1,
                (AdvertFilterVO vo, String customValue) -> Objects.equals(customValue, vo.getNewTradeName())
        );

        functionMap.put(2,
                (AdvertFilterVO vo, String customValue) -> Objects.equals(customValue, vo.getResourceTag())
        );

        functionMap.put(3,
                (AdvertFilterVO vo, String customValue) -> Objects.equals(customValue, String.valueOf(vo.getAccountId()))
        );

        functionMap.put(4,
                (AdvertFilterVO vo, String customValue) -> Objects.equals(customValue, String.valueOf(vo.getAdvertId()))
        );
    }


    public static Set<Long> getCustomAdverts(Integer customDim, String customValue, Map<Long, AdvertFilterVO> validAdverts) {

        if(null == customDim){
            return null;
        }

        BiFunction<AdvertFilterVO, String, Boolean> func = functionMap.get(customDim);

        if(null == func){
            return null;
        }

        return doBusiness(func,customValue,validAdverts);
    }


    private static Set<Long> doBusiness(BiFunction<AdvertFilterVO, String, Boolean> func,String customValue, Map<Long, AdvertFilterVO> a){

        Set<Long> rtnSet = new HashSet<>();
        if (MapUtils.isEmpty(a)) {
            return rtnSet;
        }

        a.forEach((key,value)->{
            if (func.apply(value,customValue)) {
                rtnSet.add(key);
            }
        });

        return rtnSet;
    }

}