package cn.com.duiba.tuia.service.router;

import cn.com.duiba.dayu.api.client.DayuClient;
import cn.com.duiba.dayu.api.enums.ArgumentType;
import cn.com.duiba.dayu.api.result.DayuResult;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.EnumMap;

/**
 * @author lijicong
 * @since 2021-02-01
 */
@Service
public class DayuClientService {

    @Resource
    private DayuClient dayuClient;

    public ABResult dayuHandleRequest(ObtainAdvertReq req, String sceneCode) {
        EnumMap<ArgumentType, Object> argumentTypeObjectEnumMap = new EnumMap<>(ArgumentType.class);
        argumentTypeObjectEnumMap.put(ArgumentType.CONSUMER_ID, req.getConsumerId());
        DayuResult dayuResult = dayuClient.handleRequest(sceneCode, argumentTypeObjectEnumMap);
        ABResult abResult = new ABResult();
        abResult.setArguments(dayuResult.getArguments());
        abResult.setExpIds(dayuResult.getExpIds());
        return abResult;
    }
}
