package cn.com.duiba.tuia.service.router;

import cn.com.duiba.tuia.constants.ABTestConstant;
import cn.com.duiba.tuia.domain.enums.ABTestLayerCodeEnum;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 流量路由服务代理
 *
 * @author lijicong
 * @since 2021-02-01
 */
@Service
@Slf4j
public class FlowRouterProxyService {

    @Resource
    private FlowRouterService flowRouterService;
    @Resource
    private ApolloPanGuService apolloPanGuService;

    /**
     * 获取AB实验平台的LayerCode，先取盘古配置，没有则取枚举默认配置
     * @param layerCodeEnum
     * @return
     */
    public String getLayerCode(ABTestLayerCodeEnum layerCodeEnum) {
        Map<String, String> panguConfigMap = apolloPanGuService.getIdMapByKeyStr(ABTestConstant.ABTEST_LAYER_CODE);
        return layerCodeEnum.getLayerCode(panguConfigMap);
    }

    /**
     * 路由流量
     * @param req
     * @param layerCodeEnum
     * @return
     */
    public ABResult routeFlow(ObtainAdvertReq req, ABTestLayerCodeEnum layerCodeEnum) {
        return doRouteFlow(req, layerCodeEnum, null, null, true);
    }

    public ABResult routeFlow(ObtainAdvertReq req, ABTestLayerCodeEnum layerCodeEnum, Long advertId, Map<String, Object> extraMap) {
        return doRouteFlow(req, layerCodeEnum, advertId, extraMap, true);
    }

    public ABResult routeFlowWithoutLog(ObtainAdvertReq req, ABTestLayerCodeEnum layerCodeEnum, Long advertId, Map<String, Object> extraMap) {
        return doRouteFlow(req, layerCodeEnum, advertId, extraMap, false);
    }

    public ABResult doRouteFlow(ObtainAdvertReq req, ABTestLayerCodeEnum layerCodeEnum, Long advertId, Map<String, Object> extraMap, boolean isLog) {
        try {
            if (isLog) {
                return flowRouterService.abtestHandleResult(req, getLayerCode(layerCodeEnum), advertId, extraMap);
            }
            return flowRouterService.abtestHandleResultWithoutLog(req, getLayerCode(layerCodeEnum), advertId, extraMap);
        } catch (Exception e) {
            log.warn("流量路由服务异常 layerCode={}", layerCodeEnum, e);
        }
        return new ABResult();
    }

}
