package cn.com.duiba.tuia.service.router;

import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import com.duiba.tuia.abtest.api.dto.ABRequestDto;
import com.duiba.tuia.abtest.api.dto.ABResponseDto;
import com.duiba.tuia.abtest.api.dto.ABResultDto;

import java.util.List;
import java.util.Map;

/**
 * 流量路由服务
 *
 * @author lijicong
 * @since 2020-12-10
 */
public interface FlowRouterService {

    /**
     * 实验平台接口
     *
     * @param req
     * @param layerCode
     * @return
     */
    ABResult abtestHandleResult(ObtainAdvertReq req, String layerCode);

    /**
     * 实验平台接口
     *
     * @param req 广告请求参数
     * @param layerCode 实验层编号
     * @param advertId 广告ID
     * @param extraMap 实验扩展参数
     * @return 实验结果
     */
    ABResult abtestHandleResult(ObtainAdvertReq req, String layerCode, Long advertId, Map<String, Object> extraMap);

    /**
     * 实验平台接口(不打印日志)
     *
     * @param req 广告请求参数
     * @param layerCode 实验层编号
     * @param advertId 广告ID
     * @param extraMap 实验扩展参数
     * @return 实验结果
     */
    ABResult abtestHandleResultWithoutLog(ObtainAdvertReq req, String layerCode, Long advertId, Map<String, Object> extraMap);

    /**
     * 实验平台批量接口
     *
     * @param request 请求参数
     * @return 实验结果
     */
    List<ABResult> batchABTestHandleResult(List<ABRequestDto> request);

    /**
     * 实验平台域测试接口
     *
     * @param req 广告请求参数
     * @param layerCode 实验层编号
     * @param advertId 广告ID
     * @param extraMap 实验扩展参数
     * @return 实验结果
     */
    ABResult domainABTestHandleResult(ObtainAdvertReq req, String layerCode, Long advertId, Map<String, Object> extraMap);

    /**
     * 调用实验平台run接口
     *
     * @param req 广告请求参数
     * @param layerCode 实验层编码
     * @return 实验平台响应结果
     */
    ABResponseDto runABTest(ObtainAdvertReq req, String layerCode);

    /**
     * 记录实验平台分流延时日志
     *
     * @param req 广告请求参数
     * @param abResult 实验平台结果
     */
    void abtestLog(ObtainAdvertReq req, List<ABResultDto> abResult);
}
