package cn.com.duiba.tuia.service.router;

import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import java.util.List;

/**
 * 实验平台-落地页ABTest接口
 *
 * @author zhangbaiqiang
 * @date 2021/1/28
 */
public interface PromoteABTestService {

    /**
     * 实验平台-获取测试落地页
     *
     * @param req 广告请求参数
     * @param advertId 广告ID
     * @param orientId 配置ID
     * @return 分流命中的测试落地页
     */
    String getPromoteUrl(ObtainAdvertReq req, Long advertId, Long orientId);

    /**
     * 实验平台-获取测试落地页(不打印日志)
     *
     * @param req 广告请求参数
     * @param advertId 广告ID
     * @param orientId 配置ID
     * @param abResultList ab测试结果列表
     * @return 分流命中的测试落地页
     */
    String getPromoteUrlWithoutLog(ObtainAdvertReq req, Long advertId, Long orientId, List<ABResult.ABResultDTO> abResultList);


    /**
     * 实验平台-获取测试落地页 不打日志
     *
     * @param req 广告请求参数
     * @param advertId 广告ID
     * @param orientId 配置ID
     * @return 分流命中的结果集
     */
    ABResult routeFlowWithoutLog(ObtainAdvertReq req, Long advertId, Long orientId);
}
