package cn.com.duiba.tuia.service.router.impl;

import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.domain.model.abtest.ABResult.ABResultDTO;
import cn.com.duiba.tuia.service.BaseService;
import cn.com.duiba.tuia.service.router.FlowRouterService;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.duiba.tuia.abtest.api.dto.*;
import com.duiba.tuia.abtest.api.remoteservice.RemoteABTestService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lijicong
 * @since 2020-12-10
 */
@Service
public class FlowRouterServiceImpl extends BaseService implements FlowRouterService {

    @Autowired
    private RemoteABTestService remoteABTestService;

    private static final String COMMA = ",";

    @Override
    public ABResult abtestHandleResult(ObtainAdvertReq req, String layerCode) {
        return doABtestHandleResult(req, layerCode, null, null);
    }

    @Override
    public ABResult abtestHandleResult(ObtainAdvertReq req, String layerCode, Long advertId, Map<String, Object> extraMap) {
        return doABtestHandleResult(req, layerCode, advertId, extraMap);
    }

    private ABResult doABtestHandleResult(ObtainAdvertReq req, String layerCode, Long advertId, Map<String, Object> extraMap) {
        String extra = MapUtils.isNotEmpty(extraMap) ? JSON.toJSONString(extraMap) : null;

        // 调用实验平台
        ABResult abResult = runABTestAndGetArguments(layerCode, req.getDeviceId(), req.getSlotId(), advertId, extra);
        if (CollectionUtils.isEmpty(abResult.getAbResultList())) {
            return abResult;
        }

        // 打印实验评结果日志
        try {
            String abtest = req.getLogExtExpMap().get("abtest");
            if (StringUtils.isNotBlank(abtest)) {
                List<ABResultDTO> abResultDTOS = JSON.parseArray(abtest, ABResultDTO.class);
                abResultDTOS.addAll(abResult.getAbResultList());
                req.getLogExtExpMap().put("abtest", JSON.toJSONString(abResultDTOS));
            } else {
                req.getLogExtExpMap().put("abtest", JSON.toJSONString(abResult.getAbResultList()));
            }
        } catch (Exception e) {
            logger.warn("打印实验平台结果异常", e);
        }
        return abResult;
    }

    @Override
    public ABResult abtestHandleResultWithoutLog(ObtainAdvertReq req, String layerCode, Long advertId, Map<String,
            Object> extraMap) {
        String extra = MapUtils.isNotEmpty(extraMap) ? JSON.toJSONString(extraMap) : null;
        return runABTestAndGetArguments(layerCode, req.getDeviceId(), req.getSlotId(), advertId, extra);
    }

    @Override
    public List<ABResult> batchABTestHandleResult(List<ABRequestDto> request) {
        if (CollectionUtils.isEmpty(request)) {
            return Collections.emptyList();
        }

        try {
            ABAdvertResponseBatchDto response = remoteABTestService.advertRunBatch(request);
            if (response != null && response.isSuccess() && CollectionUtils.isNotEmpty(response.getResult())) {
                if (logConfig.getInfoEnable() && Math.random() < 0.0001) {
                    logger.info("调用实验平台批量接口 request={}, response={}", JSON.toJSONString(request), JSON.toJSONString(response));
                }

                return response.getResult().stream().map(abResultDto -> {
                    ABResult abResult = new ABResult();
                    abResult.setArguments(parseTestValue(abResultDto.getTestValue()));
                    abResult.getArguments().putAll(parseTestValue(abResultDto.getExtra()));
                    abResult.setAbResultList(Collections.singletonList(BeanUtils.copy(abResultDto, ABResultDTO.class)));
                    return abResult;
                }).collect(Collectors.toList());
            }
            logger.info("调用实验平台批量接口 没有命中实验 request={}, response={}", JSON.toJSONString(request), JSON.toJSONString(response));
        } catch (Exception e) {
            logger.error("调用实验平台批量接口 异常 request={}", JSON.toJSONString(request), e);
        }
        return Collections.emptyList();
    }

    @Override
    public ABResult domainABTestHandleResult(ObtainAdvertReq req, String layerCode, Long advertId, Map<String,
            Object> extraMap) {
        String extra = MapUtils.isNotEmpty(extraMap) ? JSON.toJSONString(extraMap) : null;
        return runABTestAndGetArguments(layerCode, req.getDeviceId(), req.getSlotId(), advertId, extra);
    }

    @Override
    public ABResponseDto runABTest(ObtainAdvertReq req, String layerCode) {
        ABRequestDto request = new ABRequestDto();
        request.setLayerCode(layerCode);
        request.setDeviceId(req.getDeviceId());
        request.setSlotId(req.getSlotId());
        try {
            return remoteABTestService.run(request);
        } catch (Exception e) {
            logger.error("调用实验平台run接口 异常 request={}", JSON.toJSONString(request), e);
        }
        return null;
    }

    @Override
    public void abtestLog(ObtainAdvertReq req, List<ABResultDto> abResult) {
        if (CollectionUtils.isEmpty(abResult)) {
            return;
        }

        List<ABResult.ABResultDTO> abResultList = abResult.stream().map(item -> BeanUtils.copy(item, ABResult.ABResultDTO.class)).collect(Collectors.toList());

        try {
            String abtest = req.getLogExtExpMap().get("abtest");
            if (StringUtils.isNotBlank(abtest)) {
                List<ABResult.ABResultDTO> abResultDTOS = JSON.parseArray(abtest, ABResult.ABResultDTO.class);
                abResultDTOS.addAll(abResultList);
                req.getLogExtExpMap().put("abtest", JSON.toJSONString(abResultDTOS));
            } else {
                req.getLogExtExpMap().put("abtest", JSON.toJSONString(abResultList));
            }
        } catch (Exception e) {
            logger.warn("打印实验平台结果异常", e);
        }
    }

    private ABResult runABTestAndGetArguments(String layerCode, String deviceId, Long slotId, Long advertId, String extra) {
        ABRequestDto request = new ABRequestDto();
        request.setLayerCode(layerCode);
        request.setDeviceId(deviceId);
        request.setSlotId(slotId);
        request.setAdvertId(advertId);
        request.setExtra(extra);
        ABAdvertResponseDto response = null;
        ABResult abResult = new ABResult();
        try {
            response = remoteABTestService.advertRun(request);
            if (response != null && response.isSuccess() && MapUtils.isNotEmpty(response.getResult())) {
                if (logConfig.getInfoEnable() && Math.random() < 0.0001) {
                    logger.info("调用实验平台接口 request={}, response={}", JSON.toJSONString(request), JSON.toJSONString(response));
                }
                Map<String, String> arguments = parseTestValue(layerCode, response);
                abResult.setArguments(arguments);
                List<ABResultDTO> abResultList = response.getResult().values().stream().map(item -> BeanUtils.copy(item, ABResultDTO.class)).collect(Collectors.toList());
                abResult.setAbResultList(abResultList);
                return abResult;
            }
            logger.info("调用实验平台接口 返回失败 request={}, response={}", JSON.toJSONString(request), JSON.toJSONString(response));
        } catch (Exception e) {
            logger.error("调用实验平台接口 异常 request={}, response={}", JSON.toJSONString(request), JSON.toJSONString(response), e);
        }
        return abResult;
    }

    private Map<String, String> parseTestValue(String layerCode, ABAdvertResponseDto response) {
        try {
            if (!layerCode.contains(COMMA)) {
                return JSON.parseObject(response.getResult().get(layerCode).getTestValue(), new TypeReference<Map<String, String>>() {
                });
            }
            // 多个层的，自定义参数key不能相同
            String[] layerCodes = layerCode.split(COMMA);
            Map<String, String> map = new HashMap<>();
            for (String key : layerCodes) {
                ABResultDto abResultDto = response.getResult().get(key);
                if (abResultDto != null && StringUtils.isNotBlank(abResultDto.getTestValue())) {
                    Map<String, String> jsonObject = JSON.parseObject(abResultDto.getTestValue(), new TypeReference<Map<String, String>>() {
                    });
                    map.putAll(jsonObject);
                    map.put("domainStatus", String.valueOf(abResultDto.getDomainStatus()));
                }
            }
            return map;
        } catch (Exception e) {
            logger.error("调用实验平台接口 解析testValue异常 response={}", JSON.toJSONString(response), e);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> parseTestValue(String testValue) {
        if (StringUtils.isBlank(testValue)) {
            return Collections.emptyMap();
        }

        try {
            return JSON.parseObject(testValue, new TypeReference<Map<String, String>>() {});
        } catch (Exception e) {
            logger.error("调用实验平台接口 解析testValue异常 testValue={}", testValue, e);
        }
        return Collections.emptyMap();
    }
}
