package cn.com.duiba.tuia.service.router.impl;

import cn.com.duiba.tuia.domain.enums.ABTestLayerCodeEnum;
import cn.com.duiba.tuia.domain.model.abtest.ABResult;
import cn.com.duiba.tuia.service.BaseService;
import cn.com.duiba.tuia.service.router.FlowRouterProxyService;
import cn.com.duiba.tuia.service.router.PromoteABTestService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 实验平台-落地页ABTest接口实现
 *
 * @author zhangbaiqiang
 * @date 2021/1/28
 */
@Service
public class PromoteABTestServiceImpl extends BaseService implements PromoteABTestService {

    @Autowired
    private FlowRouterProxyService flowRouterProxyService;

    @Override
    public String getPromoteUrl(ObtainAdvertReq req, Long advertId, Long orientId) {
        Map<String, Object> extra = new HashMap<>(1);
        extra.put("orientId", orientId);
        ABResult abResult = flowRouterProxyService.routeFlow(req, ABTestLayerCodeEnum.PROMOTE_TEST, advertId, extra);
        if (null == abResult) {
            return null;
        }

        Map<String, String> arguments = abResult.getArguments();
        return arguments.get("promoteUrl");
    }

    @Override
    public String getPromoteUrlWithoutLog(ObtainAdvertReq req, Long advertId, Long orientId, List<ABResult.ABResultDTO> abResultList) {
        Map<String, Object> extra = new HashMap<>(1);
        extra.put("orientId", orientId);
        ABResult abResult = flowRouterProxyService.routeFlowWithoutLog(req, ABTestLayerCodeEnum.PROMOTE_TEST, advertId, extra);
        if (null == abResult) {
            return null;
        }

        if (null != abResultList) {
            abResultList.addAll(abResult.getAbResultList());
        }

        Map<String, String> arguments = abResult.getArguments();
        return arguments.get("promoteUrl");
    }

    @Override
    public ABResult routeFlowWithoutLog(ObtainAdvertReq req, Long advertId, Long orientId) {
        Map<String, Object> extra = new HashMap<>(1);
        extra.put("orientId", orientId);
        ABResult abResult = flowRouterProxyService.routeFlowWithoutLog(req, ABTestLayerCodeEnum.PROMOTE_TEST, advertId, extra);
        return abResult;
    }
}
