package cn.com.duiba.tuia.standardscene.component;

import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.constants.PackagePlanConstants;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.enums.ReqSourceTypeEnum;
import cn.com.duiba.tuia.enums.adx.AdxLoadTypeEnum;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowComponent;
import cn.com.duiba.tuia.tool.CatUtil;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component
public class BuildParammeterAdxComponent implements WorkFlowComponent {

    @Autowired
    private AdxServiceImpl adxService;

    @Override
    public String getName() {
        return "build_parameter_adx";
    }

    @Override
    public void excute(TaskData data) {

        ObtainAdvertReq req = data.getReq();

        ObtainAdvertRsp rsp = new ObtainAdvertRsp();
        rsp.setSlotId(req.getSlotId());
        rsp.setResult(false);
        FilterResult filterResult = new FilterResult();

        // 广告过滤日志
        AdvertFilter advertFilter = new AdvertFilter();
        advertFilter.setAppId(req.getAppId());
        advertFilter.setSlotId(req.getSlotId());
        advertFilter.setOrderId(req.getOrderId());
        advertFilter.setReqSourceType(getReqSourceType(req));
        advertFilter.setActivityId(req.getActivityId());

        // cat监控区分预发券与真实发券
        String catMonitor = "defAdxAdvert";
        if(AdxLoadTypeEnum.PRE_LOAD.getLoadType() == req.getAdxLoadType()){
            catMonitor = "preAdxAdvert";
            CatUtil.log(CatGroupEnum.CAT_104001.getCode());

        }else if(AdxLoadTypeEnum.ACT_LOAD.getLoadType() == req.getAdxLoadType()){
            catMonitor = "actAdxAdvert";
            CatUtil.log(CatGroupEnum.CAT_104002.getCode());
        }


        data.setRsp(rsp);
        data.setFilterResult(filterResult);
        data.setAdvertFilter(advertFilter);
        data.setCatMonitor(catMonitor);

        try {
            AdxServiceImpl.AdxParameters adxParameters = CatUtil.executeInCatTransaction(() -> adxService.buildAdxParameters(req, rsp), catMonitor, "buildAdxParameters");

            data.setAdvQueryParam(adxParameters.getAdvQueryParamTmp());
            data.setFilterResult(adxParameters.getFilterResult());
            data.setConsumerDto(adxParameters.getConsumerDto());
            data.setAppDetail(adxParameters.getAppDetail());
            data.setShieldStrategyVO(adxParameters.getShieldStrategyVO());
            data.setCityId(adxParameters.getCity());

//            loadTypeEnum = AdxLoadTypeEnum.findByType(req.getAdxLoadType());

        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }

    }


    /**
     * 判断直投类型
     *
     * @param req 请求参数
     * @return 直投类型
     */
    private Integer getReqSourceType(ObtainAdvertReq req) {
        // 区块直投
        if (Objects.equals(req.getActivitySceneType(), 3)) {
            return ReqSourceTypeEnum.BLOCK_DIRECT.getType();
        }

        // 互动直投
        if (Objects.equals(req.getAdType(), PackagePlanConstants.VEDIO_AD_TYPE)) {
            return ReqSourceTypeEnum.HD_DIRECT.getType();
        }

        // 媒体ADX
//        if (Objects.equals(req.getAdxMediaType(), 1) && req.getOrderIds() == null) {
        if (Objects.equals(req.getAdxMediaType(), 1)) {
            return ReqSourceTypeEnum.MEITUAN_ADX.getType();
        }

        // 默认
        return ReqSourceTypeEnum.UNKNOWN.getType();
    }

}
