package cn.com.duiba.tuia.standardscene.component;

import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.constants.AdvertReqLogExtKeyConstant;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.enums.adx.AdxFallbackEnum;
import cn.com.duiba.tuia.log.LogConfig;
import cn.com.duiba.tuia.service.AdvertPreFilterService;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowComponent;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * adx 内存过滤组件
 *
 */
@Slf4j
@Component
public class MemoryFilterAdxComponent implements WorkFlowComponent {

    @Autowired
    private AdxServiceImpl adxService;
    @Autowired
    private AdvertPreFilterService advertPreFilterService;
    @Autowired
    private LogConfig logConfig;

    @Override
    public String getName() {
        return "memory_filter_adx";
    }

    @Override
    public void excute(TaskData data) {

        AdvertFilter advertFilter = data.getAdvertFilter();
        FilterResult filterResult = data.getFilterResult();
        ObtainAdvertReq req = data.getReq();
        ObtainAdvertRsp rsp = data.getRsp();
        AdvQueryParam advQueryParam = data.getAdvQueryParam();
        String catMonitor = data.getCatMonitor();

        Map<String, String> reqMap = Optional.ofNullable(req.getLogExtMap()).orElse(new HashMap<>());

        try {
            Map<Long, AdvertFilterVO>  validAdverts = CatUtils.executeInCatTransaction(() -> advertPreFilterService.preFilterAdvertWithEsHystrix(advQueryParam, req, filterResult, advertFilter), catMonitor, "memoryFilter");
            data.setValidAdverts(validAdverts);

            if (logConfig.getInfoEnable()) {
                log.info("adx[{}]请求过滤日志，adxId={}, advertFilter={}, req = ", catMonitor, reqMap.get(AdvertReqLogExtKeyConstant.ADX_RID), JSON.toJSONString(advertFilter), JSON.toJSONString(req));
            }

            // 无结果时降级
            if(MapUtils.isEmpty(validAdverts)){
                adxService.fallBackList(AdxFallbackEnum.FILTER_FALL_BACK, rsp);
                data.setFinished(true);
            }
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }

    }

}
