package cn.com.duiba.tuia.standardscene.component;

import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowComponent;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class SendAdAdxActPreComponent implements WorkFlowComponent{

    @Autowired
    private AdxServiceImpl adxService;

    @Override
    public String getName() {
        return "send_ad_adx_act_pre";
    }

    @Override
    public void excute(TaskData data) {
        Map<Long, AdvertFilterVO> validAdverts = data.getValidAdverts();
        ObtainAdvertRsp rsp = data.getRsp();

        adxService.activityPreAdvert(validAdverts, rsp);
        data.setFinished(true);
    }
}
