package cn.com.duiba.tuia.standardscene.component;

import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.enums.adx.AdxFallbackEnum;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowComponent;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class SendAdAdxBlockDirectComponent implements WorkFlowComponent {

    @Autowired
    private AdxServiceImpl adxService;

    @Override
    public String getName() {
        return "send_ad_adx_block_direct";
    }

    @Override
    public void excute(TaskData data) {

        ObtainAdvertReq req = data.getReq();
        ObtainAdvertRsp rsp = data.getRsp();
        AdvQueryParam advQueryParam = data.getAdvQueryParam();
        FilterResult filterResult = data.getFilterResult();
        Map<Long, AdvertFilterVO> validAdverts = data.getValidAdverts();
        AdvertFilter advertFilter = data.getAdvertFilter();

        // 过滤出白名单的广告
        AdvertPriceVO advertPriceVO = adxService.filterByBlockAdvertIds(validAdverts, req.getBlockAdvertIds(), advQueryParam);

        // 区块白名单过滤日志
        adxService.blockFilterLog(advertFilter, validAdverts, advertPriceVO);

        // 没有匹配的广告，直接返回
        if (null == advertPriceVO) {
            adxService.fallBackList(AdxFallbackEnum.FILTER_FALL_BACK, rsp);
            data.setFinished(true);
            return;
        }

        // 构造广告响应信息
        adxService.doObtainAdvertForBlockDirect(req, rsp, advertPriceVO, filterResult, advertFilter);
        data.setFinished(true);
    }
}
