package cn.com.duiba.tuia.standardscene.component;

import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.nezha.engine.api.dto.RcmdAdvertDto;
import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowComponent;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class SendAdAdxNezhaComponent implements WorkFlowComponent {

    @Autowired
    private AdxServiceImpl adxService;

    @Override
    public String getName() {
        return "send_ad_adx_nezha";
    }

    @Override
    public void excute(TaskData data) {

        AdvertFilter advertFilter = data.getAdvertFilter();
        FilterResult filterResult = data.getFilterResult();
        ObtainAdvertReq req = data.getReq();
        ObtainAdvertRsp rsp = data.getRsp();
        AdvQueryParam advQueryParam = data.getAdvQueryParam();
        Map<Long, AdvertFilterVO> validAdverts = data.getValidAdverts();
        ConsumerDto consumerDto = data.getConsumerDto();
        String catMonitor = data.getCatMonitor();

        try {
            //哪吒算法推荐出券
            List<RcmdAdvertDto> rcmdAdvertDtoList = CatUtils.executeInCatTransaction(() -> adxService.adxRecommendAdvert(validAdverts, advQueryParam, filterResult, req, rsp, consumerDto, advertFilter) , catMonitor, "recommendAdvert");
            //记录nezha过滤日志
            adxService.recordNezhaFilterLog(validAdverts, rcmdAdvertDtoList, advertFilter);
            data.setRcmdAdvertDtoList(rcmdAdvertDtoList);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }

    }
}
