package cn.com.duiba.tuia.standardscene.component;

import cn.com.duiba.nezha.engine.api.dto.RcmdAdvertDto;
import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowComponent;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class SendAdAdxPreLoadComponent implements WorkFlowComponent {

    @Autowired
    private AdxServiceImpl adxService;

    @Override
    public String getName() {
        return "send_ad_adx_pre_load";
    }

    @Override
    public void excute(TaskData data) {

        AdvertFilter advertFilter = data.getAdvertFilter();
        FilterResult filterResult = data.getFilterResult();
        ObtainAdvertReq req = data.getReq();
        ObtainAdvertRsp rsp = data.getRsp();
        List<RcmdAdvertDto> rcmdAdvertDtoList = data.getRcmdAdvertDtoList();
        String catMonitor = data.getCatMonitor();

        try {
            CatUtils.executeInCatTransaction(() -> adxService.packPreLoadAdvert(req, rsp, filterResult, rcmdAdvertDtoList, advertFilter), catMonitor, "packPreLoadAdvert");
            data.setFinished(true);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }

    }
}
