package cn.com.duiba.tuia.standardscene.component;

import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowComponent;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class SendAdAdxdegradeComponent implements WorkFlowComponent {

    @Autowired
    private AdxServiceImpl adxService;

    @Override
    public String getName() {
        return "send_ad_adx_degrade";
    }

    @Override
    public void excute(TaskData data) {

        ObtainAdvertRsp rsp = data.getRsp();

        // 如果推荐算法发券不成功，则需要降级处理，走原来的投放逻辑
        if (!rsp.isResult()) {
            AdvertFilter advertFilter = data.getAdvertFilter();
            FilterResult filterResult = data.getFilterResult();
            ObtainAdvertReq req = data.getReq();
            AdvQueryParam advQueryParam = data.getAdvQueryParam();
            Map<Long, AdvertFilterVO> validAdverts = data.getValidAdverts();
            ShieldStrategyVO shieldStrategyVO = data.getShieldStrategyVO();
            String cityId = data.getCityId();
            AppDetail appDetail = data.getAppDetail();
            String catMonitor = data.getCatMonitor();
            /*AdxSetSceneType.SET_REQ_ADX_SCENE.setReqScene(req,AdxSceneEnum.ADX_API.getCode());*/
            try {
                CatUtils.executeInCatTransaction(() -> adxService.degradeAdxAdvert(filterResult, req, rsp, validAdverts, appDetail, shieldStrategyVO, cityId, advQueryParam, advertFilter), catMonitor, "degradeAdxAdvert");
            } catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}
