package cn.com.duiba.tuia.standardscene.framework;

import cn.com.duiba.tuia.standardscene.framework.impl.WorkFlowImpl;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class WorkFlowFactory {

    private final static WorkFlow LAST_WORKFLOW = new WorkFlow(){

        @Override
        public WorkFlow next(TaskData data) {
            return null;
        }

        @Override
        public void excute(TaskData data) {
            return;
        }
    };

    private static final Map<String,WorkFlowComponent> workFlowComponentMap = new ConcurrentHashMap<>();



    public static WorkFlow builldWorkFlow(List<String> workFlowConfig) {

        if (CollectionUtils.isEmpty(workFlowConfig)) {
            return LAST_WORKFLOW;
        }

        WorkFlowImpl headNode = null;
        WorkFlowImpl tailNode = null;
        for (String configName : workFlowConfig) {
            WorkFlowComponent workFlowComponent = workFlowComponentMap.get(configName);
            Objects.requireNonNull(workFlowComponent);

            WorkFlowImpl newNode = WorkFlowImpl.builder().workFlowComponent(workFlowComponent).build();
            if(null == headNode){
                headNode = newNode;
                tailNode = headNode;
            }else {
                tailNode.setNextWorkFlow(newNode);
                tailNode = newNode;
            }
        }

        return headNode;
    }

    public static void registerWorkFlowComponent(WorkFlowComponent workFlowComponent) {
        workFlowComponentMap.put(workFlowComponent.getName(),workFlowComponent);
    }
}
