package cn.com.duiba.tuia.standardscene.framework.impl;

import cn.com.duiba.tuia.adx.AdxServiceImpl;
import cn.com.duiba.tuia.standardscene.framework.StarndardScene;
import cn.com.duiba.tuia.standardscene.framework.StarndardSceneFactory;
import cn.com.duiba.tuia.standardscene.framework.WorkFlow;
import cn.com.duiba.tuia.standardscene.framework.WorkFlowFactory;
import cn.com.duiba.tuia.standardscene.framework.dto.ScenePropertyDto;
import cn.com.duiba.tuia.standardscene.scene.ScenePropertysConfig;
import cn.com.duiba.tuia.utils.ActPreUtils;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
public class StarndardSceneFactoryImpl implements StarndardSceneFactory, InitializingBean {

    /** 兜底的场景 - 指 场景化之前的耦合场景 最终这个是要下掉的*/
    private StarndardScene guaranteedStarndardScene;

    /** key = 场景名称*/
    private Map<Long,StarndardScene> idStarndardSceneMap;

    /** key = 根据统一的特征计算方法计算的 特征名称*/
    private Map<String,StarndardScene> featureNameStarndardSceneMap;


    /**
     * 根据流量特征 选择 流量要走的场景
     *
     * @param req
     * @return
     */
    @Override
    public StarndardScene getStarndardSceneByFlow(ObtainAdvertReq req) {


        StarndardScene starndardScene = null;

        String featureName = calFeatureName(req);
        if (StringUtils.isNotBlank(featureName)) {
            starndardScene = this.featureNameStarndardSceneMap.get(featureName);
        }

        //TODO req 中需要新增业务id 字段，目前 采用 写死0（兜底场景）
        Long id = 0L;
        if (null == starndardScene && null != id) {
            starndardScene = this.idStarndardSceneMap.get(id);
        }

        return (null != starndardScene) ? starndardScene : this.guaranteedStarndardScene;
    }

    private String calFeatureName(ObtainAdvertReq req) {

        return req.getAdxLoadType()
                +
                "&"
                +
                req.getActivitySceneType()
                +
                "&"
                +
                (ActPreUtils.isActPre(req) && ActPreUtils.getAdvertCount(req).equals(AdxServiceImpl.PRE_LAUNCH_ALL));

    }



    @EventListener(cn.com.duiba.boot.event.MainContextRefreshedEvent.class)
//    @Order(Ordered.HIGHEST_PRECEDENCE)
    public void  buildFactory(){

        List<ScenePropertyDto> propertyDtos = ScenePropertysConfig.properties;

        this.idStarndardSceneMap = new HashMap<>();
        this.featureNameStarndardSceneMap = new HashMap<>();


        propertyDtos.forEach(propertyDto->{

            //1、将场景 按 配置 初始化
            StarndardScene scene =  buildStarndardScene(propertyDto);
            Objects.requireNonNull(scene,"组件配置有误，无法初始化组件，配置="+ JSON.toJSONString(propertyDto));

            //2、构建场景缓存
            Long id = propertyDto.getId();
            Objects.requireNonNull(id,"组件配置有误，id为空，配置="+ JSON.toJSONString(propertyDto));
            idStarndardSceneMap.put(id,scene);

            String featureName = propertyDto.getFeature();
            if (StringUtils.isNotBlank(featureName)) {
                featureNameStarndardSceneMap.put(featureName,scene);
            }

            //3、兜底场景设置
            if(Objects.equals(0L,id)){
                //id = 0 的是 兜底场景 即 走老逻辑
                this.guaranteedStarndardScene = scene;
            }
        });

    }

    private StarndardScene buildStarndardScene(ScenePropertyDto propertyDto) {

        Objects.requireNonNull(propertyDto,"");

        List<String> workFlowConfig = propertyDto.getWorkFlow();
        WorkFlow workFlow = WorkFlowFactory.builldWorkFlow(workFlowConfig);
        Objects.requireNonNull(workFlow,"");

        StarndardScene scene = StarndardSceneImpl.builder().
                scenePropertyDto(propertyDto).
                workFlow(workFlow).
                build();

        return scene;
    }


    @Override
    public void afterPropertiesSet() throws Exception {
//        buildFactory(ScenePropertysConfig.properties);
    }
}
