package cn.com.duiba.tuia.standardscene.framework.impl;

import cn.com.duiba.tuia.standardscene.framework.StarndardScene;
import cn.com.duiba.tuia.standardscene.framework.TaskData;
import cn.com.duiba.tuia.standardscene.framework.WorkFlow;
import cn.com.duiba.tuia.standardscene.framework.dto.ScenePropertyDto;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import lombok.Builder;

@Builder
public class StarndardSceneImpl implements StarndardScene {

    // 1、场景相关的配置信息
    private ScenePropertyDto scenePropertyDto;

    // 2 以下流程可以包含在一个对象中
    // 2.1、组件 及 执行流程
    // 2.2、执行器
    private WorkFlow workFlow;


    /**
     * 基于请求判断是否需要的流量
     *
     * @param req
     * @return
     */
    @Override
    public boolean neededFlow(ObtainAdvertReq req) {
        return true;
    }

    /**
     * 同步执行 后面按需求 添加 异步执行方法
     *
     * @param req
     * @return
     */
    @Override
    public ObtainAdvertRsp excute(ObtainAdvertReq req) {

        TaskData taskData = buildTaskData(req);

        WorkFlow node = this.workFlow;
        while(null != node && !taskData.getFinished()){
            node.excute(taskData);
            node = node.next(taskData);
        }

        ObtainAdvertRsp rsp = taskData.getRsp();
        return rsp;
    }

    private TaskData buildTaskData(ObtainAdvertReq req) {
        return TaskData.builder().
                req(req).
                finished(false).
                build();
    }

}
