package cn.com.duiba.tuia.standardscene.scene;

import cn.com.duiba.tuia.standardscene.framework.StarndardScene;
import cn.com.duiba.tuia.standardscene.framework.StarndardSceneFactory;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class AdxServiceScene {

    @Autowired
    private StarndardSceneFactory starndardSceneFactory;


    public ObtainAdvertRsp loadAdvert(ObtainAdvertReq req) {

        StarndardScene starndardScene = null;
        try {
            starndardScene = chooseScene(req);
        } catch (Exception e) {
            log.error("场景选择异常，请求信息="+ JSON.toJSONString(req),e);
        }
        if(null == starndardScene){
            log.error("无法获取发券场景，抛弃流量，请求信息="+ JSON.toJSONString(req));
            return null;
        }


        ObtainAdvertRsp rsp = null;
        try {
            rsp = starndardScene.excute(req);
        } catch (Exception e) {
            log.error("场景调用异常，场景名称="+starndardScene,e);
        }

        return rsp;
    }


    private StarndardScene chooseScene(ObtainAdvertReq req) {

        //场景选择
        return starndardSceneFactory.getStarndardSceneByFlow(req);
    }


}
