package cn.com.duiba.tuia.strategy;

import cn.com.duiba.tuia.service.ShieldingStrategyService;
import cn.com.duiba.tuia.service.impl.DefaultStrategyServiceImpl;
import cn.com.duiba.tuia.service.impl.FlowStrategyServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by zhengjy on 2017/4/17.
 */
@Component
public class StrategyBeans implements InitializingBean,ApplicationContextAware {

    public static List<ShieldingStrategyService>   shieldingStrategies = Lists.newArrayList();

    public static Map<String,ShieldingStrategyService> shieldingStrategyMap = Maps.newHashMap();

    private ApplicationContext applicationContext;

    @Autowired
    private DefaultStrategyServiceImpl defaultStrategyServiceImpl;
    @Autowired
    private FlowStrategyServiceImpl flowStrategyServiceImpl;


    @Override
    public void afterPropertiesSet() throws Exception {
        shieldingStrategies.add(flowStrategyServiceImpl);
        shieldingStrategies.add(defaultStrategyServiceImpl);

        Collection<ShieldingStrategyService> list = BeanFactoryUtils.beansOfTypeIncludingAncestors(applicationContext, ShieldingStrategyService.class).values();
        for(ShieldingStrategyService ab : list){
            shieldingStrategyMap.put(ab.getShieldingStrategyType(),ab);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
