/**
 * 文件名： EngineSyncService.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月27日 下午2:36:10
 */
package cn.com.duiba.tuia.task;

import cn.com.duiba.tuia.core.api.enums.advert.AdvertPkgPeriodTypeEnum;
import cn.com.duiba.tuia.service.AdvertPeriodService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.ExecutorService;

/**
 * <功能详细描述>
 * <li>请求订单完成之后，需要增加减库存</li>
 * <li>增加扣费明细、改变账户余额、变更财务统计表、今日消费值</li>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月27日 下午2:36:10
 * @version:
 */
@Component
public class EngineSyncRealTimeService{

    private static Logger logger = LoggerFactory.getLogger(EngineSyncRealTimeService.class);
    
    @Resource
    private StringRedisTemplate            stringRedisTemplate;
    
    @Resource
    private ExecutorService executorService;

    @Autowired
    private AdvertPeriodService advertPeriodService;

    /**
     * 
     * addPeriodReq:(这里用一句话描述这个方法的作用). <br/>
     * 时段发券数量增加及有效状态判断
     * @author zp
     * @since JDK 1.6
     */
    public void addPeriodReq(final Long periodId, final Long periodValue, final String periodType){
        //只有投放类型为(每小时发券量/总发券量),
        boolean flag = (AdvertPkgPeriodTypeEnum.PERIOD_TYPE_HOUR_COUPON.getCode().equals(periodType)
                            || AdvertPkgPeriodTypeEnum.PERIOD_TYPE_COUNT_COUPON.getCode().equals(periodType));
        if(!flag){
            return;
        }

        executorService.submit(new Runnable() {
            @Override
            public void run() {
                try{
                    advertPeriodService.addPeriodCountAndEditCache(periodId,periodValue,periodType);
                }catch(Exception e){
                    logger.error("advertPeriodService.addPeriodCountAndEditCache periodId = [{}],periodValue = [{}],periodType = [{}]"+periodId,periodValue,periodType,e);
                }
            }
        });
    }
}
