package cn.com.duiba.tuia.task;

import javax.validation.constraints.NotNull;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

/**
 * MQ消息延时任务
 *
 * @author zhangbaiqiang
 * @date 2020/10/26
 */
public class MsgDelayTask implements Delayed {

    /**
     * 主键
     */
    private String key;

    /**
     * 业务参数
     */
    private String msg;

    /**
     * 延时执行的时间点（毫秒时间戳）
     */
    private long timestamp;

    public MsgDelayTask(String msg, String key, long timestamp) {
        this.msg = msg;
        this.key = key;
        this.timestamp = timestamp;
    }

    public String getMsg() {
        return msg;
    }

    public String getKey() {
        return key;
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        long diff = timestamp - System.currentTimeMillis();
        return unit.convert(diff, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@NotNull Delayed o) {
        return (int) (this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS));
    }
}
