/**
 * 文件名： UpdateValidStatusTask.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月23日 下午4:25:34
 */
package cn.com.duiba.tuia.task;

import java.util.concurrent.ExecutorService;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.bo.AdvertService;
import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import cn.com.duiba.tuia.cache.BaseCacheService;
import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.duiba.tuia.enums.AdvertSortTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;

/**
 * 广告状态事件 <br/>
 * <ol>
 * <li>广告主->发布广告->新增一条广告，状态为审核中-->置为无效</li>
 * <li>广告主 启用/暂停操作 广告状态变化 有效规则判断</li>
 * <li>广告主 修改优惠券描述 广告状态变为审核中 置为无效</li>
 * <li>广告主 补充优惠码库存 优惠券库存增加，状态变为审核中 置为无效</li>
 * <li>广告主 修改广告投放时间 当前时间是否在投放时间 有效规则判断</li>
 * <li>广告主 修改账户预算 账号剩余预算变化 有效规则判断</li>
 * <li>广告主 修改广告预算后 广告剩余预算变化 有效规则判断</li>
 * <li>广告主 修改出价 CPC变化 有效规则判断</li>
 * <li>用户 打开福袋 优惠券库存减少 无效规则判断，如果库存=0则置为无效</li>
 * <li>用户 点击扣费后 账号余额减少 无效规则判断，如果余额小于CPC则置为无效</li>
 * <li>用户 点击扣费后 账号剩余预算减少 无效规则判断，如果剩余账户预算小于CPC则置为无效</li>
 * <li>用户 点击扣费后 广告剩余预算减少 无效规则判断，如果剩余广告预算小于CPC则置为无效</li>
 * <li>广告后台 账户充值后 账号余额增加 有效规则判断，判断是否有效</li>
 * <li>广告后台 审核状态变更 广告审核状态变化 有效规则判断，判断是否有效</li>
 * <li>广告后台 冻结 账号冻结状态变化 置为无效</li>
 * <li>广告后台 解冻 帐号冻结状态变化 有效规则判断，判断是否有效</li>
 * <li>系统 0点后，时间到下一天 当前时间是否在投放时间 有效广告进行无效判断，无效广告进行有效判断</li>
 * </ol>
 * @author: sunjiangrong
 * @创建时间: 2016年4月23日 下午4:39:43
 * @version:
 */
@Component
public class UpdateValidStatusTask {

    private static Logger           log  = LoggerFactory.getLogger(UpdateValidStatusTask.class);
    @Autowired
    private AdvertService               advertService;
    @Autowired
    private ServiceManager          serviceManager;
    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;
    @Resource
    private ExecutorService executorService;
    
    @Autowired
    private BaseCacheService baseCacheService;
    
    public void execute(Long advertId,Integer newStatus) {
        executorService.submit(new Runnable() {
            @Override
            public void run() {
                try {
                    //直接置为无效, 更新完后应该更新缓存中的广告信息以及"有效"广告id列表
                    advertService.updateValidStatus(advertId, newStatus);
                    advertMapCacheManager.updateAdvertCache(advertId);
                    //广告优惠券缓存
                    serviceManager.updateAdvertCouponCache(advertId);
                    advertMapCacheManager.pushAdvertCacheUpdate(advertId);
                    //更新有效广告排序列表
                    baseCacheService.updateValidAdvertIdsCache(AdvertSortTypeEnum.ALL.getCode());

                    advertMapCacheManager.updateValidAdvertFilterCache(advertId);
                } catch (TuiaException e) {
                    log.error("sync updateValidStatus happen error, advertId = [{}]", advertId, e);
                }
            }
        });
    }
}
