/**
 * Project Name:media-biz File Name:Media.java Package Name:cn.com.duiba.tuia.media.domain Date:2016年9月26日上午11:32:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
/**
 * 
 */

package cn.com.duiba.tuia.media.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 媒体信息.
 *
 * @author: guyan
 * @version:
 */

public class MediaAppDto extends BaseDto {

    /** 序列ID. */
    private static final long  serialVersionUID           = 6133335694581286778L;

    /** 开通状态:0-待审核. */
    public static final int    MEDIA_APP_CHECKING         = 0;
    /** 开通状态:1-审核通过. */
    public static final int    MEDIA_APP_CHECK_PASS       = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int    MEDIA_APP_CHECK_FAIL       = 2;

    /** 系统平台:Android. */
    public static final String MEDIA_APP_PLATFORM_ANDROID = "Android";
    /** 系统平台:iOS. */
    public static final String MEDIA_APP_PLATFORM_IOS     = "iOS";

    /** 媒体用户ID. */
    private Long               mediaId;
    /** 应用ID. */
    private Long               appId;
    /** 应用标识. */
    private String             appKey;
    /** 应用名称. */
    private String             appName;
    /** app秘钥 */
    private String             appSecret;
    /** 行业. */
    private String             industry;
    /** 开通状态:0-待审核;1-审核通过;2-审核拒绝. */
    private Integer            checkStatus;
    /** 系统平台:Android或iOS. */
    private String             platform;
    /** 程序主包名. */
    private String             appPackage;
    /** 应用关键词. */
    private String             appKeyWords;
    /** 应用简介. */
    private String             description;
    /** 下载地址. */
    private String             downloadUrl;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppKeyWords() {
        return appKeyWords;
    }

    public void setAppKeyWords(String appKeyWords) {
        this.appKeyWords = appKeyWords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
