/**
 * Project Name:media-api<br>
 * File Name:ShieldStrategyBaseDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年9月29日下午3:19:22<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ShieldStrategyBaseDto <br/>
 * Function: 屏蔽策略信息. <br/>
 * date: 2016年9月29日 下午3:19:22 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class StrategyCacheDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 屏蔽行业列表，中间以逗号隔开. */
    private List<String>      shieldIndustries;

    /** 屏蔽广告列表，中间以逗号隔开. */
    private List<String>      advertTagNums;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    private List<String>      shieldUrls;

    public StrategyCacheDto() {
        super();
    }

    public StrategyCacheDto(List<String> shieldIndustries, List<String> advertTagNums, List<String> shieldUrls) {
        super();
        this.shieldIndustries = shieldIndustries;
        this.advertTagNums = advertTagNums;
        this.shieldUrls = shieldUrls;
    }

    public List<String> getShieldIndustries() {
        return shieldIndustries;
    }

    public void setShieldIndustries(List<String> shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    public List<String> getAdvertTagNums() {
        return advertTagNums;
    }

    public void setAdvertTagNums(List<String> advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    public List<String> getShieldUrls() {
        return shieldUrls;
    }

    public void setShieldUrls(List<String> shieldUrls) {
        this.shieldUrls = shieldUrls;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
