/**
 * Project Name:media-api<br>
 * File Name:SlotParam.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年11月1日上午11:44:53<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: SlotParam <br/>
 * Function: 广告参数. <br/>
 * date: 2016年11月1日 上午11:44:53 <br/>
 *
 * @author guyan
 * @version
 * @since JDK 1.6
 */
public class SlotTypeParamDto implements Serializable {

    /** 序列化ID */
    private static final long   serialVersionUID                    = 8208167000275549043L;
    
    /**类型数量*/
    public static final int     ADSENSE_TYPE_SIZE                   = 6;

    /** 广告位类型 0-插屏. */
    public static final Integer ADSENSE_TYPE_PLAQUE_NUM             = 0;
    /** 广告位类型 1-横幅. */
    public static final Integer ADSENSE_TYPE_STREAMER_BANNER_NUM    = 1;
    /** 广告位类型 2-信息流. */
    public static final Integer ADSENSE_TYPE_INFORMATION_STREAM_NUM = 2;
    /** 广告位类型 3-banner. */
    public static final Integer ADSENSE_TYPE_BANNER_NUM             = 3;
    /** 广告位类型 4-浮标. */
    public static final Integer ADSENSE_TYPE_BUOY_NUM               = 4;
    /** 广告位类型 5-应用墙. */
    public static final Integer ADSENSE_TYPE_APP_WALL_NUM           = 5;

    /** 广告位类型 0-插屏. */
    public static final String  ADSENSE_TYPE_PLAQUE                 = "插屏";
    /** 广告位类型 1-横幅. */
    public static final String  ADSENSE_TYPE_STREAMER_BANNER        = "横幅";
    /** 广告位类型 2-信息流. */
    public static final String  ADSENSE_TYPE_INFORMATION_STREAM     = "信息流";
    /** 广告位类型 3-banner. */
    public static final String  ADSENSE_TYPE_BANNER                 = "banner";
    /** 广告位类型 4-浮标. */
    public static final String  ADSENSE_TYPE_BUOY                   = "浮标";
    /** 广告位类型 5-应用墙. */
    public static final String  ADSENSE_TYPE_APP_WALL               = "应用墙";

    /** 主图尺寸 640*150. */
    public static final String  PICTURE_SIZE_640_150                = "640*150";
    /** 主图尺寸 500*500. */
    public static final String  PICTURE_SIZE_500_500                = "500*500";
    /** 主图尺寸 640*280. */
    public static final String  PICTURE_SIZE_640_280                = "640*280";
    /** 主图尺寸 150*150. */
    public static final String  PICTURE_SIZE_150_150                = "150*150";

    /** 主图尺寸 700*280. */
    public static final String  PICTURE_SIZE_700_280                = "700*280";
    /** 主图尺寸 225*140. */
    public static final String  PICTURE_SIZE_225_140                = "225*140";
    /** 75：42 广告尺寸 */
    public static final String  FLOW_TYPE_SIZE_750_420              = "750*420";
    /** 25：6 广告尺寸 */
    public static final String  FLOW_TYPE_SIZE_750_180              = "750*180";

    private List<String>        pictureSize;

    /** 广告信息流 */
    private List<String>        flowType;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private String              slotType;

    public List<String> getPictureSize() {
        return pictureSize;
    }

    public void setPictureSize(List<String> pictureSize) {
        this.pictureSize = pictureSize;
    }

    public String getSlotType() {
        return slotType;
    }

    public void setSlotType(String slotType) {
        this.slotType = slotType;
    }

    public List<String> getFlowType() {
        return flowType;
    }

    public void setFlowType(List<String> flowType) {
        this.flowType = flowType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
