/**
 * Project Name:media-manager-biz<br>
 * File Name:UpdateAccountStatusReq.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年9月28日下午8:12:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

/**
 * ClassName: UpdateAccountStatusReq <br/>
 * date: 2016年9月28日 下午8:12:24 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqUpdateAccountCheckStatus {

    /** 审核通过. */
    public static final Integer PARAM_CHECK_PASS   = 1;

    /** 审核拒绝. */
    public static final Integer PARAM_CHECK_REFUSE = 2;

    /** 媒体账户ID. */
    @ApiModelProperty(value = "媒体账户ID", required = true)
    @NotNull(message = "媒体账户ID不可为空")
    private Long                mediaId;

    /** 审核动作类型:2-冻结;3-解冻. */
    @ApiModelProperty(value = "审核动作类型,0-审核通过;1-审核拒绝;", required = true)
    @NotNull(message = "审核动作类型不可为空")
    @Max(value = 2, message = "审核动作类型错误")
    @Min(value = 1, message = "审核动作类型错误")
    private Integer             checkType;

    /** 审核不通过理由. */
    @ApiModelProperty(value = "不通过理由", required = true)
    @Length(max = 16, message = "审核不通过理由限制16汉字")
    private String              reason;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * checkType.
     *
     * @return the checkType
     * @since JDK 1.6
     */
    public Integer getCheckType() {
        return checkType;
    }

    /**
     * checkType.
     *
     * @param checkType the checkType to set
     * @since JDK 1.6
     */
    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    /**
     * reason.
     *
     * @return the reason
     * @since JDK 1.6
     */
    public String getReason() {
        return reason;
    }

    /**
     * reason.
     *
     * @param reason the reason to set
     * @since JDK 1.6
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
