/**
 * Project Name:media-biz<br/>
 * File Name:ReqAdsenseList.java<br/>
 * Package Name:cn.com.duiba.tuia.media.model.req<br/>
 * Date:2016年9月28日下午3:45:39<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.api.dto.req;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告位列表请求参数 <br/>
 * Date: 2016年9月28日 下午3:45:39 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqUpdateSlot implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 8447127897045201920L;

    @ApiModelProperty(value = "广告位ID", required = true)
    @NotNull(message = "广告位ID不能为空")
    private Long              slotId;

    @ApiModelProperty(value = "广告位名称", required = true)
    @NotNull(message = "广告位名称不能为空")
    private String            slotName;

    @ApiModelProperty(value = "选择媒体", required = true)
    @NotNull(message = "广告位必须关联一个媒体")
    private Long              appId;

    @ApiModelProperty(value = "广告位类型", required = true)
    @NotNull(message = "广告位类型不能为空")
    private Integer           slotType;

    @ApiModelProperty(value = "广告信息流类型", required = false)
    private Long              flowType;

    @ApiModelProperty(value = "主图尺寸", required = false)
    private Integer           pictureSize;

    @ApiModelProperty(value = "屏蔽策略", required = false)
    private Long              strategyId;

    @ApiModelProperty(value = "媒体账户ID", required = false)
    private Long              mediaId;

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * pictureSize.
     *
     * @return the pictureSize
     * @since JDK 1.6
     */
    public Integer getPictureSize() {
        return pictureSize;
    }

    /**
     * pictureSize.
     *
     * @param pictureSize the pictureSize to set
     * @since JDK 1.6
     */
    public void setPictureSize(Integer pictureSize) {
        this.pictureSize = pictureSize;
    }

    /**
     * strategyId.
     *
     * @return the strategyId
     * @since JDK 1.6
     */
    public Long getStrategyId() {
        return strategyId;
    }

    /**
     * strategyId.
     *
     * @param strategyId the strategyId to set
     * @since JDK 1.6
     */
    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * flowType.
     *
     * @return the flowType
     * @since JDK 1.6
     */
    public Long getFlowType() {
        return flowType;
    }

    /**
     * flowType.
     *
     * @param flowType the flowType to set
     * @since JDK 1.6
     */
    public void setFlowType(Long flowType) {
        this.flowType = flowType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
